/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.convert.impl;

import java.sql.Timestamp;
import java.util.Calendar;
import org.gjgr.pig.chivalrous.core.convert.AbstractConverter;
import org.gjgr.pig.chivalrous.core.date.DateTimeCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class SqlTimestampConverter
extends AbstractConverter<Timestamp> {
    private String format;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Timestamp convertInternal(Object value) {
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTime().getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        String valueStr = this.convertToStr(value);
        try {
            long date = StringCommand.isBlank(this.format) ? DateTimeCommand.parse(valueStr).getTime() : DateTimeCommand.parse(valueStr, this.format).getTime();
            return new Timestamp(date);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

