/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cron;

import org.gjgr.pig.chivalrous.core.cron.Scheduler;
import org.gjgr.pig.chivalrous.core.date.DateUnit;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.LogFactory;
import org.gjgr.pig.chivalrous.core.util.ThreadUtil;

public class CronTimer
extends Thread {
    private static final Log log = LogFactory.get();
    private long TIMER_UNIT_SECOND = DateUnit.SECOND.getMillis();
    private long TIMER_UNIT_MINUTE = DateUnit.MINUTE.getMillis();
    private Scheduler scheduler;

    public CronTimer(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        long nextTime;
        long sleep;
        long timerUnit = this.scheduler.matchSecond ? this.TIMER_UNIT_SECOND : this.TIMER_UNIT_MINUTE;
        long thisTime = System.currentTimeMillis();
        while ((sleep = (nextTime = (thisTime / timerUnit + 1L) * timerUnit) - System.currentTimeMillis()) <= 0L || ThreadUtil.safeSleep(sleep)) {
            thisTime = System.currentTimeMillis();
            this.spawnLauncher(thisTime);
        }
        log.debug("Hutool Cron Timer stoped.", new Object[0]);
    }

    private void spawnLauncher(long millis) {
        this.scheduler.taskLauncherManager.spawnLauncher(millis);
    }
}

