/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.cron;

import java.util.ArrayList;
import java.util.List;
import org.gjgr.pig.chivalrous.core.cron.Scheduler;
import org.gjgr.pig.chivalrous.core.cron.TaskLauncher;
import org.gjgr.pig.chivalrous.core.util.ThreadUtil;

public class TaskLauncherManager {
    protected Scheduler scheduler;
    protected List<TaskLauncher> launchers = new ArrayList<TaskLauncher>();

    public TaskLauncherManager(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TaskLauncher spawnLauncher(long millis) {
        TaskLauncher launcher = new TaskLauncher(this.scheduler, millis);
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            this.launchers.add(launcher);
        }
        launcher.setDaemon(this.scheduler.daemon);
        launcher.start();
        return launcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyLauncherCompleted(TaskLauncher launcher) {
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            this.launchers.remove(launcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskLauncherManager destroy() {
        List<TaskLauncher> list = this.launchers;
        synchronized (list) {
            for (TaskLauncher taskLauncher : this.launchers) {
                ThreadUtil.interupt(taskLauncher, true);
            }
        }
        this.launchers.clear();
        return this;
    }
}

