/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto;

import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.UUID;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.AsymmetricType;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.DSA;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.RSA;
import org.gjgr.pig.chivalrous.core.crypto.digest.DigestType;
import org.gjgr.pig.chivalrous.core.crypto.digest.Digester;
import org.gjgr.pig.chivalrous.core.crypto.digest.HMac;
import org.gjgr.pig.chivalrous.core.crypto.digest.HmacAlgorithm;
import org.gjgr.pig.chivalrous.core.crypto.symmetric.SymmetricAlgorithm;
import org.gjgr.pig.chivalrous.core.crypto.symmetric.SymmetricCrypto;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.Base64;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.gjgr.pig.chivalrous.core.util.RandomCommand;

public final class CryptoCommand {
    public static final int DEFAULT_KEY_SIZE = 1024;

    private CryptoCommand() {
    }

    public static SecretKey secretKey(String algorithm) {
        SecretKey secretKey;
        try {
            secretKey = KeyGenerator.getInstance(algorithm).generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        return secretKey;
    }

    public static SecretKey secretKey(String algorithm, byte[] key) {
        AssertCommand.notBlank(algorithm, "Algorithm is blank!");
        SecretKey secretKey = null;
        secretKey = algorithm.startsWith("PBE") ? CryptoCommand.secretKeyUsingPBE(algorithm, null == key ? null : StringCommand.str(key, CharsetCommand.CHARSET_UTF_8).toCharArray()) : (algorithm.startsWith("DES") ? CryptoCommand.secretKeyUsingDES(algorithm, key) : (null == key ? CryptoCommand.secretKey(algorithm) : new SecretKeySpec(key, algorithm)));
        return secretKey;
    }

    public static SecretKey secretKeyUsingDES(String algorithm, byte[] key) {
        if (StringCommand.isBlank(algorithm) || !algorithm.startsWith("DES")) {
            throw new CryptoException("Algorithm [{}] is not a DES algorithm!");
        }
        SecretKey secretKey = null;
        if (null == key) {
            secretKey = CryptoCommand.secretKey(algorithm);
        } else {
            DESKeySpec keySpec;
            try {
                keySpec = new DESKeySpec(key);
            }
            catch (InvalidKeyException e) {
                throw new CryptoException(e);
            }
            secretKey = CryptoCommand.secretKey(algorithm, keySpec);
        }
        return secretKey;
    }

    public static SecretKey secretKeyUsingPBE(String algorithm, char[] key) {
        if (StringCommand.isBlank(algorithm) || !algorithm.startsWith("PBE")) {
            throw new CryptoException("Algorithm [{}] is not a PBE algorithm!");
        }
        if (null == key) {
            key = RandomCommand.randomString(32).toCharArray();
        }
        PBEKeySpec keySpec = new PBEKeySpec(key);
        return CryptoCommand.secretKey(algorithm, keySpec);
    }

    public static SecretKey secretKey(String algorithm, KeySpec keySpec) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            return keyFactory.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey privateKey(String algorithm, byte[] key) {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance(algorithm).generatePrivate(pkcs8KeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey privateKey(KeyStore keyStore, String alias, char[] password) {
        try {
            return (PrivateKey)keyStore.getKey(alias, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static PublicKey publicKey(String algorithm, byte[] key) {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
        try {
            return KeyFactory.getInstance(algorithm).generatePublic(x509KeySpec);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static KeyPair keyPair(String algorithm) {
        return CryptoCommand.keyPair(algorithm, 1024, null);
    }

    public static KeyPair keyPair(String algorithm, int keySize) {
        return CryptoCommand.keyPair(algorithm, keySize, null);
    }

    public static KeyPair keyPair(String algorithm, int keySize, byte[] seed) {
        KeyPairGenerator keyPairGen;
        try {
            keyPairGen = KeyPairGenerator.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
        if (keySize <= 0) {
            keySize = 1024;
        }
        if (null != seed) {
            SecureRandom random = new SecureRandom(seed);
            keyPairGen.initialize(keySize, random);
        } else {
            keyPairGen.initialize(keySize);
        }
        return keyPairGen.generateKeyPair();
    }

    public static Signature signature(AsymmetricType asymmetricType, DigestType digestType) {
        String digestPart = null == digestType ? "NONE" : digestType.name();
        String algorithm = StringCommand.format("{}with{}", digestPart, asymmetricType.getValue());
        try {
            return Signature.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException(e);
        }
    }

    public static KeyStore keyStore(InputStream in, char[] password) {
        return CryptoCommand.keyStore("JKS", in, password);
    }

    public static KeyStore keyStore(String type, InputStream in, char[] password) {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance(type);
            keyStore.load(in, password);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return keyStore;
    }

    public static Certificate certificate(InputStream in, char[] password) {
        return CryptoCommand.certificate("X.509", in, password);
    }

    public static Certificate certificate(String type, InputStream in, char[] password) {
        Certificate certificate;
        try {
            certificate = CertificateFactory.getInstance(type).generateCertificate(in);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return certificate;
    }

    public static Certificate certificate(KeyStore keyStore, String alias) {
        try {
            return keyStore.getCertificate(alias);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
    }

    public static SymmetricCrypto aes() {
        return new SymmetricCrypto(SymmetricAlgorithm.AES);
    }

    public static SymmetricCrypto aes(byte[] key) {
        return new SymmetricCrypto(SymmetricAlgorithm.AES, key);
    }

    public static SymmetricCrypto des() {
        return new SymmetricCrypto(SymmetricAlgorithm.DES);
    }

    public static SymmetricCrypto des(byte[] key) {
        return new SymmetricCrypto(SymmetricAlgorithm.DES, key);
    }

    public static Digester md5() {
        return new Digester(DigestType.MD5);
    }

    public static String md5(String data) {
        return new Digester(DigestType.MD5).digestHex(data);
    }

    public static String md5(InputStream data) {
        return new Digester(DigestType.MD5).digestHex(data);
    }

    public static String md5(File dataFile) {
        return new Digester(DigestType.MD5).digestHex(dataFile);
    }

    public static String md5(byte[] bytes) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        byte[] md5Bytes = md5.digest(bytes);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static String hexMD5(String value) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        messageDigest.reset();
        try {
            messageDigest.update(value.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
        byte[] digest = messageDigest.digest();
        return Hex.encodeHexString((byte[])digest);
    }

    public static Digester sha1() {
        return new Digester(DigestType.SHA1);
    }

    public static String sha1(String data) {
        return new Digester(DigestType.SHA1).digestHex(data);
    }

    public static String sha1(InputStream data) {
        return new Digester(DigestType.SHA1).digestHex(data);
    }

    public static String sha1(File dataFile) {
        return new Digester(DigestType.SHA1).digestHex(dataFile);
    }

    public static HMac hmac(HmacAlgorithm algorithm, byte[] key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmac(HmacAlgorithm algorithm, SecretKey key) {
        return new HMac(algorithm, key);
    }

    public static HMac hmacMd5(byte[] key) {
        return new HMac(HmacAlgorithm.HmacMD5, key);
    }

    public static HMac hmacMd5() {
        return new HMac(HmacAlgorithm.HmacMD5);
    }

    public static HMac hmacSha1(byte[] key) {
        return new HMac(HmacAlgorithm.HmacSHA1, key);
    }

    public static HMac hmacSha1() {
        return new HMac(HmacAlgorithm.HmacSHA1);
    }

    public static RSA rsa() {
        return new RSA();
    }

    public static RSA rsa(String privateKeyBase64, String publicKeyBase64) {
        return new RSA(privateKeyBase64, publicKeyBase64);
    }

    public static RSA rsa(byte[] privateKey, byte[] publicKey) {
        return new RSA(privateKey, privateKey);
    }

    public static DSA dsa() {
        return new DSA();
    }

    public static DSA dsa(String privateKeyBase64, String publicKeyBase64) {
        return new DSA(privateKeyBase64, publicKeyBase64);
    }

    public static DSA dsa(byte[] privateKey, byte[] publicKey) {
        return new DSA(privateKey, privateKey);
    }

    public static String simpleUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    public static String base64Encode(byte[] input, int flags) {
        return Base64.encodeToString(input, flags);
    }

    public static String base64EncodeString(String string) {
        return Base64.encode(string);
    }

    public static String base64DecodeString(String string) {
        return Base64.decodeStr(string);
    }

    public static String id(String prefix, String suffix) {
        return CryptoCommand.md5(prefix + ":" + suffix);
    }

    public static String jointId(String prefix, String suffix) {
        return String.format("%s:%s", prefix, suffix);
    }
}

