/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.asymmetric;

import java.security.Key;
import java.security.interfaces.RSAKey;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.AsymmetricCrypto;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.AsymmetricType;
import org.gjgr.pig.chivalrous.core.crypto.asymmetric.KeyType;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.BCD;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public class RSA
extends AsymmetricCrypto {
    private static final AsymmetricType ALGORITHM_RSA = AsymmetricType.RSA;

    public RSA() {
        super(ALGORITHM_RSA);
    }

    public RSA(String privateKeyBase64, String publicKeyBase64) {
        super(ALGORITHM_RSA, privateKeyBase64, publicKeyBase64);
    }

    public RSA(byte[] privateKey, byte[] publicKey) {
        super(ALGORITHM_RSA, privateKey, publicKey);
    }

    public String encryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StringCommand.builder();
        this.lock.lock();
        try {
            String[] datas;
            this.clipher.init(1, key);
            for (String s : datas = StringCommand.split(data, keyLength - 11)) {
                sb.append(BCD.bcdToStr(this.clipher.doFinal(s.getBytes())));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }

    public String decryptStr(String data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        int keyLength = ((RSAKey)((Object)key)).getModulus().bitLength() / 8;
        StringBuilder sb = StringCommand.builder();
        this.lock.lock();
        try {
            byte[][] arrays;
            this.clipher.init(2, key);
            byte[] bcd = BCD.ascToBcd(StringCommand.utf8Bytes(data));
            for (byte[] arr : arrays = ArrayCommand.split(bcd, keyLength)) {
                sb.append(StringCommand.str(this.clipher.doFinal(arr), CharsetCommand.CHARSET_UTF_8));
            }
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
        return sb.toString();
    }
}

