/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.gjgr.pig.chivalrous.core.crypto.CryptoCommand;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.digest.HmacAlgorithm;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.HexCommand;

public class HMac {
    private Mac mac;
    private SecretKey secretKey;

    public HMac(HmacAlgorithm algorithm) {
        this(algorithm, (SecretKey)null);
    }

    public HMac(HmacAlgorithm algorithm, byte[] key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac(HmacAlgorithm algorithm, SecretKey key) {
        this.init(algorithm.getValue(), key);
    }

    public HMac init(String algorithm, byte[] key) {
        return this.init(algorithm, null == key ? null : new SecretKeySpec(key, algorithm));
    }

    public HMac init(String algorithm, SecretKey key) {
        try {
            this.mac = Mac.getInstance(algorithm);
            this.secretKey = null != key ? key : CryptoCommand.secretKey(algorithm);
            this.mac.init(this.secretKey);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] digest(String data, String charset) {
        return this.digest(StringCommand.bytes(data, charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, "UTF-8");
    }

    public String digestHex(String data, String charset) {
        return HexCommand.encodeHexStr(this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, "UTF-8");
    }

    public byte[] digest(File file) {
        BufferedInputStream in = null;
        try {
            in = IoCommand.bufferedInputStream(file);
            byte[] byArray = this.digest(in);
            return byArray;
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public String digestHex(File file) {
        return HexCommand.encodeHexStr(this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        try {
            result = this.mac.doFinal(data);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(byte[] data) {
        return HexCommand.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 1024);
    }

    public String digestHex(InputStream data) {
        return HexCommand.encodeHexStr(this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        if (bufferLength < 1) {
            bufferLength = 1024;
        }
        byte[] buffer = new byte[bufferLength];
        byte[] result = null;
        try {
            int read = data.read(buffer, 0, bufferLength);
            while (read > -1) {
                this.mac.update(buffer, 0, read);
                read = data.read(buffer, 0, bufferLength);
            }
            result = this.mac.doFinal();
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
        finally {
            this.mac.reset();
        }
        return result;
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexCommand.encodeHexStr(this.digest(data, bufferLength));
    }

    public Mac getMac() {
        return this.mac;
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }
}

