/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.crypto.symmetric;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEParameterSpec;
import org.gjgr.pig.chivalrous.core.crypto.CryptoCommand;
import org.gjgr.pig.chivalrous.core.crypto.CryptoException;
import org.gjgr.pig.chivalrous.core.crypto.symmetric.SymmetricAlgorithm;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.HexCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.gjgr.pig.chivalrous.core.util.RandomCommand;

public class SymmetricCrypto {
    private SecretKey secretKey;
    private Cipher clipher;
    private AlgorithmParameterSpec params;
    private Lock lock = new ReentrantLock();

    public SymmetricCrypto(SymmetricAlgorithm algorithm) {
        this(algorithm, null);
    }

    public SymmetricCrypto(String algorithm) {
        this(algorithm, null);
    }

    public SymmetricCrypto(SymmetricAlgorithm algorithm, byte[] key) {
        this(algorithm.getValue(), key);
    }

    public SymmetricCrypto(String algorithm, byte[] key) {
        this.init(algorithm, key);
    }

    public SymmetricCrypto init(String algorithm, byte[] key) {
        return this.init(algorithm, CryptoCommand.secretKey(algorithm, key));
    }

    public SymmetricCrypto init(String algorithm, SecretKey key) {
        this.secretKey = key;
        if (algorithm.startsWith("PBE")) {
            this.params = new PBEParameterSpec(RandomCommand.randomBytes(8), 100);
        }
        try {
            this.clipher = Cipher.getInstance(algorithm);
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        return this;
    }

    public byte[] encrypt(byte[] data) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.clipher.init(1, this.secretKey);
            } else {
                this.clipher.init(1, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.clipher.doFinal(data);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String encryptHex(byte[] data) {
        return HexCommand.encodeHexStr(this.encrypt(data));
    }

    public byte[] encrypt(String data, String charset) {
        return this.encrypt(StringCommand.bytes(data, charset));
    }

    public String encryptHex(String data, String charset) {
        return HexCommand.encodeHexStr(this.encrypt(data, charset));
    }

    public byte[] encrypt(String data) {
        return this.encrypt(StringCommand.bytes(data, CharsetCommand.CHARSET_UTF_8));
    }

    public String encryptHex(String data) {
        return HexCommand.encodeHexStr(this.encrypt(data));
    }

    public byte[] encrypt(InputStream data) {
        try {
            return this.encrypt(IoCommand.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public String encryptHex(InputStream data) {
        return HexCommand.encodeHexStr(this.encrypt(data));
    }

    public byte[] decrypt(byte[] bytes) {
        this.lock.lock();
        try {
            if (null == this.params) {
                this.clipher.init(2, this.secretKey);
            } else {
                this.clipher.init(2, (Key)this.secretKey, this.params);
            }
            byte[] byArray = this.clipher.doFinal(bytes);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String decryptStr(byte[] bytes, Charset charset) {
        return StringCommand.str(this.decrypt(bytes), charset);
    }

    public String decryptStr(byte[] bytes) {
        return this.decryptStr(bytes, CharsetCommand.CHARSET_UTF_8);
    }

    public byte[] decrypt(String data) {
        return this.decrypt(HexCommand.decodeHex(data));
    }

    public String decryptStr(String data, Charset charset) {
        return StringCommand.str(this.decrypt(data), charset);
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, CharsetCommand.CHARSET_UTF_8);
    }

    public byte[] decrypt(InputStream data) {
        try {
            return this.decrypt(IoCommand.readBytes(data));
        }
        catch (IOException e) {
            throw new CryptoException(e);
        }
    }

    public String decryptStr(InputStream data, Charset charset) {
        return StringCommand.str(this.decrypt(data), charset);
    }

    public String decryptStr(InputStream data) {
        return this.decryptStr(data, CharsetCommand.CHARSET_UTF_8);
    }

    public SecretKey getSecretKey() {
        return this.secretKey;
    }

    public Cipher getClipher() {
        return this.clipher;
    }
}

