/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.date;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.gjgr.pig.chivalrous.core.date.BetweenFormater;
import org.gjgr.pig.chivalrous.core.date.DateBetween;
import org.gjgr.pig.chivalrous.core.date.DateException;
import org.gjgr.pig.chivalrous.core.date.DateField;
import org.gjgr.pig.chivalrous.core.date.DateStyle;
import org.gjgr.pig.chivalrous.core.date.DateTime;
import org.gjgr.pig.chivalrous.core.date.DateUnit;
import org.gjgr.pig.chivalrous.core.date.PigMonth;
import org.gjgr.pig.chivalrous.core.date.PigWeek;
import org.gjgr.pig.chivalrous.core.date.SimpleLunarCalendar;
import org.gjgr.pig.chivalrous.core.date.TimeInterval;
import org.gjgr.pig.chivalrous.core.date.format.DateTimeFormatter;
import org.gjgr.pig.chivalrous.core.date.format.DateTimeParser;
import org.gjgr.pig.chivalrous.core.date.format.DateTimePrinter;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class DateTimeCommand {
    private static final ThreadLocal<SimpleDateFormat> threadLocal = new ThreadLocal();
    private static final Object object = new Object();

    public static DateTime dateTime() {
        return new DateTime();
    }

    public static DateTime dateTime(long date) {
        return new DateTime(date);
    }

    public static DateTime dateTime(Calendar calendar) {
        return new DateTime(calendar);
    }

    public static Calendar calendar(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static String now() {
        return DateTimeCommand.formatDateTime(new DateTime());
    }

    public static long current(boolean isNano) {
        return isNano ? System.nanoTime() : System.currentTimeMillis();
    }

    public static String today() {
        return DateTimeCommand.formatDate(new DateTime());
    }

    public static int year(Date date) {
        return DateTime.of(date).year();
    }

    public static int season(Date date) {
        return DateTime.of(date).season();
    }

    public static int month(Date date) {
        return DateTime.of(date).month();
    }

    public static PigMonth monthEnum(Date date) {
        return DateTime.of(date).monthEnum();
    }

    public static int weekOfYear(Date date) {
        return DateTime.of(date).weekOfYear();
    }

    public static int weekOfMonth(Date date) {
        return DateTime.of(date).weekOfMonth();
    }

    public static int dayOfMonth(Date date) {
        return DateTime.of(date).dayOfMonth();
    }

    public static int dayOfWeek(Date date) {
        return DateTime.of(date).dayOfWeek();
    }

    public static PigWeek dayOfWeekEnum(Date date) {
        return DateTime.of(date).dayOfWeekEnum();
    }

    public static int hour(Date date, boolean is24HourClock) {
        return DateTime.of(date).hour(is24HourClock);
    }

    public static int minute(Date date) {
        return DateTime.of(date).minute();
    }

    public static int second(Date date) {
        return DateTime.of(date).second();
    }

    public static int millsecond(Date date) {
        return DateTime.of(date).millsecond();
    }

    public static boolean isAM(Date date) {
        return DateTime.of(date).isAM();
    }

    public static boolean isPM(Date date) {
        return DateTime.of(date).isPM();
    }

    public static int thisYear() {
        return DateTimeCommand.year(DateTimeCommand.dateTime());
    }

    public static int thisMonth() {
        return DateTimeCommand.month(DateTimeCommand.dateTime());
    }

    public static PigMonth thisMonthEnum() {
        return DateTimeCommand.monthEnum(DateTimeCommand.dateTime());
    }

    public static int thisWeekOfYear() {
        return DateTimeCommand.weekOfYear(DateTimeCommand.dateTime());
    }

    public static int thisWeekOfMonth() {
        return DateTimeCommand.weekOfMonth(DateTimeCommand.dateTime());
    }

    public static int thisDayOfMonth() {
        return DateTimeCommand.dayOfMonth(DateTimeCommand.dateTime());
    }

    public static int thisDayOfWeek() {
        return DateTimeCommand.dayOfWeek(DateTimeCommand.dateTime());
    }

    public static PigWeek thisDayOfWeekEnum() {
        return DateTimeCommand.dayOfWeekEnum(DateTimeCommand.dateTime());
    }

    public static int thisHour(boolean is24HourClock) {
        return DateTimeCommand.hour(DateTimeCommand.dateTime(), is24HourClock);
    }

    public static int thisMinute() {
        return DateTimeCommand.minute(DateTimeCommand.dateTime());
    }

    public static int thisSecond() {
        return DateTimeCommand.second(DateTimeCommand.dateTime());
    }

    public static int thisMillsecond() {
        return DateTimeCommand.millsecond(DateTimeCommand.dateTime());
    }

    public static String yearAndSeason(Date date) {
        return DateTimeCommand.yearAndSeason(DateTimeCommand.calendar(date));
    }

    public static LinkedHashSet<String> yearAndSeasons(Date startDate, Date endDate) {
        LinkedHashSet<String> seasons = new LinkedHashSet<String>();
        if (startDate == null || endDate == null) {
            return seasons;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        while (true) {
            if (startDate.after(endDate)) {
                startDate = endDate;
            }
            seasons.add(DateTimeCommand.yearAndSeason(cal));
            if (startDate.equals(endDate)) break;
            cal.add(2, 3);
            startDate = cal.getTime();
        }
        return seasons;
    }

    public static String format(Date date, String format) {
        return DateTimeCommand.format(date, DateTimeFormatter.getInstance(format));
    }

    public static String format(Date date, DateTimePrinter format) {
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        return format.format(date);
    }

    public static String formatDateTime(Date date) {
        if (null == date) {
            return null;
        }
        return DateTimeFormatter.getInstance(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()).format(date);
    }

    public static String formatDate(Date date) {
        if (null == date) {
            return null;
        }
        return DateTimeFormatter.getInstance(DateStyle.YYYY_MM_DD.getValue()).format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return DateTimeFormatter.getInstance(DateStyle.HH_MM_SS.getValue()).format(date);
    }

    public static String formatHttpDate(Date date) {
        if (null == date) {
            return null;
        }
        return DateTimeFormatter.getInstance(DateStyle.HTTP_DATESTYLE_DEFAULT.getValue()).format(date);
    }

    public static DateTime parse(String dateStr, DateFormat dateFormat) {
        return new DateTime(dateStr, dateFormat);
    }

    public static DateTime parse(String dateStr, DateTimeParser parser) {
        return new DateTime(dateStr, parser);
    }

    public static DateTime parse(String dateStr, String format) {
        return new DateTime(dateStr, format);
    }

    public static DateTime parseDateTime(String dateString) {
        return DateTimeCommand.parse(dateString, DateTimeFormatter.getInstance(DateStyle.YYYY_MM_DD_HH_MM_SS.getValue()));
    }

    public static DateTime parseDate(String dateString) {
        return DateTimeCommand.parse(dateString, DateTimeFormatter.getInstance(DateStyle.YYYY_MM_DD.getValue()));
    }

    public static DateTime parseTime(String timeString) {
        return DateTimeCommand.parse(timeString, DateTimeFormatter.getInstance(DateStyle.HH_MM_SS.getValue()));
    }

    public static DateTime parse(String dateStr) {
        if (null == dateStr) {
            return null;
        }
        dateStr = dateStr.trim();
        int length = dateStr.length();
        try {
            if (length == DateStyle.YYYY_MM_DD_HH_MM_SS.getValue().length()) {
                return DateTimeCommand.parseDateTime(dateStr);
            }
            if (length == DateStyle.YYYY_MM_DD.getValue().length()) {
                return DateTimeCommand.parseDate(dateStr);
            }
            if (length == DateStyle.HH_MM_SS.getValue().length()) {
                return DateTimeCommand.parseTime(dateStr);
            }
            if (length == DateStyle.YYYY_MM_DD_HH_MM.getValue().length()) {
                return DateTimeCommand.parse(dateStr, DateStyle.YYYY_MM_DD_HH_MM.getValue());
            }
            if (length >= DateStyle.EN_YYYY_MM_DD_HH_MM_SS_SSS.getValue().length() - 2) {
                return DateTimeCommand.parse(dateStr, DateStyle.EN_YYYY_MM_DD_HH_MM_SS_SSS.getValue());
            }
        }
        catch (Exception e) {
            throw new DateException(StringCommand.format("Parse [{}] with format normal error!", dateStr));
        }
        throw new DateException(StringCommand.format(" [{}] format is not fit for dateTime pattern!", dateStr));
    }

    public static DateTime beginOfDateTime(Date date) {
        return new DateTime(DateTimeCommand.beginOfDayCalendar(DateTimeCommand.calendar(date)));
    }

    public static DateTime endOfDateTime(Date date) {
        return new DateTime(DateTimeCommand.endOfDayCalendar(DateTimeCommand.calendar(date)));
    }

    public static Calendar beginOfDayCalendar(Calendar calendar) {
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Date beginOfDay(Date date) {
        return DateTimeCommand.beginOfDay(date.getTime());
    }

    public static Date endOfDay(Date date) {
        return DateTimeCommand.endOfDay(date.getTime());
    }

    public static Date endOfDay(long l) {
        Calendar calendar = DateTimeCommand.calendar(l);
        return DateTimeCommand.endOfDayCalendar(calendar).getTime();
    }

    public static Date beginOfDay(long l) {
        Calendar calendar = DateTimeCommand.calendar(l);
        return DateTimeCommand.beginOfDayCalendar(calendar).getTime();
    }

    public static Calendar endOfDayCalendar(Calendar calendar) {
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar;
    }

    public static DateTime beginOfWeekDateTime(Date date) {
        return new DateTime(DateTimeCommand.beginOfWeekCalendar(DateTimeCommand.calendar(date)));
    }

    public static DateTime endOfWeekDateTime(Date date) {
        return new DateTime(DateTimeCommand.endOfWeekCalendar(DateTimeCommand.calendar(date)));
    }

    public static Calendar beginOfWeekCalendar(Calendar calendar) {
        calendar.set(7, 1);
        return DateTimeCommand.beginOfDayCalendar(calendar);
    }

    public static Calendar endOfWeekCalendar(Calendar calendar) {
        calendar.set(7, 7);
        return DateTimeCommand.endOfDayCalendar(calendar);
    }

    public static DateTime beginOfMonthDateTime(Date date) {
        return new DateTime(DateTimeCommand.beginOfMonthCalendar(DateTimeCommand.calendar(date)));
    }

    public static DateTime endOfMonthDateTime(Date date) {
        return new DateTime(DateTimeCommand.endOfMonthCalendar(DateTimeCommand.calendar(date)));
    }

    public static Calendar beginOfMonthCalendar(Calendar calendar) {
        calendar.set(5, 1);
        return DateTimeCommand.beginOfDayCalendar(calendar);
    }

    public static Calendar endOfMonthCalendar(Calendar calendar) {
        calendar.set(5, calendar.getActualMaximum(5));
        return DateTimeCommand.endOfDayCalendar(calendar);
    }

    public static DateTime beginOfYearDateTime(Date date) {
        return new DateTime(DateTimeCommand.beginOfYearCalendar(DateTimeCommand.calendar(date)));
    }

    public static DateTime endOfYearDateTime(Date date) {
        return new DateTime(DateTimeCommand.endOfYearCalendar(DateTimeCommand.calendar(date)));
    }

    public static Calendar beginOfYearCalendar(Calendar calendar) {
        calendar.set(2, 1);
        return DateTimeCommand.beginOfMonthCalendar(calendar);
    }

    public static Calendar endOfYearCalendar(Calendar calendar) {
        calendar.set(2, 11);
        return DateTimeCommand.endOfMonthCalendar(calendar);
    }

    public static DateTime yesterdayOfDateTime() {
        return DateTimeCommand.offsetDayOfDateTime(new DateTime(), -1);
    }

    public static DateTime tomorrowOfDateTime() {
        return DateTimeCommand.offsetDayOfDateTime(new DateTime(), 1);
    }

    public static DateTime lastWeekOfDateTime() {
        return DateTimeCommand.offsetWeekOfDateTime(new DateTime(), -1);
    }

    public static DateTime nextWeekOfDateTime() {
        return DateTimeCommand.offsetWeekOfDateTime(new DateTime(), 1);
    }

    public static DateTime lastMonthOfDateTime() {
        return DateTimeCommand.offsetMonthOfDateTime(new DateTime(), -1);
    }

    public static DateTime nextMonthOfDateTime() {
        return DateTimeCommand.offsetMonthOfDateTime(new DateTime(), 1);
    }

    public static DateTime offsetMillisecondOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.MILLISECOND, offset);
    }

    public static DateTime offsetSecondOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.SECOND, offset);
    }

    public static DateTime offsetMinuteOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.MINUTE, offset);
    }

    public static DateTime offsetHourOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.HOUR_OF_DAY, offset);
    }

    public static DateTime offsetDayOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.DAY_OF_YEAR, offset);
    }

    public static DateTime offsetWeekOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.WEEK_OF_YEAR, offset);
    }

    public static DateTime offsetMonthOfDateTime(Date date, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, DateField.MONTH, offset);
    }

    public static DateTime offsetOfDateTime(Date date, DateField dateField, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(dateField.getValue(), offset);
        return new DateTime(cal.getTime());
    }

    public static DateTime offsetDateTime(Date date, DateField dateField, int offset) {
        return DateTimeCommand.offsetOfDateTime(date, dateField, offset);
    }

    public static long between(Date beginDate, Date endDate, DateUnit unit) {
        return new DateBetween(beginDate, endDate).between(unit);
    }

    public static long betweenMs(Date beginDate, Date endDate) {
        return new DateBetween(beginDate, endDate).between(DateUnit.MS);
    }

    public static long betweenDay(Date beginDate, Date endDate, boolean isReset) {
        if (isReset) {
            beginDate = DateTimeCommand.beginOfDay(beginDate);
            endDate = DateTimeCommand.beginOfDay(endDate);
        }
        return DateTimeCommand.between(beginDate, endDate, DateUnit.DAY);
    }

    public static String formatBetween(Date beginDate, Date endDate, BetweenFormater.Level level) {
        return DateTimeCommand.formatBetween(DateTimeCommand.between(beginDate, endDate, DateUnit.MS), level);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return DateTimeCommand.formatBetween(DateTimeCommand.between(beginDate, endDate, DateUnit.MS));
    }

    public static String formatBetween(long betweenMs, BetweenFormater.Level level) {
        return new BetweenFormater(betweenMs, level).format();
    }

    public static String formatBetween(long betweenMs) {
        return new BetweenFormater(betweenMs, BetweenFormater.Level.MILLSECOND).format();
    }

    public static long spendNt(long preTime) {
        return System.nanoTime() - preTime;
    }

    public static long spendMs(long preTime) {
        return System.currentTimeMillis() - preTime;
    }

    public static int toIntSecond(Date date) {
        return Integer.parseInt(DateTimeCommand.format(date, "yyMMddHHmm"));
    }

    public static int weekCount(Date start, Date end) {
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(start);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(end);
        int startWeekofYear = startCalendar.get(3);
        int endWeekofYear = endCalendar.get(3);
        int count = endWeekofYear - startWeekofYear + 1;
        if (1 != startCalendar.get(7)) {
            --count;
        }
        return count;
    }

    public static TimeInterval timer() {
        return new TimeInterval();
    }

    public static int ageOfNow(String birthDay) {
        return DateTimeCommand.ageOfNow(DateTimeCommand.parse(birthDay));
    }

    public static int ageOfNow(Date birthDay) {
        return DateTimeCommand.age(birthDay, DateTimeCommand.dateTime());
    }

    public static int age(Date birthDay, Date dateToCompare) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dateToCompare);
        if (cal.before(birthDay)) {
            throw new IllegalArgumentException(StringCommand.format("Birthday is after dateTime {}!", DateTimeCommand.formatDate(dateToCompare)));
        }
        int year = cal.get(1);
        int month = cal.get(2);
        int dayOfMonth = cal.get(5);
        cal.setTime(birthDay);
        int age = year - cal.get(1);
        int monthBirth = cal.get(2);
        if (month == monthBirth) {
            int dayOfMonthBirth = cal.get(5);
            if (dayOfMonth < dayOfMonthBirth) {
                --age;
            }
        } else if (month < monthBirth) {
            --age;
        }
        return age;
    }

    public static boolean isLeapYear(int year) {
        return new GregorianCalendar().isLeapYear(year);
    }

    private static String yearAndSeason(Calendar cal) {
        return "" + cal.get(1) + (cal.get(2) / 3 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getDateFormat(String pattern) throws RuntimeException {
        SimpleDateFormat dateFormat = threadLocal.get();
        if (dateFormat == null) {
            Object object = DateTimeCommand.object;
            synchronized (object) {
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(pattern);
                    dateFormat.setLenient(false);
                    threadLocal.set(dateFormat);
                }
            }
        }
        dateFormat.applyPattern(pattern);
        return dateFormat;
    }

    private static int getInteger(Date date, int dateType) {
        int num = 0;
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
            num = calendar.get(dateType);
        }
        return num;
    }

    private static String addInteger(String date, int dateType, int amount) {
        String dateString = null;
        DateStyle dateStyle = DateTimeCommand.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateTimeCommand.StringToDate(date, dateStyle);
            myDate = DateTimeCommand.addInteger(myDate, dateType, amount);
            dateString = DateTimeCommand.DateToString(myDate, dateStyle);
        }
        return dateString;
    }

    private static Date addInteger(Date date, int dateType, int amount) {
        Date myDate = null;
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.add(dateType, amount);
            myDate = calendar.getTime();
        }
        return myDate;
    }

    private static Date getAccurateDate(List<Long> timestamps) {
        Date date = null;
        long timestamp = 0L;
        HashMap<Long, long[]> map = new HashMap<Long, long[]>();
        ArrayList<Long> absoluteValues = new ArrayList<Long>();
        if (timestamps != null && timestamps.size() > 0) {
            if (timestamps.size() > 1) {
                for (int i = 0; i < timestamps.size(); ++i) {
                    for (int j = i + 1; j < timestamps.size(); ++j) {
                        long absoluteValue = Math.abs(timestamps.get(i) - timestamps.get(j));
                        absoluteValues.add(absoluteValue);
                        long[] timestampTmp = new long[]{timestamps.get(i), timestamps.get(j)};
                        map.put(absoluteValue, timestampTmp);
                    }
                }
                long minAbsoluteValue = -1L;
                if (!absoluteValues.isEmpty()) {
                    minAbsoluteValue = (Long)absoluteValues.get(0);
                    for (int i = 1; i < absoluteValues.size(); ++i) {
                        if (minAbsoluteValue <= (Long)absoluteValues.get(i)) continue;
                        minAbsoluteValue = (Long)absoluteValues.get(i);
                    }
                }
                if (minAbsoluteValue != -1L) {
                    long[] timestampsLastTmp = (long[])map.get(minAbsoluteValue);
                    long dateOne = timestampsLastTmp[0];
                    long dateTwo = timestampsLastTmp[1];
                    if (absoluteValues.size() > 1) {
                        timestamp = Math.abs(dateOne) > Math.abs(dateTwo) ? dateOne : dateTwo;
                    }
                }
            } else {
                timestamp = timestamps.get(0);
            }
        }
        if (timestamp != 0L) {
            date = new Date(timestamp);
        }
        return date;
    }

    public static String getCurrentTimeString() {
        return DateTimeCommand.getDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public static String getCurrentDateString(String str) {
        return DateTimeCommand.getDateFormat(str).format(new Date());
    }

    public static String getCurrentDateString(Date date, String str) {
        return DateTimeCommand.getDateFormat(str).format(date);
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        if (date != null && DateTimeCommand.getDateStyle(date) != null) {
            isDate = true;
        }
        return isDate;
    }

    public static DateStyle getDateStyle(String date) {
        DateStyle dateStyle = null;
        HashMap<Long, DateStyle> map = new HashMap<Long, DateStyle>();
        ArrayList<Long> timestamps = new ArrayList<Long>();
        for (DateStyle style : DateStyle.values()) {
            if (style.isShowOnly()) continue;
            Date dateTmp = null;
            if (date != null) {
                try {
                    ParsePosition pos = new ParsePosition(0);
                    dateTmp = DateTimeCommand.getDateFormat(style.getValue()).parse(date, pos);
                    if (pos.getIndex() != date.length()) {
                        dateTmp = null;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (dateTmp == null) continue;
            timestamps.add(dateTmp.getTime());
            map.put(dateTmp.getTime(), style);
        }
        Date accurateDate = DateTimeCommand.getAccurateDate(timestamps);
        if (accurateDate != null) {
            dateStyle = (DateStyle)((Object)map.get(accurateDate.getTime()));
        }
        return dateStyle;
    }

    public static Date StringToDate(String date) {
        DateStyle dateStyle = DateTimeCommand.getDateStyle(date);
        return DateTimeCommand.StringToDate(date, dateStyle);
    }

    public static Date StringToDate(String date, String pattern) {
        Date myDate = null;
        if (date != null) {
            try {
                myDate = DateTimeCommand.getDateFormat(pattern).parse(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return myDate;
    }

    public static Date StringToDate(String date, DateStyle dateStyle) {
        Date myDate = null;
        if (dateStyle != null) {
            myDate = DateTimeCommand.StringToDate(date, dateStyle.getValue());
        }
        return myDate;
    }

    public static String DateToString(Date date, String pattern) {
        String dateString = null;
        if (date != null) {
            try {
                dateString = DateTimeCommand.getDateFormat(pattern).format(date);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return dateString;
    }

    public static String DateToString(Date date, DateStyle dateStyle) {
        String dateString = null;
        if (dateStyle != null) {
            dateString = DateTimeCommand.DateToString(date, dateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, String newPattern) {
        DateStyle oldDateStyle = DateTimeCommand.getDateStyle(date);
        return DateTimeCommand.StringToString(date, oldDateStyle, newPattern);
    }

    public static String StringToString(String date, DateStyle newDateStyle) {
        DateStyle oldDateStyle = DateTimeCommand.getDateStyle(date);
        return DateTimeCommand.StringToString(date, oldDateStyle, newDateStyle);
    }

    public static String StringToString(String date, String olddPattern, String newPattern) {
        return DateTimeCommand.DateToString(DateTimeCommand.StringToDate(date, olddPattern), newPattern);
    }

    public static String StringToString(String date, DateStyle olddDteStyle, String newParttern) {
        String dateString = null;
        if (olddDteStyle != null) {
            dateString = DateTimeCommand.StringToString(date, olddDteStyle.getValue(), newParttern);
        }
        return dateString;
    }

    public static String StringToString(String date, String olddPattern, DateStyle newDateStyle) {
        String dateString = null;
        if (newDateStyle != null) {
            dateString = DateTimeCommand.StringToString(date, olddPattern, newDateStyle.getValue());
        }
        return dateString;
    }

    public static String StringToString(String date, DateStyle olddDteStyle, DateStyle newDateStyle) {
        String dateString = null;
        if (olddDteStyle != null && newDateStyle != null) {
            dateString = DateTimeCommand.StringToString(date, olddDteStyle.getValue(), newDateStyle.getValue());
        }
        return dateString;
    }

    public static String addYear(String date, int yearAmount) {
        return DateTimeCommand.addInteger(date, 1, yearAmount);
    }

    public static Date addYear(Date date, int yearAmount) {
        return DateTimeCommand.addInteger(date, 1, yearAmount);
    }

    public static String addMonth(String date, int monthAmount) {
        return DateTimeCommand.addInteger(date, 2, monthAmount);
    }

    public static Date addMonth(Date date, int monthAmount) {
        return DateTimeCommand.addInteger(date, 2, monthAmount);
    }

    public static String addDay(String date, int dayAmount) {
        return DateTimeCommand.addInteger(date, 5, dayAmount);
    }

    public static Date addDay(Date date, int dayAmount) {
        return DateTimeCommand.addInteger(date, 5, dayAmount);
    }

    public static String addHour(String date, int hourAmount) {
        return DateTimeCommand.addInteger(date, 11, hourAmount);
    }

    public static Date addHour(Date date, int hourAmount) {
        return DateTimeCommand.addInteger(date, 11, hourAmount);
    }

    public static String addMinute(String date, int minuteAmount) {
        return DateTimeCommand.addInteger(date, 12, minuteAmount);
    }

    public static Date addMinute(Date date, int minuteAmount) {
        return DateTimeCommand.addInteger(date, 12, minuteAmount);
    }

    public static String addSecond(String date, int secondAmount) {
        return DateTimeCommand.addInteger(date, 13, secondAmount);
    }

    public static Date addSecond(Date date, int secondAmount) {
        return DateTimeCommand.addInteger(date, 13, secondAmount);
    }

    public static int getYear(String date) {
        return DateTimeCommand.getYear(DateTimeCommand.StringToDate(date));
    }

    public static int getYear(Date date) {
        return DateTimeCommand.getInteger(date, 1);
    }

    public static int getMonth(String date) {
        return DateTimeCommand.getMonth(DateTimeCommand.StringToDate(date));
    }

    public static int getMonth(Date date) {
        return DateTimeCommand.getInteger(date, 2) + 1;
    }

    public static int getDay(String date) {
        return DateTimeCommand.getDay(DateTimeCommand.StringToDate(date));
    }

    public static int getDay(Date date) {
        return DateTimeCommand.getInteger(date, 5);
    }

    public static int getHour(String date) {
        return DateTimeCommand.getHour(DateTimeCommand.StringToDate(date));
    }

    public static int getHour(Date date) {
        return DateTimeCommand.getInteger(date, 11);
    }

    public static int getMinute(String date) {
        return DateTimeCommand.getMinute(DateTimeCommand.StringToDate(date));
    }

    public static int getMinute(Date date) {
        return DateTimeCommand.getInteger(date, 12);
    }

    public static int getSecond(String date) {
        return DateTimeCommand.getSecond(DateTimeCommand.StringToDate(date));
    }

    public static int getSecond(Date date) {
        return DateTimeCommand.getInteger(date, 13);
    }

    public static String getDate(String date) {
        return DateTimeCommand.StringToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getDate(Date date) {
        return DateTimeCommand.DateToString(date, DateStyle.YYYY_MM_DD);
    }

    public static String getTime(String date) {
        return DateTimeCommand.StringToString(date, DateStyle.HH_MM_SS);
    }

    public static String getTime(Date date) {
        return DateTimeCommand.DateToString(date, DateStyle.HH_MM_SS);
    }

    public static PigWeek getWeek(String date) {
        PigWeek pigWeek = null;
        DateStyle dateStyle = DateTimeCommand.getDateStyle(date);
        if (dateStyle != null) {
            Date myDate = DateTimeCommand.StringToDate(date, dateStyle);
            pigWeek = DateTimeCommand.getWeek(myDate);
        }
        return pigWeek;
    }

    public static PigWeek getWeek(Date date) {
        PigWeek pigWeek = null;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int weekNumber = calendar.get(7) - 1;
        switch (weekNumber) {
            case 0: {
                pigWeek = PigWeek.SUNDAY;
                break;
            }
            case 1: {
                pigWeek = PigWeek.MONDAY;
                break;
            }
            case 2: {
                pigWeek = PigWeek.TUESDAY;
                break;
            }
            case 3: {
                pigWeek = PigWeek.WEDNESDAY;
                break;
            }
            case 4: {
                pigWeek = PigWeek.THURSDAY;
                break;
            }
            case 5: {
                pigWeek = PigWeek.FRIDAY;
                break;
            }
            case 6: {
                pigWeek = PigWeek.SATURDAY;
                break;
            }
        }
        return pigWeek;
    }

    public static int getIntervalDays(String date, String otherDate) {
        return DateTimeCommand.getIntervalDays(DateTimeCommand.StringToDate(date), DateTimeCommand.StringToDate(otherDate));
    }

    public static int getOffsetDays(String date, String otherDate) {
        return DateTimeCommand.getOffsetDays(DateTimeCommand.StringToDate(date), DateTimeCommand.StringToDate(otherDate));
    }

    public static int getIntervalDays(Date date, Date otherDate) {
        return Math.abs(DateTimeCommand.getOffsetDays(date, otherDate));
    }

    public static int getOffsetDays(Date date, Date otherDate) {
        int num = Integer.MAX_VALUE;
        Date dateTmp = DateTimeCommand.StringToDate(DateTimeCommand.getDate(date), DateStyle.YYYY_MM_DD);
        Date otherDateTmp = DateTimeCommand.StringToDate(DateTimeCommand.getDate(otherDate), DateStyle.YYYY_MM_DD);
        if (dateTmp != null && otherDateTmp != null) {
            long time = dateTmp.getTime() - otherDateTmp.getTime();
            num = (int)(time / 86400000L);
        }
        return num;
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(String date) {
        return new SimpleLunarCalendar(DateTimeCommand.StringToDate(date));
    }

    public static SimpleLunarCalendar getSimpleLunarCalendar(Date date) {
        return new SimpleLunarCalendar(date);
    }

    public static Timestamp getSqlTimestamp(Date date) {
        if (null == date) {
            date = new Date();
        }
        return DateTimeCommand.getSqlTimestamp(date.getTime());
    }

    public static Timestamp getSqlTimestamp(long time) {
        return new Timestamp(time);
    }

    public static Date getDate() {
        return new Date();
    }

    public static long getDateByTime() {
        return new Date().getTime();
    }

    public static String getBetween(Date begin, Date end) {
        long between = (end.getTime() - begin.getTime()) / 1000L;
        long day = between / 86400L;
        long hour = between % 86400L / 3600L;
        long minute = between % 3600L / 60L;
        long second = between % 60L / 60L;
        StringBuilder sb = new StringBuilder();
        sb.append(day);
        sb.append("\u5929");
        sb.append(hour);
        sb.append("\u5c0f\u65f6");
        sb.append(minute);
        sb.append("\u5206");
        sb.append(second);
        sb.append("\u79d2");
        return sb.toString();
    }

    public static int getDateHourSpace(Date start, Date end) {
        int hour = (int)((start.getTime() - end.getTime()) / 3600L / 1000L);
        return hour;
    }

    public static int getDateDaySpace(Date start, Date end) {
        int day = DateTimeCommand.getDateHourSpace(start, end) / 24;
        return day;
    }

    public static String getDateInWeek(Date date) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayIndex = calendar.get(7) - 1;
        if (dayIndex < 0) {
            dayIndex = 0;
        }
        return weekDays[dayIndex];
    }

    public static Date getDateReduceHour(Date date, long hourCount) {
        long time = date.getTime() - 3600000L * hourCount;
        Date dateTemp = new Date();
        dateTemp.setTime(time);
        return dateTemp;
    }

    public static List<Date> getDateSplit(Date start, Date end, long splitCount) {
        long startTime = start.getTime();
        long endTime = end.getTime();
        long between = endTime - startTime;
        long count = splitCount - 1L;
        long section = between / count;
        ArrayList<Date> list = new ArrayList<Date>();
        list.add(start);
        for (long i = 1L; i < count; ++i) {
            long time = startTime + section * i;
            Date date = new Date();
            date.setTime(time);
            list.add(date);
        }
        list.add(end);
        return list;
    }

    public static List<String> getDaySpaceDate(Date start, Date end) {
        Calendar fromCalendar = Calendar.getInstance();
        fromCalendar.setTime(start);
        DateTimeCommand.beginOfDayCalendar(fromCalendar);
        Calendar toCalendar = Calendar.getInstance();
        toCalendar.setTime(end);
        DateTimeCommand.beginOfDayCalendar(toCalendar);
        LinkedList<String> dateList = new LinkedList<String>();
        long dayCount = (toCalendar.getTime().getTime() - fromCalendar.getTime().getTime()) / 86400000L;
        if (dayCount < 0L) {
            return dateList;
        }
        dateList.add(DateTimeCommand.format(fromCalendar.getTime(), DateStyle.YYYY_MM_DD.getValue()));
        int i = 0;
        while ((long)i < dayCount) {
            fromCalendar.add(5, 1);
            dateList.add(DateTimeCommand.format(fromCalendar.getTime(), DateStyle.YYYY_MM_DD.getValue()));
            ++i;
        }
        return dateList;
    }

    public static Date startDateByDay(Date start, int end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, end);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date date = calendar.getTime();
        return date;
    }

    public static Date endDateByDay(Date start) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        Date date = calendar.getTime();
        return date;
    }

    public static Date startDateByHour(Date start, int end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.set(12, end);
        Date date = calendar.getTime();
        return date;
    }

    public static Date endDateByHour(Date end) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(end);
        calendar.set(13, 59);
        calendar.set(14, 999);
        Date date = calendar.getTime();
        return date;
    }

    public static Map<String, Date> getStartEndDateByWeek(int year, int week) {
        GregorianCalendar weekCalendar = new GregorianCalendar();
        weekCalendar.set(1, year);
        weekCalendar.set(3, week);
        weekCalendar.set(7, weekCalendar.getFirstDayOfWeek());
        Date startDate = weekCalendar.getTime();
        ((Calendar)weekCalendar).roll(7, 6);
        Date endDate = weekCalendar.getTime();
        Calendar startCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        startCalendar.add(5, 1);
        startCalendar.set(11, 0);
        startCalendar.set(12, 0);
        startCalendar.set(13, 0);
        startCalendar.set(14, 0);
        startDate = startCalendar.getTime();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        endCalendar.add(5, 1);
        endCalendar.set(11, 23);
        endCalendar.set(12, 59);
        endCalendar.set(13, 59);
        endCalendar.set(14, 999);
        endDate = endCalendar.getTime();
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("start", startDate);
        map.put("end", endDate);
        return map;
    }

    public static Map<String, Date> getMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(5, calendar.getActualMinimum(5));
        Date start = calendar.getTime();
        calendar.set(5, calendar.getActualMaximum(5));
        Date end = calendar.getTime();
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("start", start);
        map.put("end", end);
        return map;
    }

    public static Date getDate(int date, int hour, int minute, int second, int millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar.getTime();
    }

    public static java.time.format.DateTimeFormatter nativeDateTimeFormatter() {
        return null;
    }

    public static DateTimeFormatter dateTimeFormatter(String country, String language, String zoneId, String style) {
        TimeZone timeZone = TimeZone.getTimeZone(ZoneId.of(zoneId));
        Locale locale = new Locale(country, language);
        return DateTimeFormatter.getInstance(style, timeZone, locale);
    }

    public static DateTimeFormatter dateTimeFormatter(Locale locale, TimeZone timeZone, String style) {
        return DateTimeFormatter.getInstance(style, timeZone, locale);
    }

    public static long timestampLimit(long l, int i) {
        block3: {
            block2: {
                i = (l + "").length() - i;
                if (i <= 0) break block2;
                for (int j = 0; j < i; ++j) {
                    l /= 10L;
                }
                break block3;
            }
            if (i >= 0) break block3;
            for (int j = 0; j < -i; ++j) {
                l *= 10L;
            }
        }
        return l;
    }
}

