/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.format;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

public class UTF8Parser {
    static File srcDir = new File("D:/prj/java/cmm/eclipse_swt_src/src/swt/");
    static File destDir = new File("D:/prj/java/cmm/eclipse_swt_src/src/swt_cp/");

    public static void main(String[] args) {
        if (!srcDir.isDirectory()) {
            return;
        }
        File[] fs = srcDir.listFiles();
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        try {
            new UTF8Parser().parse(fs);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parse(File[] fs) throws IOException {
        for (File file : fs) {
            if (!file.isDirectory()) {
                File destFile = new File(destDir, file.getName());
                this.parse2UTF_8(file, destFile);
                continue;
            }
            this.parse(file.listFiles());
        }
    }

    private void parse2UTF_8(File file, File destFile) throws IOException {
        StringBuffer msg = new StringBuffer();
        PrintWriter ps = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(destFile, false), "utf8"));
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "gbk"));
        String line = br.readLine();
        while (line != null) {
            msg.append(line).append("\r\n");
            line = br.readLine();
        }
        ps.write(msg.toString());
        br.close();
        ps.flush();
        ps.close();
    }
}

