/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import org.apache.commons.lang3.StringUtils;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.resource.LocationCommand;
import org.gjgr.pig.chivalrous.core.io.stream.BOMInputStream;
import org.gjgr.pig.chivalrous.core.io.stream.FastByteArrayOutputStream;
import org.gjgr.pig.chivalrous.core.io.stream.StreamProgress;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.math.HexCommand;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IoCommand {
    public static final int DEFAULT_BUFFER_SIZE = 1024;
    public static final int DEFAULT_LARGE_BUFFER_SIZE = 4096;
    public static final int EOF = -1;
    private static final String DEFAULT_ENCODING = Charset.defaultCharset().name();
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final Logger logger = LoggerFactory.getLogger(IoCommand.class);

    private IoCommand() {
    }

    public static boolean closeIgnoreException(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String readAllTexts(File file) throws FileNotFoundException {
        return IoCommand.readAllTexts(file, DEFAULT_ENCODING);
    }

    public static String readAllTexts(File file, String encoding) throws FileNotFoundException {
        List<String> lines = IoCommand.readAllLines(file, encoding);
        return StringUtils.join(lines, (String)LINE_SEPARATOR);
    }

    public static List<String> readAllLines(File file) throws FileNotFoundException {
        return IoCommand.readAllLines(file, DEFAULT_ENCODING);
    }

    public static List<String> readAllLines(File file, String encoding) throws FileNotFoundException {
        return IoCommand.readAllLines(new FileInputStream(file), encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readAllLines(InputStream is, String encoding) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner((InputStream)new BufferedInputStream(is), encoding);){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        return lines;
    }

    public static void writeAllTexts(File file, String content, boolean append) throws IOException {
        IoCommand.writeAllTexts(file, content, append, DEFAULT_ENCODING);
    }

    public static void writeAllTexts(File file, String content, boolean append, String encoding) throws IOException {
        IoCommand.writeAllLines(file, Arrays.asList(content), append, encoding);
    }

    public static void writeAllLines(File file, Collection<String> lines, boolean append) throws IOException {
        IoCommand.writeAllLines(file, lines, append, DEFAULT_ENCODING);
    }

    public static void writeAllLines(File file, Collection<String> lines, boolean append, String encoding) throws IOException {
        IoCommand.writeAllLines(new FileOutputStream(file, append), lines, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAllLines(OutputStream os, Collection<String> lines, String encoding) throws IOException {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), encoding);){
            boolean isFirst = true;
            for (String line : lines) {
                if (!isFirst) {
                    out.write(LINE_SEPARATOR);
                }
                out.write(line);
                isFirst = false;
            }
        }
    }

    public static long copy(Reader reader, Writer writer) throws IOException {
        return IoCommand.copy(reader, writer, 1024);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws IOException {
        return IoCommand.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws IOException {
        int readSize;
        char[] buffer = new char[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while ((readSize = reader.read(buffer, 0, bufferSize)) != -1) {
            writer.write(buffer, 0, readSize);
            size += (long)readSize;
            writer.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return IoCommand.copy(in, out, 1024);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws IOException {
        return IoCommand.copy(in, out, bufferSize, null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        if (null == in) {
            throw new NullPointerException("InputStream is null!");
        }
        if (null == out) {
            throw new NullPointerException("OutputStream is null!");
        }
        if (bufferSize <= 0) {
            bufferSize = 1024;
        }
        byte[] buffer = new byte[bufferSize];
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        int readSize = -1;
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            size += (long)readSize;
            out.flush();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static long copyByNIO(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws IOException {
        return IoCommand.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, streamProgress);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws IOException {
        if (null == in) {
            throw new NullPointerException("FileInputStream is null!");
        }
        if (null == out) {
            throw new NullPointerException("FileOutputStream is null!");
        }
        FileChannel inChannel = in.getChannel();
        FileChannel outChannel = out.getChannel();
        return inChannel.transferTo(0L, inChannel.size(), outChannel);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws IOException {
        if (null == in) {
            throw new NullPointerException("In is null!");
        }
        if (null == out) {
            throw new NullPointerException("Out is null!");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        long size = 0L;
        if (null != streamProgress) {
            streamProgress.start();
        }
        while (in.read(byteBuffer) != -1) {
            byteBuffer.flip();
            size += (long)out.write(byteBuffer);
            byteBuffer.clear();
            if (null == streamProgress) continue;
            streamProgress.progress(size);
        }
        if (null != streamProgress) {
            streamProgress.finish();
        }
        return size;
    }

    public static BufferedReader getReader(InputStream in, String charsetName) {
        return IoCommand.getReader(in, Charset.forName(charsetName));
    }

    public static BufferedReader getReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null;
        reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static OutputStreamWriter getWriter(OutputStream out, String charsetName) {
        return IoCommand.getWriter(out, Charset.forName(charsetName));
    }

    public static OutputStreamWriter getWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String read(InputStream in, String charsetName) throws IOException {
        FastByteArrayOutputStream out = IoCommand.read(in);
        return StringCommand.isBlank(charsetName) ? out.toString() : out.toString(charsetName);
    }

    public static String read(InputStream in, Charset charset) throws IOException {
        FastByteArrayOutputStream out = IoCommand.read(in);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoCommand.copy(in, out);
        return out;
    }

    public static String read(Reader reader) throws IOException {
        StringBuilder builder = StringCommand.builder();
        CharBuffer buffer = CharBuffer.allocate(1024);
        while (-1 != reader.read(buffer)) {
            builder.append(buffer.flip().toString());
        }
        return builder.toString();
    }

    public static String read(FileChannel fileChannel, String charsetName) throws IOException {
        return IoCommand.read(fileChannel, CharsetCommand.charset(charsetName));
    }

    public static String read(FileChannel fileChannel, Charset charset) throws IOException {
        MappedByteBuffer buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        return StringCommand.str((ByteBuffer)buffer, charset);
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoCommand.copy(in, out);
        return out.toByteArray();
    }

    public static byte[] readBytes(InputStream in, int length) throws IOException {
        byte[] b = new byte[length];
        in.read(b);
        return b;
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws IOException {
        return HexCommand.encodeHexStr(IoCommand.readBytes(in, length), toLowerCase);
    }

    public static String readHex28Upper(InputStream in) throws IOException {
        return IoCommand.readHex(in, 28, false);
    }

    public static String readHex28Lower(InputStream in) throws IOException {
        return IoCommand.readHex(in, 28, false);
    }

    public static <T> T readObj(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(in);
            Object obj = ois.readObject();
            return (T)obj;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static <T extends Collection<String>> T readLines(InputStream in, String charsetName, T collection) throws IOException {
        return IoCommand.readLines(in, CharsetCommand.charset(charsetName), collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws IOException {
        BufferedReader reader = IoCommand.getReader(in, charset);
        String line = null;
        while ((line = reader.readLine()) != null) {
            collection.add((String)line);
        }
        return collection;
    }

    public static ByteArrayInputStream toStream(String content, String charsetName) {
        return IoCommand.toStream(content, CharsetCommand.charset(charsetName));
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(StringCommand.bytes(content, charset));
    }

    public static FileInputStream toStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new IORuntimeException(e);
        }
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws IOException {
        try {
            out.write(content);
        }
        finally {
            if (isCloseOut) {
                IoCommand.close(out);
            }
        }
    }

    public static void write(OutputStream out, String charset, boolean isCloseOut, Object ... contents) throws IOException {
        OutputStreamWriter osw = null;
        try {
            osw = IoCommand.getWriter(out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toStr(content, ""));
                osw.flush();
            }
        }
        catch (Exception e) {
            throw new IOException("Write content to OutputStream error!", e);
        }
        finally {
            if (isCloseOut) {
                IoCommand.close(osw);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeObjects(OutputStream out, String charset, boolean isCloseOut, Serializable ... contents) throws IOException {
        ObjectOutputStream osw = null;
        try {
            osw = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
            for (Serializable content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
                osw.flush();
            }
            if (!isCloseOut) return;
        }
        catch (Exception e) {
            try {
                throw new IOException("Write content to OutputStream error!", e);
            }
            catch (Throwable throwable) {
                if (!isCloseOut) throw throwable;
                IoCommand.close(osw);
                throw throwable;
            }
        }
        IoCommand.close(osw);
        return;
    }

    public static void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(AutoCloseable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static InputStream getInputStream(String path, Class clazz, ClassLoader classLoader) {
        InputStream is = null;
        if (FileCommand.isExist(path)) {
            try {
                is = new FileInputStream(path);
            }
            catch (FileNotFoundException e) {
                logger.error("found in File, but load file failed {}", (Object)path);
            }
        } else {
            String dir = LocationCommand.userDir();
            if (FileCommand.isExist(dir + File.separator + path)) {
                try {
                    is = new FileInputStream(dir + File.separator + path);
                }
                catch (FileNotFoundException e) {
                    logger.error("found in File, but load file failed {}", (Object)path);
                }
            }
        }
        if (is == null) {
            if (clazz != null) {
                is = clazz.getResourceAsStream(path);
                if (is == null && classLoader != null) {
                    is = classLoader.getResourceAsStream(path);
                } else {
                    is = clazz.getClassLoader().getResourceAsStream(path);
                    if (is == null) {
                        is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
                        logger.warn("failed read by {}, use loader {}", (Object)clazz, (Object)Thread.currentThread().getContextClassLoader());
                    }
                }
            } else {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            }
        }
        if (is == null) {
            logger.warn(path + " cannot be opened because it does not exist");
        }
        return is;
    }

    public static InputStream tryInputStreamUserSystemExternal(String path, Class clazz, ClassLoader classLoader) {
        InputStream inputStream = System.getenv(path) != null ? (FileCommand.isExist(System.getenv(path)) ? IoCommand.getInputStream(System.getProperty(path), clazz, classLoader) : null) : null;
        if (inputStream == null) {
            if (FileCommand.isExist(System.getProperty(path))) {
                try {
                    inputStream = IoCommand.getInputStream(System.getProperty(path), clazz, classLoader);
                }
                catch (RuntimeException e) {
                    inputStream = null;
                }
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    public static InputStream tryInputStreamUserSystemDefault(String key, String filename, Class clazz, ClassLoader classLoader) {
        InputStream inputStream;
        if (System.getProperty(key) != null) {
            if (FileCommand.isExist(System.getProperty(key) + File.separator + filename)) {
                try {
                    inputStream = IoCommand.getInputStream(System.getProperty(key) + File.separator + filename, clazz, classLoader);
                }
                catch (RuntimeException e) {
                    inputStream = null;
                }
            } else {
                inputStream = null;
            }
        } else {
            inputStream = null;
        }
        if (inputStream == null) {
            if (System.getenv(key) != null) {
                if (FileCommand.isExist(System.getenv(key) + File.separator + filename)) {
                    try {
                        inputStream = IoCommand.getInputStream(System.getenv(key) + File.separator + filename, clazz, classLoader);
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                } else {
                    inputStream = null;
                }
            } else {
                inputStream = null;
            }
        }
        return inputStream;
    }

    public static InputStream inputStream(String path, Class clazz, ClassLoader classLoader) {
        InputStream inputStream;
        try {
            inputStream = IoCommand.getInputStream(path, clazz, classLoader);
        }
        catch (RuntimeException e) {
            logger.error("failed read data ", (Throwable)e);
            e.printStackTrace();
            inputStream = null;
        }
        if (inputStream == null && (inputStream = IoCommand.tryInputStreamUserSystemExternal(path, clazz, classLoader)) == null) {
            inputStream = IoCommand.tryInputStreamUserSystemDefault("user.dir", path, clazz, classLoader);
            if (inputStream == null) {
                inputStream = IoCommand.tryInputStreamUserSystemDefault("basedir", path, clazz, classLoader);
            }
            if (inputStream == null) {
                logger.warn("should define the {} file location.", (Object)path);
            }
        }
        return inputStream;
    }

    public static InputStream inputStream(String path, Class clazz) {
        return IoCommand.inputStream(path, clazz, null);
    }

    public static InputStream inputStream(String path) {
        return IoCommand.inputStream(path, null, null);
    }

    public static BufferedInputStream bufferedInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file.getAbsolutePath()));
    }

    public static BufferedInputStream bufferedInputStream(InputStream inputStream) {
        return new BufferedInputStream(inputStream);
    }

    public static BufferedInputStream bufferedInputStream(String path) throws FileNotFoundException {
        return IoCommand.bufferedInputStream(IoCommand.inputStream(path));
    }

    public static BOMInputStream bomInputStream(File file) throws FileNotFoundException {
        return new BOMInputStream(new FileInputStream(file));
    }

    public static InputStream debug(String path) {
        return IoCommand.inputStream(path);
    }

    public static BufferedOutputStream bufferedOutputStream(File file) throws IOException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public static BufferedOutputStream bufferedOutputStream(String path) throws IOException {
        return IoCommand.bufferedOutputStream(path);
    }

    public static InputStream inputStream(File file) {
        return IoCommand.inputStream(file.getAbsolutePath());
    }

    public static InputStream inputStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }
}

