/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileWrapper;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;

public class FileReader
extends FileWrapper {
    public FileReader(File file, Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileReader(File file, String charset) {
        this(file, CharsetCommand.charset(charset));
    }

    public FileReader(String filePath, Charset charset) {
        this(FileCommand.file(filePath), charset);
    }

    public FileReader(String filePath, String charset) {
        this(FileCommand.file(filePath), CharsetCommand.charset(charset));
    }

    public FileReader(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileReader(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileReader create(File file, Charset charset) {
        return new FileReader(file, charset);
    }

    public static FileReader create(File file) {
        return new FileReader(file);
    }

    public byte[] readBytes() throws IORuntimeException {
        long len = this.file.length();
        if (len >= Integer.MAX_VALUE) {
            throw new IORuntimeException("File is larger then max array size");
        }
        byte[] bytes = new byte[(int)len];
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            in.read(bytes);
        }
        catch (Exception e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(in);
                throw throwable;
            }
        }
        IoCommand.close(in);
        return bytes;
    }

    public String readString() throws IORuntimeException {
        return new String(this.readBytes(), this.charset);
    }

    public <T extends Collection<String>> T readLines(T collection) throws IORuntimeException {
        T t;
        BufferedReader reader = null;
        try {
            String line;
            reader = FileCommand.bufferedReader(this.file, this.charset);
            while ((line = reader.readLine()) != null) {
                collection.add((String)line);
            }
            t = collection;
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(reader);
                throw throwable;
            }
        }
        IoCommand.close(reader);
        return t;
    }

    public List<String> readLines() throws IORuntimeException {
        return this.readLines(new ArrayList());
    }

    public <T> T read(ReaderHandler<T> readerHandler) throws IORuntimeException {
        BufferedReader reader = null;
        T result = null;
        try {
            reader = FileCommand.bufferedReader(this.file, this.charset);
            result = readerHandler.handle(reader);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(reader);
                throw throwable;
            }
        }
        IoCommand.close(reader);
        return result;
    }

    public BufferedReader getReader() throws IORuntimeException {
        return IoCommand.getReader((InputStream)this.getInputStream(), this.charset);
    }

    public BufferedInputStream getInputStream() throws IORuntimeException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public File writeToStream(OutputStream out) throws IORuntimeException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(this.file);
            IoCommand.copy((InputStream)in, out);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException(e);
            }
            catch (Throwable throwable) {
                IoCommand.close(in);
                throw throwable;
            }
        }
        IoCommand.close(in);
        return this.file;
    }

    private void checkFile() throws IORuntimeException {
        if (!this.file.exists()) {
            throw new IORuntimeException("File not isExist: " + this.file);
        }
        if (!this.file.isFile()) {
            throw new IORuntimeException("Not a file:" + this.file);
        }
    }

    public static interface ReaderHandler<T> {
        public T handle(BufferedReader var1) throws IOException;
    }
}

