/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file.download;

import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gjgr.pig.chivalrous.core.io.file.download.Authentication;
import org.gjgr.pig.chivalrous.core.io.file.download.DownloadListener;

public class DownloadTask {
    private final List<DownloadListener> listeners = new ArrayList<DownloadListener>();
    private URL url;
    private OutputStream outputStream;
    private boolean paused = false;
    private boolean cancelled = false;
    private int timeout = 60000;
    private Authentication authentication;

    public DownloadTask(DownloadListener listener) {
        this.listeners.add(listener);
    }

    public DownloadTask(URL url, OutputStream outputStream) {
        this.url = url;
        this.outputStream = outputStream;
    }

    public DownloadTask(URL url, OutputStream outputStream, DownloadListener listener) {
        this.url = url;
        this.outputStream = outputStream;
        this.listeners.add(listener);
    }

    public URL getUrl() {
        return this.url;
    }

    public DownloadTask setUrl(URL url) {
        this.url = url;
        return this;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public DownloadTask setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
        return this;
    }

    public List<DownloadListener> getListeners() {
        return this.listeners;
    }

    public DownloadTask addListener(DownloadListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public DownloadTask removeListener(DownloadListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public DownloadTask removeAllListener() {
        this.listeners.clear();
        return this;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public DownloadTask setPaused(boolean paused) {
        this.paused = paused;
        return this;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public DownloadTask setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public DownloadTask setTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public DownloadTask setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }
}

