/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file.download;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpConnector {
    private final Map<String, String> headers = new HashMap<String, String>();
    protected int BUFFER_SIZE = 2048;
    protected int DEFAULT_STREAM_BUFFER_SIZE = 3072;
    protected int DEFAULT_CONNECT_TIMEOUT;
    private int connectionTimeout = this.DEFAULT_CONNECT_TIMEOUT = 13000;
    private String requestMethod = "GET";

    public HttpConnector() {
        HttpURLConnection.setFollowRedirects(true);
    }

    public URLConnection getConnection(URL url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if ("http".equalsIgnoreCase(url.getProtocol()) || "ftp".equalsIgnoreCase(url.getProtocol())) {
            return this.getConnection(url, null);
        }
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            return this.getSecureConnection(url);
        }
        return null;
    }

    public URLConnection getConnection(URL url, Proxy proxy) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        if ("http".equalsIgnoreCase(url.getProtocol()) || "ftp".equalsIgnoreCase(url.getProtocol())) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy == null ? Proxy.NO_PROXY : proxy);
            conn.setRequestMethod(this.requestMethod);
            this.setHeaders(conn);
            return conn;
        }
        if ("https".equalsIgnoreCase(url.getProtocol())) {
            return this.getSecureConnection(url, proxy);
        }
        return null;
    }

    public HttpsURLConnection getSecureConnection(URL url) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        return this.getSecureConnection(url, null);
    }

    public HttpsURLConnection getSecureConnection(URL url, Proxy proxy) throws IOException, NoSuchAlgorithmException, KeyManagementException {
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
        HttpsURLConnection conn = (HttpsURLConnection)url.openConnection(proxy == null ? Proxy.NO_PROXY : proxy);
        conn.setRequestMethod(this.requestMethod);
        this.setHeaders(conn);
        conn.setSSLSocketFactory(context.getSocketFactory());
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        conn.setConnectTimeout(this.DEFAULT_CONNECT_TIMEOUT);
        return conn;
    }

    public void doOutput(URLConnection conn, String data) throws IOException {
        BufferedWriter wr = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream()), this.DEFAULT_STREAM_BUFFER_SIZE);
        wr.write(data);
        wr.flush();
        wr.close();
    }

    public StringBuffer doInput(URLConnection conn) throws IOException {
        int nob;
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()), this.DEFAULT_STREAM_BUFFER_SIZE);
        StringBuffer buff = new StringBuffer();
        char[] bb = new char[this.BUFFER_SIZE];
        while ((nob = rd.read(bb)) != -1) {
            buff.append(new String(bb, 0, nob));
        }
        rd.close();
        return buff;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    private void setHeaders(URLConnection uc) {
        for (String key : this.headers.keySet()) {
            uc.addRequestProperty(key, this.headers.get(key));
        }
    }

    public String getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    protected static final class DefaultTrustManager
    implements X509TrustManager {
        protected DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

