/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.file.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarCommand {
    private String jarFileName;
    private Map<String, Long> hashSizes = new HashMap<String, Long>();
    private Map<String, Object> hashJarContents = new HashMap<String, Object>();

    public JarCommand(String jarFileName) throws Exception {
        this.jarFileName = jarFileName;
        ZipFile zipFile = new ZipFile(this.jarFileName);
        Enumeration<? extends ZipEntry> e = zipFile.entries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = e.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.hashSizes.put(this.getSimpleName(zipEntry.getName()), zipEntry.getSize());
        }
        zipFile.close();
        FileInputStream fis = new FileInputStream(jarFileName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ZipInputStream zis = new ZipInputStream(bis);
        ZipEntry ze = null;
        while ((ze = zis.getNextEntry()) != null) {
            if (ze.isDirectory()) continue;
            long size = (int)ze.getSize();
            if (size == -1L) {
                size = this.hashSizes.get(ze.getName());
            }
            byte[] b = new byte[(int)size];
            int rb = 0;
            int chunk = 0;
            while ((int)size - rb > 0 && (chunk = zis.read(b, rb, (int)size - rb)) != -1) {
                rb += chunk;
            }
            this.hashJarContents.put(ze.getName(), b);
        }
        zis.close();
    }

    public static void read(URL jarUrl, InputStreamCallback callback) throws IOException {
        if (!"jar".equals(jarUrl.getProtocol())) {
            throw new IllegalArgumentException("Jar protocol is expected but get " + jarUrl.getProtocol());
        }
        if (callback == null) {
            throw new IllegalArgumentException("Callback must not be null");
        }
        String jarPath = jarUrl.getPath().substring(5);
        String[] paths = jarPath.split("!");
        FileInputStream jarFileInputStream = new FileInputStream(paths[0]);
        JarCommand.readStream(jarFileInputStream, paths[0], 1, paths, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readStream(InputStream jarFileInputStream, String name, int i, String[] paths, InputStreamCallback callback) throws IOException {
        if (i == paths.length) {
            callback.onFile(name, jarFileInputStream);
            return;
        }
        try (ZipInputStream jarInputStream = new ZipInputStream(jarFileInputStream);){
            ZipEntry jarEntry = null;
            while ((jarEntry = jarInputStream.getNextEntry()) != null) {
                String jarEntryName = "/" + jarEntry.getName();
                if (jarEntry.isDirectory() || !jarEntryName.startsWith(paths[i])) continue;
                byte[] byteArray = JarCommand.copyStream(jarInputStream, jarEntry);
                JarCommand.readStream(new ByteArrayInputStream(byteArray), jarEntryName, i + 1, paths, callback);
            }
        }
    }

    private static byte[] copyStream(InputStream in, ZipEntry entry) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        long size = entry.getSize();
        if (size > -1L) {
            byte[] buffer = new byte[4096];
            int n = 0;
            for (long count = 0L; -1 != (n = in.read(buffer)) && count < size; count += (long)n) {
                baos.write(buffer, 0, n);
            }
        } else {
            int b;
            while ((b = in.read()) != -1) {
                baos.write(b);
            }
        }
        baos.close();
        return baos.toByteArray();
    }

    public byte[] getResource(String name) {
        return (byte[])this.hashJarContents.get(name);
    }

    private String getSimpleName(String entryName) {
        int index = entryName.indexOf("/");
        String fileNameWithoutExt = entryName.substring(index, entryName.length());
        return fileNameWithoutExt;
    }

    public static interface InputStreamCallback {
        public void onFile(String var1, InputStream var2) throws IOException;
    }
}

