/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.resource;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.net.UriCommand;
import org.gjgr.pig.chivalrous.log.SystemLogger;

public class LocationCommand {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String WINDOWS_FOLDER_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";
    private static String webRootPath;
    private static String rootClassPath;

    public static String debug(String locationUrl) {
        return LocationCommand.location(locationUrl);
    }

    public static String userDir() {
        return System.getProperty("user.dir");
    }

    public static String location(String path) {
        String check = LocationCommand.path(path);
        if (!FileCommand.isExist(check)) {
            if (System.getenv(path) != null) {
                check = System.getenv(path);
            }
            if (!(FileCommand.isExist(check) || FileCommand.isExist(check = LocationCommand.userDir() + File.separator + path) || FileCommand.isExist(check = LocationCommand.getClassDir() + File.separator + path))) {
                check = LocationCommand.getPathFromEnv(path);
            }
        }
        return check;
    }

    public static String path(String path) {
        ClassLoader cl = ClassCommand.getDefaultClassLoader();
        return LocationCommand.path(path, cl);
    }

    public static String path(String path, ClassLoader classLoader) {
        AssertCommand.notNull(path, "Resource location must not be null");
        String resultPath = LocationCommand.getAbsolutePath(path);
        if (resultPath != null) {
            try {
                resultPath = UriCommand.decode(resultPath);
            }
            catch (Exception e) {
                SystemLogger.warn((String)"format path failed {}", (Object[])new Object[]{resultPath});
                resultPath = LocationCommand.normalize(resultPath);
            }
        } else {
            if (path.startsWith("classpath:")) {
                path = path.substring("classpath:".length());
            }
            URL url = classLoader != null ? classLoader.getResource(path) : ClassLoader.getSystemResource(path);
            File file = FileCommand.file(url);
            return file.getAbsolutePath();
        }
        return resultPath;
    }

    public static Boolean isExist(URL url) {
        try {
            return url.openStream() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static Boolean isExist(String path) {
        return LocationCommand.isExist(path, null);
    }

    public static Boolean isExist(String path, Class clazz) {
        try {
            if (path != null && (IoCommand.getInputStream(path, clazz, null) != null || LocationCommand.isExist(new URL(path)).booleanValue())) {
                return true;
            }
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String path(String path, Class clazz) {
        String check = LocationCommand.path(path);
        if (LocationCommand.isExist(path).booleanValue()) {
            check = LocationCommand.getClassDir(clazz) + File.separator + path;
        }
        return check;
    }

    public static String getAbsolutePath(String path, Class<?> baseClass) {
        if (path == null) {
            path = "";
        }
        if (baseClass == null) {
            return LocationCommand.getAbsolutePath(path);
        }
        path = StringCommand.removePrefix("file:", baseClass.getResource(path).getPath());
        return path;
    }

    public static String getAbsolutePath(String path) {
        return LocationCommand.getAbsolutePath(new File(path));
    }

    public static String getAbsolutePath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    public static String getPathFromEnv(String path) {
        String check = path;
        if (System.getenv("basedir") != null) {
            check = System.getProperty("basedir") == null ? path : System.getProperty("basedir") + File.separator + path;
        } else if (System.getenv("BASEDIR") != null) {
            check = System.getProperty("BASEDIR") == null ? path : System.getProperty("BASEDIR") + File.separator + path;
        } else if (System.getenv("user.dir") != null) {
            check = System.getProperty("user.dir") == null ? path : System.getProperty("user.dir") + File.separator + path;
        }
        return check;
    }

    public static URL getResource(String resourceName) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = LocationCommand.class.getClassLoader();
        }
        URL url = loader.getResource(resourceName);
        return url;
    }

    public static String getClassPath(Class clazz) {
        String path = clazz.getResource("").getPath();
        path = new File(path).getAbsolutePath();
        return path;
    }

    public static String getClassDir() {
        if (rootClassPath == null) {
            try {
                String path = null;
                URL url = LocationCommand.class.getClassLoader().getResource("");
                path = url == null ? (System.getProperty("java.class.path").contains(".jar") ? System.getProperty("java.class.path") : LocationCommand.userDir()) : url.getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rootClassPath;
    }

    public static String getClassDir(Class clazz) {
        String path = LocationCommand.getClassPath(clazz);
        path = path.contains(".jar") ? path.substring(path.indexOf(":/"), path.lastIndexOf("!/")) : LocationCommand.userDir();
        return path;
    }

    public static String getObjectPath(Object object) {
        return LocationCommand.getClassPath(object.getClass());
    }

    public static String getObjectDir(Object object) {
        return LocationCommand.getClassDir(object.getClass());
    }

    public static String getPackagePath(Object object) {
        Package p = object.getClass().getPackage();
        return p != null ? p.getName().replaceAll("\\.", FOLDER_SEPARATOR) : "";
    }

    public static String getWebRootPath() {
        if (webRootPath == null) {
            webRootPath = LocationCommand.detectWebRootPath();
        }
        return webRootPath;
    }

    public static void setWebRootPath(String webRootPath) {
        if (webRootPath == null) {
            return;
        }
        if (webRootPath.endsWith(File.separator)) {
            webRootPath = webRootPath.substring(0, webRootPath.length() - 1);
        }
        LocationCommand.webRootPath = webRootPath;
    }

    private static String detectWebRootPath() {
        try {
            String path = LocationCommand.class.getResource(FOLDER_SEPARATOR).toURI().getPath();
            return new File(path).getParentFile().getParentFile().getCanonicalPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String applyRelativePath(String path, String relativePath) {
        int separatorIndex = path.lastIndexOf(FOLDER_SEPARATOR);
        if (separatorIndex != -1) {
            String newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(FOLDER_SEPARATOR)) {
                newPath = newPath + FOLDER_SEPARATOR;
            }
            return newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (!StringCommand.hasLength(path)) {
            return path;
        }
        String pathToUse = StringCommand.replace(path, WINDOWS_FOLDER_SEPARATOR, FOLDER_SEPARATOR);
        int prefixIndex = pathToUse.indexOf(58);
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringCommand.delimitedListToStringArray(pathToUse, FOLDER_SEPARATOR);
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + StringCommand.collectionToDelimitedString(pathElements, FOLDER_SEPARATOR);
    }

    public static boolean pathEquals(String path1, String path2) {
        return LocationCommand.cleanPath(path1).equals(LocationCommand.cleanPath(path2));
    }

    public static String normalize(String path) {
        return LocationCommand.normalize(path, false);
    }

    public static String normalize(String path, boolean withPrefix) {
        int i;
        if (path == null) {
            return null;
        }
        String pathToUse = path.replaceAll("[/\\\\]{1,}", FOLDER_SEPARATOR).trim();
        int prefixIndex = pathToUse.indexOf(":");
        String prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (prefix.contains(FOLDER_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(FOLDER_SEPARATOR)) {
            prefix = prefix + FOLDER_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        List<String> pathList = StringCommand.split(pathToUse, '/');
        LinkedList<String> pathElements = new LinkedList<String>();
        int tops = 0;
        for (i = pathList.size() - 1; i >= 0; --i) {
            String element = pathList.get(i);
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.add(0, element);
        }
        for (i = 0; i < tops; ++i) {
            pathElements.add(0, TOP_PATH);
        }
        return prefix + CollectionCommand.join(pathElements, FOLDER_SEPARATOR);
    }

    public static String uriDecode(String source, Charset charset) {
        int length = source.length();
        if (length == 0) {
            return source;
        }
        AssertCommand.notNull(charset, "Charset must not be null");
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), charset) : source;
    }
}

