/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.io.stream;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Scanner;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;

public final class StreamCommand {
    public static final int BUFFER_SIZE = 4096;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final byte[] EMPTY_CONTENT = new byte[0];

    public static byte[] copyToByteArray(@Nullable InputStream in) throws IOException {
        if (in == null) {
            return new byte[0];
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        StreamCommand.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static String copyToString(@Nullable InputStream in, Charset charset) throws IOException {
        if (in == null) {
            return "";
        }
        StringBuilder out = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(in, charset);
        char[] buffer = new char[4096];
        int bytesRead = -1;
        while ((bytesRead = reader.read(buffer)) != -1) {
            out.append(buffer, 0, bytesRead);
        }
        return out.toString();
    }

    public static void copy(byte[] in, OutputStream out) throws IOException {
        AssertCommand.notNull(in, "No input byte array specified");
        AssertCommand.notNull(out, "No OutputStream specified");
        out.write(in);
    }

    public static void copy(String in, Charset charset, OutputStream out) throws IOException {
        AssertCommand.notNull(in, "No input String specified");
        AssertCommand.notNull(charset, "No charset specified");
        AssertCommand.notNull(out, "No OutputStream specified");
        OutputStreamWriter writer = new OutputStreamWriter(out, charset);
        writer.write(in);
        ((Writer)writer).flush();
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        AssertCommand.notNull(in, "No InputStream specified");
        AssertCommand.notNull(out, "No OutputStream specified");
        int byteCount = 0;
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = in.read(buffer)) != -1) {
            out.write(buffer, 0, bytesRead);
            byteCount += bytesRead;
        }
        out.flush();
        return byteCount;
    }

    public static long copyRange(InputStream in, OutputStream out, long start, long end) throws IOException {
        int bytesRead;
        AssertCommand.notNull(in, "No InputStream specified");
        AssertCommand.notNull(out, "No OutputStream specified");
        long skipped = in.skip(start);
        if (skipped < start) {
            throw new IOException("Skipped only " + skipped + " bytes out of " + start + " required");
        }
        long bytesToCopy = end - start + 1L;
        byte[] buffer = new byte[4096];
        while (bytesToCopy > 0L && (bytesRead = in.read(buffer)) != -1) {
            if ((long)bytesRead <= bytesToCopy) {
                out.write(buffer, 0, bytesRead);
                bytesToCopy -= (long)bytesRead;
                continue;
            }
            out.write(buffer, 0, (int)bytesToCopy);
            bytesToCopy = 0L;
        }
        return end - start + 1L - bytesToCopy;
    }

    public static int drain(InputStream in) throws IOException {
        AssertCommand.notNull(in, "No InputStream specified");
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        int byteCount = 0;
        while ((bytesRead = in.read(buffer)) != -1) {
            byteCount += bytesRead;
        }
        return byteCount;
    }

    public static InputStream emptyInput() {
        return new ByteArrayInputStream(EMPTY_CONTENT);
    }

    public static InputStream nonClosing(InputStream in) {
        AssertCommand.notNull(in, "No InputStream specified");
        return new NonClosingInputStream(in);
    }

    public static OutputStream nonClosing(OutputStream out) {
        AssertCommand.notNull(out, "No OutputStream specified");
        return new NonClosingOutputStream(out);
    }

    public static String newStringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start, int length) {
        try {
            return new String(bytes, start, length, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static BufferedInputStream buffered(InputStream in) {
        ObjectCommand.notNull(in, "in");
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream buffered(OutputStream out) {
        ObjectCommand.notNull(out, "out");
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static boolean isExist(InputStream inputStream) {
        if (inputStream == null) {
            return false;
        }
        try {
            int i = inputStream.available();
            return i > 0;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static BufferedReader buffered(Reader reader) {
        ObjectCommand.notNull(reader, "reader");
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedWriter buffered(Writer writer) {
        ObjectCommand.notNull(writer, "writer");
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Deprecated
    public static IOException createIOException(Throwable cause) {
        return StreamCommand.createIOException(cause.getMessage(), cause);
    }

    @Deprecated
    public static IOException createIOException(String message, Throwable cause) {
        IOException answer = new IOException(message);
        answer.initCause(cause);
        return answer;
    }

    public static int copy(OutputStream output, InputStream input) throws IOException {
        return StreamCommand.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return StreamCommand.copy(input, output, bufferSize, false);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean flushOnEachWrite) throws IOException {
        boolean hasData;
        if (input instanceof ByteArrayInputStream) {
            input.mark(0);
            input.reset();
            bufferSize = input.available();
        } else {
            int avail = input.available();
            if (avail > bufferSize) {
                bufferSize = avail;
            }
        }
        if (bufferSize > 262144) {
            bufferSize = 262144;
        }
        int total = 0;
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        boolean bl = hasData = n > -1;
        if (hasData) {
            while (-1 != n) {
                output.write(buffer, 0, n);
                if (flushOnEachWrite) {
                    output.flush();
                }
                total += n;
                n = input.read(buffer);
            }
        }
        if (!flushOnEachWrite) {
            output.flush();
        }
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        StreamCommand.copyAndCloseInput(input, output, 4096);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        StreamCommand.copy(input, output, bufferSize);
        StreamCommand.close((Closeable)input, null);
    }

    public static int copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void force(FileChannel channel, String name) {
        try {
            if (channel != null) {
                channel.force(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void force(FileOutputStream os, String name) {
        try {
            if (os != null) {
                os.getFD().sync();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(Writer writer, FileOutputStream os, String name, boolean force) {
        if (writer != null && force) {
            try {
                writer.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            StreamCommand.force(os, name);
        }
        StreamCommand.close((Closeable)writer, name);
    }

    public static void close(Closeable closeable, String name) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeWithException(Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    public static void close(FileChannel channel, String name, boolean force) {
        if (force) {
            StreamCommand.force(channel, name);
        }
        StreamCommand.close((Closeable)channel, name);
    }

    public static void close(Closeable closeable) {
        StreamCommand.close(closeable, null);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            StreamCommand.close(closeable);
        }
    }

    public static void closeIterator(Object it) throws IOException {
        if (it instanceof Scanner) {
            Scanner scanner = (Scanner)it;
            scanner.close();
            IOException ioException = scanner.ioException();
            if (ioException != null) {
                throw ioException;
            }
        } else if (it instanceof Scanner) {
            Scanner scanner = (Scanner)it;
            scanner.close();
            IOException ioException = scanner.ioException();
            if (ioException != null) {
                throw ioException;
            }
        } else if (it instanceof Closeable) {
            StreamCommand.closeWithException((Closeable)it);
        }
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }

    public static String normalizeCharset(String charset) {
        if (charset != null) {
            String answer = charset.trim();
            if (answer.startsWith("'") || answer.startsWith("\"")) {
                answer = answer.substring(1);
            }
            if (answer.endsWith("'") || answer.endsWith("\"")) {
                answer = answer.substring(0, answer.length() - 1);
            }
            return answer.trim();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return UTF8_CHARSET.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadText(InputStream in) throws IOException {
        String string;
        StringBuilder builder = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(in);
        try {
            String line;
            BufferedReader reader = StreamCommand.buffered(isr);
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
            string = builder.toString();
        }
        catch (Throwable throwable) {
            StreamCommand.close(isr, in);
            throw throwable;
        }
        StreamCommand.close(isr, in);
        return string;
    }

    public static String getCharsetNameFromContentType(String contentType) {
        String[] values = contentType.split(";");
        String charset = "";
        for (String value : values) {
            if (!(value = value.trim()).toLowerCase().startsWith("charset=")) continue;
            charset = value.substring(8);
        }
        if ("".equals(charset)) {
            charset = "UTF-8";
        }
        return StreamCommand.normalizeCharset(charset);
    }

    private static class NonClosingOutputStream
    extends FilterOutputStream {
        public NonClosingOutputStream(OutputStream out) {
            super(out);
        }

        @Override
        public void write(byte[] b, int off, int let) throws IOException {
            this.out.write(b, off, let);
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class NonClosingInputStream
    extends FilterInputStream {
        public NonClosingInputStream(InputStream in) {
            super(in);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

