/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;

public class GsonObject
extends JsonElement
implements Serializable {
    protected static final long serialVersionUID = 1024L;
    protected final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap();

    public GsonObject deepCopy() {
        GsonObject result = new GsonObject();
        for (Map.Entry entry : this.members.entrySet()) {
            result.add((String)entry.getKey(), ((JsonElement)entry.getValue()).deepCopy());
        }
        return result;
    }

    public boolean isJsonObject() {
        return true;
    }

    public JsonObject getAsJsonObject() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.entrySet().addAll(this.members.entrySet());
        return jsonObject;
    }

    public void add(String property, JsonElement value) {
        if (value == null) {
            value = JsonNull.INSTANCE;
        }
        this.members.put((Object)property, (Object)value);
    }

    public JsonElement remove(String property) {
        return (JsonElement)this.members.remove((Object)property);
    }

    public void addProperty(String property, String value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Number value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Boolean value) {
        this.add(property, this.createJsonElement(value));
    }

    public void addProperty(String property, Character value) {
        this.add(property, this.createJsonElement(value));
    }

    private JsonElement createJsonElement(Object value) {
        return value == null ? JsonNull.INSTANCE : JsonCommand.jsonPrimitive(value);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public Set<String> keySet() {
        return this.members.keySet();
    }

    public int size() {
        return this.members.size();
    }

    public boolean has(String memberName) {
        return this.members.containsKey((Object)memberName);
    }

    public JsonElement get(String memberName) {
        return (JsonElement)this.members.get((Object)memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get((Object)memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get((Object)memberName);
    }

    public GsonObject getAsJsonObject(String memberName) {
        return (GsonObject)this.members.get((Object)memberName);
    }

    public String getAsString(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsString();
        }
        return null;
    }

    public String getAsString(String memberName, String defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsString();
        }
        return defaultValue;
    }

    public Number getAsNumber(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsNumber();
        }
        return null;
    }

    public Number getAsNumber(String memberName, Number defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsNumber();
        }
        return defaultValue;
    }

    public Integer getAsInt(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsInt();
        }
        return null;
    }

    public int getAsInt(String memberName, int defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsInt();
        }
        return defaultValue;
    }

    public Boolean getAsBoolean(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsBoolean();
        }
        return null;
    }

    public boolean getAsBoolean(String memberName, boolean defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsBoolean();
        }
        return defaultValue;
    }

    public Long getAsLong(String memberName, Long defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsLong();
        }
        return null;
    }

    public long getAsLong(String memberName, long defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsLong();
        }
        return defaultValue;
    }

    public short getAsShort(String memberName, short defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsShort();
        }
        return defaultValue;
    }

    public Short getAsShort(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsShort();
        }
        return null;
    }

    public double getAsDouble(String memberName, double defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsDouble();
        }
        return defaultValue;
    }

    public Double getAsDouble(String memberName) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsDouble();
        }
        return null;
    }

    public Float getAsFloat(String memberName, Float defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return Float.valueOf(((JsonElement)this.members.get((Object)memberName)).getAsFloat());
        }
        return null;
    }

    public float getAsFloat(String memberName, float defaultValue) {
        if (this.members.containsKey((Object)memberName)) {
            return ((JsonElement)this.members.get((Object)memberName)).getAsFloat();
        }
        return defaultValue;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof GsonObject && ((GsonObject)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public JsonElement getElement(String key, Object defaultValue) {
        JsonElement obj = this.get(key);
        return obj.isJsonNull() ? JsonCommand.jsonPrimitive(defaultValue) : obj;
    }
}

