/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Supplier;
import javax.lang.model.type.TypeVariable;
import org.gjgr.pig.chivalrous.core.io.exception.IORuntimeException;
import org.gjgr.pig.chivalrous.core.io.file.FileReader;
import org.gjgr.pig.chivalrous.core.io.file.yml.YmlNode;
import org.gjgr.pig.chivalrous.core.json.GsonObject;
import org.gjgr.pig.chivalrous.core.json.InternalJsonUtil;
import org.gjgr.pig.chivalrous.core.json.JsonString;
import org.gjgr.pig.chivalrous.core.json.ListJson;
import org.gjgr.pig.chivalrous.core.json.MapJson;
import org.gjgr.pig.chivalrous.core.json.NullJson;
import org.gjgr.pig.chivalrous.core.json.StringJson;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.xml.XmlBetweenJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonCommand {
    private static final Logger logger = LoggerFactory.getLogger(JsonCommand.class);
    private static ThreadLocal<Gson> gsonThreadLocal = ThreadLocal.withInitial(new Supplier<Gson>(){

        @Override
        public Gson get() {
            return new Gson();
        }
    });

    @Deprecated
    public static JsonElement parseJsonElement(String str) {
        return new JsonParser().parse(str);
    }

    @Deprecated
    public static <T> T parse(String str, TypeToken typeToken) {
        return (T)new Gson().fromJson(str, typeToken.getType());
    }

    @Deprecated
    public static <T> T parse(String str, Type type) {
        if (!(type instanceof ParameterizedType) && !(type instanceof TypeVariable)) {
            if (type instanceof GenericArrayType) {
                return (T)Arrays.asList((Object[])gsonThreadLocal.get().fromJson(str, type));
            }
            if (type instanceof WildcardType) {
                // empty if block
            }
        }
        return null;
    }

    public static JsonElement convert(MapJson mapJson) {
        JsonElement jsonElement = mapJson.gson();
        return jsonElement;
    }

    public static String json(Object object) {
        Gson gson = gsonThreadLocal.get();
        return gson.toJson(object);
    }

    public static JsonElement jsonElement(Object object) {
        String string = JsonCommand.json(object);
        JsonElement jsonElement = JsonCommand.jsonElement(string);
        return jsonElement;
    }

    public static JsonElement jsonElement(String str) {
        return new JsonParser().parse(str);
    }

    public static JsonArray listStringJsonArray(List<String> strings) {
        JsonArray jsonArray = new JsonArray();
        if (strings != null) {
            for (String s : strings) {
                jsonArray.add((JsonElement)new JsonPrimitive(s));
            }
            return jsonArray;
        }
        return jsonArray;
    }

    public static JsonArray listStringJsonArray(Set<String> strings) {
        return JsonCommand.listStringJsonArray(new LinkedList<String>(strings));
    }

    public static JsonArray jsonArray(Object object) {
        String string = JsonCommand.json(object);
        JsonArray jsonElement = JsonCommand.jsonArray(string);
        return jsonElement;
    }

    public static JsonArray jsonArray(String str) {
        JsonElement jsonElement = JsonCommand.jsonElement(str);
        if (jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return new JsonArray();
    }

    public static JsonObject jsonObject(Object object) {
        String string = JsonCommand.json(object);
        JsonObject jsonElement = JsonCommand.jsonObject(string);
        return jsonElement;
    }

    public static JsonObject jsonObject(String str) {
        JsonElement jsonElement = JsonCommand.jsonElement(str);
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new JsonObject();
    }

    public static GsonObject gsonObject(Object object) {
        String string = JsonCommand.json(object);
        GsonObject jsonElement = JsonCommand.gsonObject(string);
        return jsonElement;
    }

    public static GsonObject gsonObject(String str) {
        JsonObject jsonObject = JsonCommand.jsonObject(str);
        GsonObject gsonObject = new GsonObject();
        gsonObject.members.entrySet().addAll(jsonObject.entrySet());
        return gsonObject;
    }

    public static String serializer(Object ts, final String dateFormat) {
        String jsonStr = null;
        Gson gson = null;
        if (dateFormat == null) {
            gson = gsonThreadLocal.get();
        } else {
            gson = new GsonBuilder().registerTypeHierarchyAdapter(Date.class, (Object)new JsonSerializer<Date>(){

                public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
                    SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                    return new JsonPrimitive(format.format(src));
                }
            }).setDateFormat(dateFormat).create();
            gsonThreadLocal.set(gson);
        }
        if (gson != null) {
            jsonStr = gson.toJson(ts);
        }
        return jsonStr;
    }

    public static <T> T serializer(String jsonStr, Class<T> cl, final String pattern) {
        Object obj = null;
        Gson gson = null;
        if (pattern == null) {
            gson = gsonThreadLocal.get();
        } else {
            gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)new JsonDeserializer<Date>(){

                public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                    SimpleDateFormat format = new SimpleDateFormat(pattern);
                    String dateStr = json.getAsString();
                    try {
                        return format.parse(dateStr);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            }).setDateFormat(pattern).create();
            gsonThreadLocal.set(gson);
        }
        if (gson != null) {
            obj = gson.fromJson(jsonStr, cl);
        }
        return (T)obj;
    }

    public static <T> List<T> toArrayList(JsonElement jsonElement, Class<T> clazz) {
        return JsonCommand.toArrayList(JsonCommand.toJson(jsonElement), clazz);
    }

    public static <T> List<T> toArrayList(String json, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        array = (Object[])gsonThreadLocal.get().fromJson(json, array.getClass());
        ArrayList<T> list = new ArrayList<T>();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                list.add(clazz.cast(array[i]));
            }
        }
        return list;
    }

    public static <T> T[] toArray(String json, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, 0);
        array = (Object[])gsonThreadLocal.get().fromJson(json, array.getClass());
        return array;
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        return JsonCommand.toArrayList(json, clazz);
    }

    public static <T> T to(String str, Class<T> clazz) {
        if (clazz.isArray()) {
            return (T)JsonCommand.toArray(str, clazz);
        }
        return JsonCommand.fromJson(str, clazz);
    }

    public static <T> T to(JsonElement jsonElement, Class<T> clazz) {
        String string = JsonCommand.toJson(jsonElement);
        return JsonCommand.to(string, clazz);
    }

    public static String toJson(Object obj) {
        Gson gson = gsonThreadLocal.get();
        return gson.toJson(obj);
    }

    public static JsonElement toJsonElement(String str) {
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse(str);
    }

    public static <T> T fromObject(Object object, Class<T> clazz) {
        String json = JsonCommand.toJson(object);
        return JsonCommand.to(json, clazz);
    }

    public static <T> T fromJson(String str, Class<T> type) {
        if (type.getName().equalsIgnoreCase(JsonObject.class.getName()) || type.getName().equalsIgnoreCase(JsonArray.class.getName()) || type.getName().equalsIgnoreCase(JsonElement.class.getName())) {
            return type.cast(JsonCommand.toJsonElement(str));
        }
        return (T)gsonThreadLocal.get().fromJson(str, type);
    }

    public static JsonObject fromXml(String xmlStr) {
        JsonElement jsonElement = XmlBetweenJsonObject.toJSONObject(xmlStr).gson();
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new JsonObject();
    }

    public static JsonObject fromMap(Map<?, ?> map) {
        JsonElement jsonElement = new MapJson(map).gson();
        if (jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return new JsonObject();
    }

    public static MapJson fromResourceBundle(ResourceBundle bundle) {
        MapJson mapJson = new MapJson();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJsonUtil.propertyPut(mapJson, key, bundle.getString(key));
        }
        return mapJson;
    }

    private static MapJson newJsonObject() {
        return new MapJson();
    }

    private static ListJson newJsonArray() {
        return new ListJson();
    }

    private static MapJson newJsonObject(String jsonStr) {
        return new MapJson(jsonStr);
    }

    private static MapJson newJsonObject(Object obj) {
        return new MapJson(obj);
    }

    public static ListJson newJsonArray(String jsonStr) {
        return new ListJson(jsonStr);
    }

    public static JsonString newJson(Object obj) {
        String jsonStr;
        if (null == obj) {
            return null;
        }
        Object json = null;
        json = obj instanceof JsonString ? (JsonString)obj : (obj instanceof String ? ((jsonStr = ((String)obj).trim()).startsWith("[") ? JsonCommand.newJsonArray(jsonStr) : JsonCommand.newJsonObject(jsonStr)) : (obj instanceof Collection || obj.getClass().isArray() ? new ListJson(obj) : new MapJson(obj)));
        return json;
    }

    public static JsonString readJSON(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJson(FileReader.create(file, charset).readString());
    }

    public static MapJson readJSONObject(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJsonObject(FileReader.create(file, charset).readString());
    }

    public static ListJson readJSONArray(File file, Charset charset) throws IORuntimeException {
        return JsonCommand.newJsonArray(FileReader.create(file, charset).readString());
    }

    public static String string(StringJson json, int indentFactor) {
        return json.toJSONString(indentFactor);
    }

    public static String string(StringJson json) {
        return json.toJSONString(0);
    }

    public static String stringPretty(StringJson json) {
        return json.toJSONString(4);
    }

    public static String string(Object obj) {
        String str = null;
        Gson gson = gsonThreadLocal.get();
        try {
            str = gson.toJson(obj);
        }
        catch (Exception e) {
            str = JsonCommand.string(JsonCommand.newJson(obj));
        }
        return str;
    }

    public static String stringPretty(Object obj) {
        return JsonCommand.stringPretty(JsonCommand.newJson(obj));
    }

    public static String stringXml(JsonString json) {
        return XmlBetweenJsonObject.toString(json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String quote(String string) {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            try {
                return JsonCommand.quote(string, sw).toString();
            }
            catch (IOException ignored) {
                return "";
            }
        }
    }

    public static Writer quote(String string, Writer writer) throws IOException {
        if (StringCommand.isEmpty(string)) {
            writer.write("\"\"");
            return writer;
        }
        char c = '\u0000';
        int len = string.length();
        writer.write(34);
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    writer.write(92);
                    writer.write(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        writer.write(92);
                    }
                    writer.write(c);
                    continue block9;
                }
                case '\b': {
                    writer.write("\\b");
                    continue block9;
                }
                case '\t': {
                    writer.write("\\t");
                    continue block9;
                }
                case '\n': {
                    writer.write("\\n");
                    continue block9;
                }
                case '\f': {
                    writer.write("\\f");
                    continue block9;
                }
                case '\r': {
                    writer.write("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        writer.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        writer.write("0000", 0, 4 - hhhh.length());
                        writer.write(hhhh);
                        continue block9;
                    }
                    writer.write(c);
                }
            }
        }
        writer.write(34);
        return writer;
    }

    public static Object wrap(Object object) {
        try {
            String objectPackageName;
            if (object == null) {
                return NullJson.NULL;
            }
            if (object instanceof JsonString || NullJson.NULL.equals(object) || object instanceof StringJson || object instanceof CharSequence || object instanceof Number || ObjectCommand.isBasicType(object)) {
                return object;
            }
            if (object instanceof Collection) {
                Collection coll = (Collection)object;
                return new ListJson(coll);
            }
            if (ArrayCommand.isArray(object)) {
                return new ListJson(object);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                return new MapJson(map);
            }
            Package objectPackage = object.getClass().getPackage();
            String string = objectPackageName = objectPackage != null ? objectPackage.getName() : "";
            if (objectPackageName.startsWith("java.") || objectPackageName.startsWith("javax.") || object.getClass().getClassLoader() == null) {
                return object.toString();
            }
            return new MapJson(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static JsonPrimitive replace(Map map, JsonPrimitive jsonPrimitive) {
        JsonPrimitive data = null;
        if (jsonPrimitive.isString()) {
            String key = jsonPrimitive.getAsString();
            if (map.containsKey(key)) {
                data = new JsonPrimitive(map.get(jsonPrimitive.getAsString()).toString());
            }
        } else {
            String key = jsonPrimitive.getAsString();
            if (map.containsKey(key)) {
                data = new JsonPrimitive(map.get(jsonPrimitive.toString()).toString());
            }
        }
        return data;
    }

    public static JsonObject replace(YmlNode ymlNode, JsonElement jsonElement, String to, JsonObject data) {
        block8: {
            try {
                Map map = ymlNode.map();
                if (jsonElement.isJsonPrimitive()) {
                    JsonPrimitive temp = jsonElement.getAsJsonPrimitive();
                    data.add(to, (JsonElement)JsonCommand.replace(map, temp));
                } else if (jsonElement.isJsonArray()) {
                    JsonArray temp = jsonElement.getAsJsonArray();
                    JsonArray newTemp = new JsonArray();
                    temp.forEach(element -> {
                        if (element.isJsonPrimitive()) {
                            JsonPrimitive cache = element.getAsJsonPrimitive();
                            JsonPrimitive newCache = JsonCommand.replace(map, cache);
                            if (newCache != null) {
                                newTemp.add((JsonElement)newCache);
                            } else {
                                newTemp.add((JsonElement)cache);
                            }
                        }
                    });
                    data.add(to, (JsonElement)newTemp);
                } else if (jsonElement == null || jsonElement.isJsonNull()) {
                    logger.debug("skip null field about element", (Object)data);
                } else {
                    logger.error("could not hand replace operation. about:{}", (Object)jsonElement);
                }
            }
            catch (Exception e) {
                String string = ymlNode.string();
                if (string == null) break block8;
                data.addProperty(to, string);
            }
        }
        return data;
    }

    public static JsonArray arrayFormat(YmlNode ymlNode, JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        if (ymlNode.get("source").list() != null) {
            List list = ymlNode.get("source").list();
            list.forEach(s -> {
                try {
                    JsonArray array = (JsonArray)jsonObject.get(s.toString());
                    array.forEach(element -> {
                        try {
                            JsonObject data = JsonCommand.format(ymlNode, (JsonObject)element);
                            jsonArray.add((JsonElement)data);
                        }
                        catch (Exception e) {
                            logger.error("should be a jsonObject in {} JsonArray", s, (Object)e);
                        }
                    });
                }
                catch (Exception e) {
                    logger.error("must be JsonArray format.", (Throwable)e);
                }
            });
            return jsonArray;
        }
        logger.error("should input a array refer about jsonobject");
        return null;
    }

    public static JsonObject format(YmlNode ymlNode, JsonObject jsonObject) {
        List listScheme;
        JsonObject source;
        JsonObject messageData = new JsonObject();
        Map scheme = ymlNode.get("data").map();
        Map map = ymlNode.get("source").map();
        if (map != null && map.size() > 0) {
            source = new JsonObject();
            map.forEach((key, value) -> {
                if (key.equals(value)) {
                    JsonElement tempSource = jsonObject.get(key.toString());
                    if (tempSource.isJsonObject()) {
                        JsonObject referSource = (JsonObject)tempSource;
                        referSource.entrySet().forEach(json -> source.add((String)json.getKey(), (JsonElement)json.getValue()));
                    }
                } else {
                    source.add(value.toString(), jsonObject.get(key.toString()));
                }
            });
        } else {
            source = jsonObject;
        }
        scheme.forEach((key, value) -> {
            if (value instanceof String) {
                Object oo = JsonCommand.getEntity(source, value.toString());
                if (oo != null) {
                    messageData.addProperty(key.toString(), oo.toString());
                } else {
                    messageData.add(key.toString(), (JsonElement)JsonNull.INSTANCE);
                }
            } else if (value instanceof List) {
                JsonArray array = (JsonArray)JsonCommand.getEntity(source, value);
                if (array != null && array.size() > 0) {
                    messageData.add(key.toString(), (JsonElement)array);
                } else {
                    messageData.add(key.toString(), (JsonElement)JsonNull.INSTANCE);
                }
            } else if (value instanceof Map) {
                JsonObject object = (JsonObject)JsonCommand.getEntity(source, value);
                if (object != null && object.size() > 0) {
                    messageData.add(key.toString(), (JsonElement)object);
                } else {
                    messageData.add(key.toString(), (JsonElement)JsonNull.INSTANCE);
                }
            }
        });
        map = ymlNode.get("mapData").map();
        if (map != null && map.size() > 0) {
            List mapScheme = ymlNode.get("mapScheme").list();
            mapScheme.forEach(s -> {
                JsonElement jsonElement = messageData.get(s.toString());
                YmlNode newValue = ymlNode.get("mapData").get(s.toString());
                JsonCommand.replace(newValue, jsonElement, s.toString(), messageData);
            });
        }
        if ((listScheme = ymlNode.get("set").list()) != null && listScheme.size() > 0) {
            listScheme.forEach(l -> {
                JsonElement jsonElement = messageData.get(l.toString());
                if (jsonElement != null) {
                    HashSet data = new HashSet();
                    if (jsonElement.isJsonArray()) {
                        jsonElement.getAsJsonArray().forEach(e -> {
                            if (e.isJsonPrimitive()) {
                                data.add(e.getAsJsonPrimitive());
                            }
                        });
                        if (data.size() > 0) {
                            try {
                                messageData.remove(l.toString());
                                JsonArray covert = new JsonArray();
                                data.forEach(value -> covert.add((JsonElement)value));
                                messageData.add(l.toString(), (JsonElement)covert);
                            }
                            catch (Exception e2) {
                                messageData.add(l.toString(), jsonElement);
                                logger.debug("could not set the field. reset the value to default.");
                            }
                        }
                    }
                }
            });
        }
        return messageData;
    }

    private static JsonElement getJsonEntity(JsonObject data, String key) {
        Object oo = null;
        oo = data.has(key) ? (data.get(key).isJsonPrimitive() ? data.get(key).getAsJsonPrimitive() : (data.get(key).isJsonArray() ? data.get(key).getAsJsonArray() : (data.get(key).isJsonObject() ? data.get(key).getAsJsonObject() : null))) : JsonNull.INSTANCE;
        return oo;
    }

    private static Object getEntity(JsonObject data, Object key) {
        Object oo;
        if (key instanceof String) {
            if (data.has(key.toString())) {
                if (data.get(key.toString()).isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = data.get(key.toString()).getAsJsonPrimitive();
                    oo = jsonPrimitive.isString() ? jsonPrimitive.getAsString() : (jsonPrimitive.isBoolean() ? Boolean.valueOf(jsonPrimitive.getAsBoolean()) : (jsonPrimitive.isNumber() ? jsonPrimitive.getAsNumber() : jsonPrimitive.getAsString()));
                } else if (data.get(key.toString()).isJsonArray()) {
                    JsonArray jsonElements = data.get(key.toString()).getAsJsonArray();
                    StringBuilder stringBuilder = new StringBuilder();
                    jsonElements.forEach(element -> stringBuilder.append(element.toString()));
                    oo = stringBuilder.toString();
                } else if (data.get(key.toString()).isJsonObject()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    JsonObject jsonObject = data.get(key.toString()).getAsJsonObject();
                    jsonObject.entrySet().forEach(entry -> stringBuilder.append(JsonCommand.getEntity(data, entry.getKey())));
                    oo = stringBuilder.toString();
                } else {
                    oo = null;
                }
            } else {
                oo = null;
            }
        } else if (key instanceof List) {
            JsonArray jsonArray = new JsonArray();
            List list = (List)key;
            list.forEach(l -> {
                if (l instanceof String) {
                    JsonElement ooo = JsonCommand.getJsonEntity(data, l.toString());
                    if (ooo instanceof JsonArray) {
                        jsonArray.addAll((JsonArray)ooo);
                    } else {
                        jsonArray.add(ooo);
                    }
                } else {
                    Object ooo = JsonCommand.getEntity(data, l);
                    if (ooo != null) {
                        if (ooo instanceof JsonElement) {
                            jsonArray.add((JsonElement)ooo);
                        } else {
                            jsonArray.add(ooo.toString());
                        }
                    }
                }
            });
            oo = jsonArray;
        } else if (key instanceof Map) {
            JsonObject jsonObject = new JsonObject();
            Map map = (Map)key;
            map.forEach((k, v) -> {
                if (v instanceof String) {
                    JsonElement ooo = JsonCommand.getJsonEntity(data, v.toString());
                    jsonObject.add(k.toString(), ooo);
                } else {
                    Object ooo = JsonCommand.getEntity(data, v);
                    jsonObject.addProperty(k.toString(), ooo.toString());
                }
            });
            oo = jsonObject;
        } else {
            logger.warn("did not support this type:{} for yml config in the map config file.", key);
            return null;
        }
        return oo;
    }

    public static JsonArray formatToArray(YmlNode ymlNode, JsonObject jsonObject) {
        JsonArray jsonArray = new JsonArray();
        String index = ymlNode.get("index").string();
        if (index == null) {
            logger.error("config error could not covert the data to array.");
        } else {
            try {
                int size = jsonObject.get(index).getAsJsonArray().size();
                int i = 0;
                while (i < size) {
                    JsonObject covert = new JsonObject();
                    List scheme = ymlNode.get("scheme").list();
                    int[] j = new int[]{i++};
                    scheme.forEach(s -> {
                        if (jsonObject.has(s.toString()) && jsonObject.get(s.toString()) != null) {
                            if (jsonObject.get(s.toString()).isJsonArray()) {
                                covert.add(s.toString(), jsonObject.get(s.toString()).getAsJsonArray().get(j[0]));
                            } else if (jsonObject.get(s.toString()).isJsonPrimitive()) {
                                covert.add(s.toString(), (JsonElement)jsonObject.get(s.toString()).getAsJsonPrimitive());
                            } else if (jsonObject.get(s.toString()).isJsonObject()) {
                                covert.add(s.toString(), (JsonElement)jsonObject.get(s.toString()).getAsJsonObject());
                            } else {
                                covert.add(s.toString(), (JsonElement)JsonNull.INSTANCE);
                            }
                        } else {
                            covert.add(s.toString(), null);
                        }
                    });
                    JsonObject result = JsonCommand.format(ymlNode, covert);
                    jsonArray.add((JsonElement)result);
                }
            }
            catch (Exception e) {
                logger.error("type not correct {}. cause by {}", (Object)jsonObject, (Object)e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        return jsonArray;
    }

    public static JsonObject merge(JsonObject left, JsonObject right) {
        Set ss = right.entrySet();
        for (Map.Entry sss : ss) {
            if (left.has((String)sss.getKey())) {
                throw new UnsupportedOperationException("left jsonObject and right jsonObject has conflict key:" + (String)sss.getKey());
            }
            left.add((String)sss.getKey(), (JsonElement)sss.getValue());
        }
        return left;
    }

    public static JsonObject mergeInLeft(JsonObject left, JsonObject right) {
        Set ss = right.entrySet();
        for (Map.Entry sss : ss) {
            if (left.has((String)sss.getKey())) continue;
            left.add((String)sss.getKey(), (JsonElement)sss.getValue());
        }
        return left;
    }

    public static JsonPrimitive jsonPrimitive(Object object) {
        if (object instanceof String) {
            return new JsonPrimitive(object.toString());
        }
        if (object instanceof Timestamp) {
            return new JsonPrimitive((Number)((Timestamp)object).getTime());
        }
        if (object instanceof Long) {
            return new JsonPrimitive((Number)((Long)object));
        }
        if (object instanceof Integer) {
            return new JsonPrimitive((Number)((Integer)object));
        }
        if (object instanceof Short) {
            return new JsonPrimitive((Number)((Short)object));
        }
        if (object instanceof Character) {
            return new JsonPrimitive((Character)object);
        }
        if (object instanceof Float) {
            return new JsonPrimitive((Number)Float.valueOf(((Float)object).floatValue()));
        }
        if (object instanceof Double) {
            return new JsonPrimitive((Number)((Double)object));
        }
        if (object instanceof Boolean) {
            return new JsonPrimitive(Boolean.valueOf((Boolean)object));
        }
        if (object instanceof Byte) {
            return new JsonPrimitive((Number)((Byte)object));
        }
        if (object instanceof BigDecimal) {
            return new JsonPrimitive(((BigDecimal)object).toString());
        }
        if (object instanceof BigInteger) {
            return new JsonPrimitive(object.toString());
        }
        if (object instanceof JsonElement) {
            return new JsonPrimitive(object.toString());
        }
        if (object instanceof Map) {
            return new JsonPrimitive(JsonCommand.jsonObject(object).toString());
        }
        if (object instanceof List) {
            return new JsonPrimitive(JsonCommand.json(object));
        }
        if (object instanceof Set) {
            return new JsonPrimitive(JsonCommand.json(object));
        }
        if (object.getClass() == Integer.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Long.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Double.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Float.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Short.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Byte.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Boolean.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        if (object.getClass() == Character.TYPE) {
            return new JsonPrimitive(object.toString());
        }
        throw new IllegalStateException("Type mapping implemented for Presto type: " + JsonCommand.toJson(object));
    }
}

