/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.Editor;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class ArrayCommand {
    private ArrayCommand() {
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static double[] doubles(List<Double> array) {
        Double[] temp = array.toArray(new Double[array.size()]);
        double[] cache = ArrayCommand.doubles(temp);
        return cache;
    }

    public static double[] doubles(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return ArrayUtils.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(long[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(int[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(short[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(char[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(byte[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(double[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(float[] array) {
        return array != null && array.length != 0;
    }

    public static boolean isNotEmpty(boolean[] array) {
        return array != null && array.length != 0;
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    @SafeVarargs
    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayCommand.isEmpty(newElements)) {
            return buffer;
        }
        T[] t = ArrayCommand.resize(buffer, buffer.length + newElements.length);
        System.arraycopy(newElements, 0, t, buffer.length, newElements.length);
        return t;
    }

    public static <T> T[] resize(T[] buffer, int newSize, Class<?> componentType) {
        T[] newArray = ArrayCommand.newArray(componentType, newSize);
        if (ArrayCommand.isNotEmpty(buffer)) {
            System.arraycopy(buffer, 0, newArray, 0, Math.min(buffer.length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayCommand.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    @SafeVarargs
    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            length += array.length;
        }
        T[] result = ArrayCommand.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (array == null) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayCommand.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static int[] range(int excludedEnd) {
        return ArrayCommand.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return ArrayCommand.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static byte[][] split(byte[] array, int len) {
        int x = array.length / len;
        int y = array.length % len;
        int z = 0;
        if (y != 0) {
            z = 1;
        }
        byte[][] arrays = new byte[x + z][];
        for (int i = 0; i < x + z; ++i) {
            byte[] arr = new byte[len];
            if (i == x + z - 1 && y != 0) {
                System.arraycopy(array, i * len, arr, 0, y);
            } else {
                System.arraycopy(array, i * len, arr, 0, len);
            }
            arrays[i] = arr;
        }
        return arrays;
    }

    public static <T> T[] filter(T[] array, Editor<T> editor) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(t);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T, K> Map<T, K> zip(T[] keys, K[] values, boolean isOrder) {
        if (ArrayCommand.isEmpty(keys) || ArrayCommand.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap map = CollectionCommand.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static <T, K> Map<T, K> zip(T[] keys, K[] values) {
        return ArrayCommand.zip(keys, values, false);
    }

    public static <T> boolean contains(T[] array, T value) {
        Class<?> componetType = array.getClass().getComponentType();
        boolean isPrimitive = false;
        if (null != componetType) {
            isPrimitive = componetType.isPrimitive();
        }
        for (T t : array) {
            if (t == value) {
                return true;
            }
            if (isPrimitive || null == value || !value.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static Integer[] wrap(int ... values) {
        int length = values.length;
        Integer[] array = new Integer[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static int[] unWrap(Integer ... values) {
        int length = values.length;
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        int length = values.length;
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unWrap(Long ... values) {
        int length = values.length;
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        int length = values.length;
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unWrap(Character ... values) {
        int length = values.length;
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].charValue();
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        int length = values.length;
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unWrap(Byte ... values) {
        int length = values.length;
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        int length = values.length;
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unWrap(Short ... values) {
        int length = values.length;
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        int length = values.length;
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unWrap(Float ... values) {
        int length = values.length;
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].floatValue();
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        int length = values.length;
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unWrap(Double ... values) {
        int length = values.length;
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Boolean[] wrap(boolean ... values) {
        int length = values.length;
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unWrap(Boolean ... values) {
        int length = values.length;
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Object[] wrap(Object obj) {
        if (ArrayCommand.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayCommand.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayCommand.wrap((int[])obj);
                    }
                    case "short": {
                        return ArrayCommand.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayCommand.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayCommand.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayCommand.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayCommand.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayCommand.wrap((double[])obj);
                    }
                }
                throw new UtilException(e);
            }
        }
        throw new UtilException(StringCommand.format("[{}] is not Array!", obj.getClass()));
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            throw new NullPointerException("Object check for isArray is null");
        }
        return obj.getClass().isArray();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayCommand.isArray(obj)) {
            try {
                return Arrays.deepToString((Object[])obj);
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return Arrays.toString((long[])obj);
                    }
                    case "int": {
                        return Arrays.toString((int[])obj);
                    }
                    case "short": {
                        return Arrays.toString((short[])obj);
                    }
                    case "char": {
                        return Arrays.toString((char[])obj);
                    }
                    case "byte": {
                        return Arrays.toString((byte[])obj);
                    }
                    case "boolean": {
                        return Arrays.toString((boolean[])obj);
                    }
                    case "float": {
                        return Arrays.toString((float[])obj);
                    }
                    case "double": {
                        return Arrays.toString((double[])obj);
                    }
                }
                throw new UtilException(e);
            }
        }
        return obj.toString();
    }

    public static <T> String join(T[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (ArrayCommand.isArray(item)) {
                sb.append(ArrayCommand.join(ArrayCommand.wrap(item), conjunction));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(CollectionCommand.join((Iterable)item, conjunction));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(CollectionCommand.join((Iterator)item, conjunction));
                continue;
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(long[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(int[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(short[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (short item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(char[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (char item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(byte[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(boolean[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (boolean item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(float[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (float item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(double[] array, String conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (double item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Object array, String conjunction) {
        if (ArrayCommand.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayCommand.join((long[])array, conjunction);
                    }
                    case "int": {
                        return ArrayCommand.join((int[])array, conjunction);
                    }
                    case "short": {
                        return ArrayCommand.join((short[])array, conjunction);
                    }
                    case "char": {
                        return ArrayCommand.join((char[])array, conjunction);
                    }
                    case "byte": {
                        return ArrayCommand.join((byte[])array, conjunction);
                    }
                    case "boolean": {
                        return ArrayCommand.join((boolean[])array, conjunction);
                    }
                    case "float": {
                        return ArrayCommand.join((float[])array, conjunction);
                    }
                    case "double": {
                        return ArrayCommand.join((double[])array, conjunction);
                    }
                }
                throw new UtilException("Unknown primitive type: [{}]", componentTypeName);
            }
            return ArrayCommand.join((Object[])array, conjunction);
        }
        throw new UtilException(StringCommand.format("[{}] is not a Array!", array.getClass()));
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            int oldPosition = bytebuffer.position();
            bytebuffer.position(0);
            int size = bytebuffer.limit();
            byte[] buffers = new byte[size];
            bytebuffer.get(buffers);
            bytebuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
    }
}

