/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public abstract class BaseObjectWrapper<T> {
    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return BaseObjectWrapper.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = BaseObjectWrapper.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!BaseObjectWrapper.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(BaseObjectWrapper.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public abstract Class<T> getTClass();

    public Class<T> returnedClass() {
        return BaseObjectWrapper.getTypeArguments(BaseObjectWrapper.class, this.getClass()).get(0);
    }
}

