/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.Introspector;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gjgr.pig.chivalrous.core.convert.BasicType;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassScaner;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.Filter;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.Singleton;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.lang.map.ConcurrentReferenceHashMap;

public final class ClassCommand {
    public static final String ARRAY_SUFFIX = "[]";
    public static final String CGLIB_CLASS_SEPARATOR = "$$";
    public static final String CLASS_FILE_SUFFIX = ".class";
    public static final FieldFilter COPYABLE_FIELDS = field -> !Modifier.isStatic(field.getModifiers()) && !Modifier.isFinal(field.getModifiers());
    public static final MethodFilter NON_BRIDGED_METHODS = method -> !method.isBridge();
    public static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && method.getDeclaringClass() != Object.class;
    private static final String INTERNAL_ARRAY_PREFIX = "[";
    private static final String NON_PRIMITIVE_ARRAY_PREFIX = "[L";
    private static final char PACKAGE_SEPARATOR = '.';
    private static final char PATH_SEPARATOR = '/';
    private static final char INNER_CLASS_SEPARATOR = '$';
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new IdentityHashMap(8);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new IdentityHashMap(8);
    private static final Map<String, Class<?>> primitiveTypeNameMap = new HashMap(32);
    private static final Map<String, Class<?>> commonClassCache = new HashMap(64);
    private static final Set<Class<?>> javaLanguageInterfaces;
    private static final String CGLIB_RENAMED_METHOD_PREFIX = "CGLIB$";
    private static final Method[] NO_METHODS;
    private static final Field[] NO_FIELDS;
    private static final Map<Class<?>, Method[]> declaredMethodsCache;
    private static final Map<Class<?>, Field[]> declaredFieldsCache;

    private ClassCommand() {
    }

    public static Class<?>[] getClasses(Object ... objects) {
        Class[] classes = new Class[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            classes[i] = objects[i].getClass();
        }
        return classes;
    }

    public static List<Field> getPublicStaticFields(Class<?> clazz) {
        Field[] allFields = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(allFields.length);
        for (Field field : allFields) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier)) continue;
            fields.add(field);
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<Field> getPrivateInstanceFields(Class<?> clazz) {
        Field[] allFields = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(allFields.length);
        for (Field field : allFields) {
            int modifier = field.getModifiers();
            if (!Modifier.isPrivate(modifier) || Modifier.isStatic(modifier)) continue;
            fields.add(field);
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<Field> getPublicInstanceFields(Class<?> clazz) {
        Field[] allFields = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(allFields.length);
        for (Field field : allFields) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || Modifier.isStatic(modifier)) continue;
            fields.add(field);
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<Field> getFields(Class<?> clazz, List<String> fieldNames) {
        ArrayList<Object> fields = new ArrayList<Object>();
        try {
            for (String fieldName : fieldNames) {
                Field f = clazz.getDeclaredField((String)Preconditions.checkNotNull((Object)fieldName));
                fields.add(Preconditions.checkNotNull((Object)f));
            }
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e);
        }
        return Collections.unmodifiableList(fields);
    }

    public static List<String> toFieldNames(List<Field> fields) {
        List results = fields.stream().map(f -> f.getName()).sorted().collect(Collectors.toList());
        return Collections.unmodifiableList(results);
    }

    public static Object getInstanceField(Object instance, String fieldName) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field field = instance.getClass().getDeclaredField(fieldName);
        field.setAccessible(true);
        return field.get(instance);
    }

    public static Set<Class<?>> scanPackageByAnnotation(String packageName, Class<? extends Annotation> annotationClass) {
        return ClassScaner.scanPackageByAnnotation(packageName, annotationClass);
    }

    public static Set<Class<?>> scanPackageBySuper(String packageName, Class<?> superClass) {
        return ClassScaner.scanPackageBySuper(packageName, superClass);
    }

    public static Set<Class<?>> scanPackage() {
        return ClassScaner.scanPackage();
    }

    public static Set<Class<?>> scanPackage(String packageName) {
        return ClassScaner.scanPackage(packageName);
    }

    public static Set<Class<?>> scanPackage(String packageName, Filter<Class<?>> classFilter) {
        return ClassScaner.scanPackage(packageName, classFilter);
    }

    public static Set<String> getPublicMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassCommand.getPublicMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getPublicMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Filter<Method> filter) {
        ArrayList<Method> methodList;
        if (null == clazz) {
            return null;
        }
        Method[] methods = ClassCommand.getPublicMethods(clazz);
        if (null != filter) {
            methodList = new ArrayList();
            for (Method method : methods) {
                if (!filter.accept(method)) continue;
                methodList.add(method);
            }
        } else {
            methodList = CollectionCommand.newArrayList(methods);
        }
        return methodList;
    }

    public static List<Method> getPublicMethods(Class<?> clazz, Method ... excludeMethods) {
        final HashSet<Method> excludeMethodSet = CollectionCommand.newHashSet(excludeMethods);
        return ClassCommand.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodSet.contains(method);
            }
        });
    }

    public static List<Method> getPublicMethods(Class<?> clazz, String ... excludeMethodNames) {
        final HashSet<String> excludeMethodNameSet = CollectionCommand.newHashSet(excludeMethodNames);
        return ClassCommand.getPublicMethods(clazz, new Filter<Method>(){

            @Override
            public boolean accept(Method method) {
                return false == excludeMethodNameSet.contains(method.getName());
            }
        });
    }

    public static Method getPublicMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return ClassCommand.getDeclaredMethod(clazz, methodName, paramTypes);
        }
    }

    public static Set<String> getDeclaredMethodNames(Class<?> clazz) {
        Method[] methodArray;
        HashSet<String> methodSet = new HashSet<String>();
        for (Method method : methodArray = ClassCommand.getDeclaredMethods(clazz)) {
            String methodName = method.getName();
            methodSet.add(methodName);
        }
        return methodSet;
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) {
        HashSet<Method> methodSet = new HashSet<Method>();
        while (null != clazz) {
            Method[] declaredMethods;
            for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
                methodSet.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methodSet.toArray(new Method[methodSet.size()]);
    }

    public static Method getDeclaredMethodOfObj(Object obj, String methodName, Object ... args) throws NoSuchMethodException, SecurityException {
        return ClassCommand.getDeclaredMethod(obj.getClass(), methodName, ClassCommand.getClasses(args));
    }

    public static Method getDeclaredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        Method method = null;
        while (null != clazz) {
            try {
                method = clazz.getDeclaredMethod(methodName, parameterTypes);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                clazz = clazz.getSuperclass();
            }
        }
        return method;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !"equals".equals(method.getName())) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && "hashCode".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    public static Set<String> getClassPathResources() {
        return ClassCommand.getClassPaths("");
    }

    public static Set<String> getClassPaths(String packageName) {
        Enumeration<URL> resources;
        String packagePath = packageName.replace(".", "/");
        try {
            resources = ClassCommand.getClassLoader().getResources(packagePath);
        }
        catch (IOException e) {
            throw new UtilException(StringCommand.format("Loading classPath [{}] error!", packagePath), e);
        }
        HashSet<String> paths = new HashSet<String>();
        while (resources.hasMoreElements()) {
            paths.add(resources.nextElement().getPath());
        }
        return paths;
    }

    public static String getClassPath() {
        return ClassCommand.getClassPathURL().getPath();
    }

    public static URL getClassPathURL() {
        return ClassCommand.getURL("");
    }

    public static URL getURL(String resource) {
        return ClassCommand.getClassLoader().getResource(resource);
    }

    public static String[] getJavaClassPaths() {
        String[] classPaths = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        return classPaths;
    }

    public static ClassLoader getContextClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static ClassLoader getClassLoader() {
        ClassLoader classLoader = ClassCommand.getContextClassLoader();
        if (classLoader == null && null == (classLoader = ClassCommand.class.getClassLoader())) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static <T> T newInstance(String clazz) {
        try {
            return (T)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StringCommand.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UtilException(StringCommand.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... params) {
        if (ArrayCommand.isEmpty(params)) {
            return ClassCommand.newInstance(clazz);
        }
        Class<?>[] paramTypes = ClassCommand.getClasses(params);
        Constructor<T> constructor = ClassCommand.getConstructor(clazz, ClassCommand.getClasses(params));
        if (null == constructor) {
            throw new UtilException("No Constructor matched for parameter types: [{}]", new Object[]{paramTypes});
        }
        try {
            return ClassCommand.getConstructor(clazz, paramTypes).newInstance(params);
        }
        catch (Exception e) {
            throw new UtilException(StringCommand.format("Instance class [{}] error!", clazz), e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        Constructor<?>[] constructors;
        if (null == clazz) {
            return null;
        }
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            Class<?>[] pts = constructor.getParameterTypes();
            if (!ClassCommand.isAllAssignableFrom(pts, parameterTypes)) continue;
            return constructor;
        }
        return null;
    }

    public static boolean isAllAssignableFrom(Class<?>[] types1, Class<?>[] types2) {
        if (ArrayCommand.isEmpty(types1) && ArrayCommand.isEmpty(types2)) {
            return true;
        }
        if (types1.length == types2.length) {
            for (int i = 0; i < types1.length; ++i) {
                if (types1[i].isAssignableFrom(types2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static <T> Class<T> loadClass(String className, boolean isInitialized) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className, isInitialized, ClassCommand.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new UtilException(e);
        }
        return clazz;
    }

    public static <T> Class<T> loadClass(String className) {
        return ClassCommand.loadClass(className, true);
    }

    public static <T> T invoke(String classNameDotMethodName, Object[] args) {
        return ClassCommand.invoke(classNameDotMethodName, false, args);
    }

    public static <T> T invoke(String classNameWithMethodName, boolean isSingleton, Object[] args) {
        if (StringCommand.isBlank(classNameWithMethodName)) {
            throw new UtilException("Blank classNameDotMethodName!");
        }
        int splitIndex = classNameWithMethodName.lastIndexOf(35);
        if (splitIndex <= 0) {
            splitIndex = classNameWithMethodName.lastIndexOf(46);
        }
        if (splitIndex <= 0) {
            throw new UtilException("Invalid classNameWithMethodName [{}]!", classNameWithMethodName);
        }
        String className = classNameWithMethodName.substring(0, splitIndex);
        String methodName = classNameWithMethodName.substring(splitIndex + 1);
        return ClassCommand.invoke(className, methodName, isSingleton, args);
    }

    public static <T> T invoke(String className, String methodName, Object[] args) {
        return ClassCommand.invoke(className, methodName, false, args);
    }

    public static <T> T invoke(String className, String methodName, boolean isSingleton, Object[] args) {
        Class<T> clazz = ClassCommand.loadClass(className);
        try {
            Method method = ClassCommand.getDeclaredMethod(clazz, methodName, ClassCommand.getClasses(args));
            if (null == method) {
                throw new NoSuchMethodException(StringCommand.format("No such method: [{}]", methodName));
            }
            if (ClassCommand.isStatic(method)) {
                return ClassCommand.invoke(null, method, args);
            }
            return ClassCommand.invoke(isSingleton ? Singleton.get(clazz, new Object[0]) : clazz.newInstance(), method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Object[] args) {
        try {
            Method method = ClassCommand.getDeclaredMethodOfObj(obj, methodName, args);
            if (null == method) {
                throw new NoSuchMethodException(StringCommand.format("No such method: [{}]", methodName));
            }
            return ClassCommand.invoke(obj, method, args);
        }
        catch (Exception e) {
            throw new UtilException(e);
        }
    }

    public static <T> T invokeStatic(Method method, Object[] args) throws InvocationTargetException, IllegalArgumentException {
        return ClassCommand.invoke(null, method, args);
    }

    public static <T> T invoke(Object obj, Method method, Object[] args) throws InvocationTargetException, IllegalArgumentException {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return (T)method.invoke(ClassCommand.isStatic(method) ? null : obj, args);
        }
        catch (IllegalAccessException e) {
            throw new UtilException(e);
        }
    }

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return BasicType.wrapperPrimitiveMap.containsKey(clazz);
    }

    public static boolean isBasicType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return clazz.isPrimitive() || ClassCommand.isPrimitiveWrapper(clazz);
    }

    public static boolean isSimpleTypeOrArray(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        return ClassCommand.isSimpleValueType(clazz) || clazz.isArray() && ClassCommand.isSimpleValueType(clazz.getComponentType());
    }

    public static boolean isSimpleValueType(Class<?> clazz) {
        return ClassCommand.isBasicType(clazz) || clazz.isEnum() || CharSequence.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Date.class.isAssignableFrom(clazz) || clazz.equals(URI.class) || clazz.equals(URL.class) || clazz.equals(Locale.class) || clazz.equals(Class.class);
    }

    public static boolean isAssignable(Class<?> targetType, Class<?> sourceType) {
        Class<?> resolvedWrapper;
        Class<?> resolvedPrimitive;
        if (null == targetType || null == sourceType) {
            return false;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        return targetType.isPrimitive() ? (resolvedPrimitive = BasicType.wrapperPrimitiveMap.get(sourceType)) != null && targetType.equals(resolvedPrimitive) : (resolvedWrapper = BasicType.primitiveWrapperMap.get(sourceType)) != null && targetType.isAssignableFrom(resolvedWrapper);
    }

    public static boolean isPublic(Class<?> clazz) {
        if (null == clazz) {
            throw new NullPointerException("Class to provided is null.");
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Method method) {
        if (null == method) {
            throw new NullPointerException("Method to provided is null.");
        }
        return ClassCommand.isPublic(method.getDeclaringClass());
    }

    public static boolean isNotPublic(Class<?> clazz) {
        return false == ClassCommand.isPublic(clazz);
    }

    public static boolean isNotPublic(Method method) {
        return false == ClassCommand.isPublic(method);
    }

    public static boolean isStatic(Method method) {
        return Modifier.isStatic(method.getModifiers());
    }

    public static Method setAccessible(Method method) {
        if (null != method && ClassCommand.isNotPublic(method)) {
            method.setAccessible(true);
        }
        return method;
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isNormalClass(Class<?> clazz) {
        return null != clazz && false == clazz.isInterface() && false == ClassCommand.isAbstract(clazz) && false == clazz.isEnum() && false == clazz.isArray() && false == clazz.isAnnotation() && false == clazz.isSynthetic() && false == clazz.isPrimitive();
    }

    public static Class<?> getTypeArgument(Class<?> clazz) {
        return ClassCommand.getTypeArgument(clazz, 0);
    }

    public static Class<?> getTypeArgument(Class<?> clazz, int index) {
        Type type;
        ParameterizedType genericSuperclass;
        Type[] types;
        Type superType = clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType && null != (types = (genericSuperclass = (ParameterizedType)superType).getActualTypeArguments()) && types.length > index && (type = types[index]) instanceof Class) {
            return (Class)type;
        }
        return null;
    }

    public static String getPackage(Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(".");
        if (packageEndIndex == -1) {
            return "";
        }
        return className.substring(0, packageEndIndex);
    }

    public static String getPackagePath(Class<?> clazz) {
        return ClassCommand.getPackage(clazz).replace('.', '/');
    }

    private static void registerCommonClasses(Class<?> ... commonClasses) {
        for (Class<?> clazz : commonClasses) {
            commonClassCache.put(clazz.getName(), clazz);
        }
    }

    @Nullable
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ClassCommand.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }

    @Nullable
    public static ClassLoader overrideThreadContextClassLoader(@Nullable ClassLoader classLoaderToUse) {
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        if (classLoaderToUse != null && !classLoaderToUse.equals(threadContextClassLoader)) {
            currentThread.setContextClassLoader(classLoaderToUse);
            return threadContextClassLoader;
        }
        return null;
    }

    public static Class<?> forName(String name, @Nullable ClassLoader classLoader) throws ClassNotFoundException, LinkageError {
        AssertCommand.notNull(name, "Name must not be null");
        Class<?> clazz = ClassCommand.resolvePrimitiveClassName(name);
        if (clazz == null) {
            clazz = commonClassCache.get(name);
        }
        if (clazz != null) {
            return clazz;
        }
        if (name.endsWith(ARRAY_SUFFIX)) {
            String elementClassName = name.substring(0, name.length() - ARRAY_SUFFIX.length());
            Class<?> elementClass = ClassCommand.forName(elementClassName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(NON_PRIMITIVE_ARRAY_PREFIX) && name.endsWith(";")) {
            String elementName = name.substring(NON_PRIMITIVE_ARRAY_PREFIX.length(), name.length() - 1);
            Class<?> elementClass = ClassCommand.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        if (name.startsWith(INTERNAL_ARRAY_PREFIX)) {
            String elementName = name.substring(INTERNAL_ARRAY_PREFIX.length());
            Class<?> elementClass = ClassCommand.forName(elementName, classLoader);
            return Array.newInstance(elementClass, 0).getClass();
        }
        ClassLoader clToUse = classLoader;
        if (clToUse == null) {
            clToUse = ClassCommand.getDefaultClassLoader();
        }
        try {
            return clToUse != null ? clToUse.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException ex) {
            int lastDotIndex = name.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String innerClassName = name.substring(0, lastDotIndex) + '$' + name.substring(lastDotIndex + 1);
                try {
                    return clToUse != null ? clToUse.loadClass(innerClassName) : Class.forName(innerClassName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw ex;
        }
    }

    public static Class<?> resolveClassName(String className, @Nullable ClassLoader classLoader) throws IllegalArgumentException {
        try {
            return ClassCommand.forName(className, classLoader);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class [" + className + "]", ex);
        }
        catch (LinkageError err) {
            throw new IllegalArgumentException("Unresolvable class definition for class [" + className + "]", err);
        }
    }

    public static boolean isPresent(String className, @Nullable ClassLoader classLoader) {
        try {
            ClassCommand.forName(className, classLoader);
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isVisible(Class<?> clazz, @Nullable ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassCommand.isLoadable(clazz, classLoader);
    }

    public static boolean isCacheSafe(Class<?> clazz, @Nullable ClassLoader classLoader) {
        AssertCommand.notNull(clazz, "Class must not be null");
        try {
            ClassLoader target = clazz.getClassLoader();
            if (target == classLoader || target == null) {
                return true;
            }
            if (classLoader == null) {
                return false;
            }
            ClassLoader current = classLoader;
            while (current != null) {
                if ((current = current.getParent()) != target) continue;
                return true;
            }
            while (target != null) {
                if ((target = target.getParent()) != classLoader) continue;
                return false;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return classLoader != null && ClassCommand.isLoadable(clazz, classLoader);
    }

    private static boolean isLoadable(Class<?> clazz, ClassLoader classLoader) {
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    @Nullable
    public static Class<?> resolvePrimitiveClassName(@Nullable String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = primitiveTypeNameMap.get(name);
        }
        return result;
    }

    public static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() || ClassCommand.isPrimitiveWrapper(clazz);
    }

    public static boolean isPrimitiveArray(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return clazz.isArray() && ClassCommand.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static Class<?> resolvePrimitiveIfNecessary(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return clazz.isPrimitive() && clazz != Void.TYPE ? primitiveTypeToWrapperMap.get(clazz) : clazz;
    }

    public static boolean isAssignableValue(Class<?> type, @Nullable Object value) {
        AssertCommand.notNull(type, "Type must not be null");
        return value != null ? ClassCommand.isAssignable(type, value.getClass()) : !type.isPrimitive();
    }

    public static String convertResourcePathToClassName(String resourcePath) {
        AssertCommand.notNull(resourcePath, "Resource path must not be null");
        return resourcePath.replace('/', '.');
    }

    public static String convertClassNameToResourcePath(String className) {
        AssertCommand.notNull(className, "Class name must not be null");
        return className.replace('.', '/');
    }

    public static String addResourcePathToPackagePath(Class<?> clazz, String resourceName) {
        AssertCommand.notNull(resourceName, "Resource name must not be null");
        if (!resourceName.startsWith("/")) {
            return ClassCommand.classPackageAsResourcePath(clazz) + '/' + resourceName;
        }
        return ClassCommand.classPackageAsResourcePath(clazz) + resourceName;
    }

    public static String classPackageAsResourcePath(@Nullable Class<?> clazz) {
        if (clazz == null) {
            return "";
        }
        String className = clazz.getName();
        int packageEndIndex = className.lastIndexOf(46);
        if (packageEndIndex == -1) {
            return "";
        }
        String packageName = className.substring(0, packageEndIndex);
        return packageName.replace('.', '/');
    }

    public static String classNamesToString(Class<?> ... classes) {
        return ClassCommand.classNamesToString(Arrays.asList(classes));
    }

    public static String classNamesToString(@Nullable Collection<Class<?>> classes) {
        if (CollectionCommand.isEmpty(classes)) {
            return ARRAY_SUFFIX;
        }
        StringBuilder sb = new StringBuilder(INTERNAL_ARRAY_PREFIX);
        Iterator<Class<?>> it = classes.iterator();
        while (it.hasNext()) {
            Class<?> clazz = it.next();
            sb.append(clazz.getName());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public static Class<?>[] toClassArray(Collection<Class<?>> collection) {
        return collection.toArray(new Class[0]);
    }

    public static Class<?>[] getAllInterfaces(Object instance) {
        AssertCommand.notNull(instance, "Instance must not be null");
        return ClassCommand.getAllInterfacesForClass(instance.getClass());
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz) {
        return ClassCommand.getAllInterfacesForClass(clazz, null);
    }

    public static Class<?>[] getAllInterfacesForClass(Class<?> clazz, @Nullable ClassLoader classLoader) {
        return ClassCommand.toClassArray(ClassCommand.getAllInterfacesForClassAsSet(clazz, classLoader));
    }

    public static Set<Class<?>> getAllInterfacesAsSet(Object instance) {
        AssertCommand.notNull(instance, "Instance must not be null");
        return ClassCommand.getAllInterfacesForClassAsSet(instance.getClass());
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz) {
        return ClassCommand.getAllInterfacesForClassAsSet(clazz, null);
    }

    public static Set<Class<?>> getAllInterfacesForClassAsSet(Class<?> clazz, @Nullable ClassLoader classLoader) {
        AssertCommand.notNull(clazz, "Class must not be null");
        if (clazz.isInterface() && ClassCommand.isVisible(clazz, classLoader)) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = current.getInterfaces()) {
                if (!ClassCommand.isVisible(ifc, classLoader)) continue;
                interfaces.add(ifc);
            }
        }
        return interfaces;
    }

    public static Class<?> createCompositeInterface(Class<?>[] interfaces, @Nullable ClassLoader classLoader) {
        AssertCommand.notEmpty(interfaces, "Interfaces must not be empty");
        return Proxy.getProxyClass(classLoader, interfaces);
    }

    @Nullable
    public static Class<?> determineCommonAncestor(@Nullable Class<?> clazz1, @Nullable Class<?> clazz2) {
        if (clazz1 == null) {
            return clazz2;
        }
        if (clazz2 == null) {
            return clazz1;
        }
        if (clazz1.isAssignableFrom(clazz2)) {
            return clazz1;
        }
        if (clazz2.isAssignableFrom(clazz1)) {
            return clazz2;
        }
        Class<?> ancestor = clazz1;
        do {
            if ((ancestor = ancestor.getSuperclass()) != null && Object.class != ancestor) continue;
            return null;
        } while (!ancestor.isAssignableFrom(clazz2));
        return ancestor;
    }

    public static boolean isJavaLanguageInterface(Class<?> ifc) {
        return javaLanguageInterfaces.contains(ifc);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isCglibProxy(Object object) {
        return ClassCommand.isCglibProxyClass(object.getClass());
    }

    public static boolean isCglibProxyClass(@Nullable Class<?> clazz) {
        return clazz != null && ClassCommand.isCglibProxyClassName(clazz.getName());
    }

    public static boolean isCglibProxyClassName(@Nullable String className) {
        return className != null && className.contains(CGLIB_CLASS_SEPARATOR);
    }

    public static Class<?> getUserClass(Object instance) {
        AssertCommand.notNull(instance, "Instance must not be null");
        return ClassCommand.getUserClass(instance.getClass());
    }

    public static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass = clazz.getSuperclass()) != null && Object.class != superclass) {
            return superclass;
        }
        return clazz;
    }

    @Nullable
    public static String getDescriptiveType(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        if (Proxy.isProxyClass(clazz)) {
            StringBuilder result = new StringBuilder(clazz.getName());
            result.append(" implementing ");
            Class<?>[] ifcs = clazz.getInterfaces();
            for (int i = 0; i < ifcs.length; ++i) {
                result.append(ifcs[i].getName());
                if (i >= ifcs.length - 1) continue;
                result.append(',');
            }
            return result.toString();
        }
        return clazz.getTypeName();
    }

    public static boolean matchesTypeName(Class<?> clazz, @Nullable String typeName) {
        return typeName != null && (typeName.equals(clazz.getTypeName()) || typeName.equals(clazz.getSimpleName()));
    }

    public static String getShortName(String className) {
        AssertCommand.hasLength(className, "Class name must not be empty");
        int lastDotIndex = className.lastIndexOf(46);
        int nameEndIndex = className.indexOf(CGLIB_CLASS_SEPARATOR);
        if (nameEndIndex == -1) {
            nameEndIndex = className.length();
        }
        String shortName = className.substring(lastDotIndex + 1, nameEndIndex);
        shortName = shortName.replace('$', '.');
        return shortName;
    }

    public static String getShortName(Class<?> clazz) {
        return ClassCommand.getShortName(ClassCommand.getQualifiedName(clazz));
    }

    public static String getShortNameAsProperty(Class<?> clazz) {
        String shortName = ClassCommand.getShortName(clazz);
        int dotIndex = shortName.lastIndexOf(46);
        shortName = dotIndex != -1 ? shortName.substring(dotIndex + 1) : shortName;
        return Introspector.decapitalize(shortName);
    }

    public static String getClassFileName(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        int lastDotIndex = className.lastIndexOf(46);
        return className.substring(lastDotIndex + 1) + CLASS_FILE_SUFFIX;
    }

    public static String getPackageName(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return ClassCommand.getPackageName(clazz.getName());
    }

    public static String getPackageName(String fqClassName) {
        AssertCommand.notNull(fqClassName, "Class name must not be null");
        int lastDotIndex = fqClassName.lastIndexOf(46);
        return lastDotIndex != -1 ? fqClassName.substring(0, lastDotIndex) : "";
    }

    public static String getQualifiedName(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        return clazz.getTypeName();
    }

    public static String getQualifiedMethodName(Method method) {
        return ClassCommand.getQualifiedMethodName(method, null);
    }

    public static String getQualifiedMethodName(Method method, @Nullable Class<?> clazz) {
        AssertCommand.notNull(method, "Method must not be null");
        return (clazz != null ? clazz : method.getDeclaringClass()).getName() + '.' + method.getName();
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... paramTypes) {
        return ClassCommand.getConstructorIfAvailable(clazz, paramTypes) != null;
    }

    @Nullable
    public static <T> Constructor<T> getConstructorIfAvailable(Class<T> clazz, Class<?> ... paramTypes) {
        AssertCommand.notNull(clazz, "Class must not be null");
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static boolean hasMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        return ClassCommand.getMethodIfAvailable(clazz, methodName, paramTypes) != null;
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(methodName, "Method name must not be null");
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Expected method not found: " + ex);
            }
        }
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        if (candidates.isEmpty()) {
            throw new IllegalStateException("Expected method not found: " + clazz.getName() + '.' + methodName);
        }
        throw new IllegalStateException("No unique method found: " + clazz.getName() + '.' + methodName);
    }

    @Nullable
    public static Method getMethodIfAvailable(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        Method[] methods;
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(methodName, "Method name must not be null");
        if (paramTypes != null) {
            try {
                return clazz.getMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }
        HashSet<Method> candidates = new HashSet<Method>(1);
        for (Method method : methods = clazz.getMethods()) {
            if (!methodName.equals(method.getName())) continue;
            candidates.add(method);
        }
        if (candidates.size() == 1) {
            return (Method)candidates.iterator().next();
        }
        return null;
    }

    public static int getMethodCountForName(Class<?> clazz, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(methodName, "Method name must not be null");
        int count = 0;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!methodName.equals(method.getName())) continue;
            ++count;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            count += ClassCommand.getMethodCountForName(ifc, methodName);
        }
        if (clazz.getSuperclass() != null) {
            count += ClassCommand.getMethodCountForName(clazz.getSuperclass(), methodName);
        }
        return count;
    }

    public static boolean hasAtLeastOneMethodWithName(Class<?> clazz, String methodName) {
        Class<?>[] ifcs;
        Method[] declaredMethods;
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(methodName, "Method name must not be null");
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return true;
        }
        for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
            if (!ClassCommand.hasAtLeastOneMethodWithName(ifc, methodName)) continue;
            return true;
        }
        return clazz.getSuperclass() != null && ClassCommand.hasAtLeastOneMethodWithName(clazz.getSuperclass(), methodName);
    }

    public static Method getMostSpecificMethod(Method method, @Nullable Class<?> targetClass) {
        if (targetClass != null && targetClass != method.getDeclaringClass() && ClassCommand.isOverridable(method, targetClass)) {
            try {
                if (Modifier.isPublic(method.getModifiers())) {
                    try {
                        return targetClass.getMethod(method.getName(), method.getParameterTypes());
                    }
                    catch (NoSuchMethodException ex) {
                        return method;
                    }
                }
                Method specificMethod = ClassCommand.findMethod(targetClass, method.getName(), method.getParameterTypes());
                return specificMethod != null ? specificMethod : method;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return method;
    }

    @Nullable
    public static Field findField(Class<?> clazz, String name) {
        return ClassCommand.findField(clazz, name, null);
    }

    @Nullable
    public static Field findField(Class<?> clazz, @Nullable String name, @Nullable Class<?> type) {
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.isTrue(name != null || type != null, "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ClassCommand.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    public static void setField(Field field, @Nullable Object target, @Nullable Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException ex) {
            ClassCommand.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    @Nullable
    public static Object getField(Field field, @Nullable Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            ClassCommand.handleReflectionException(ex);
            throw new IllegalStateException("Unexpected reflection exception - " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name) {
        return ClassCommand.findMethod(clazz, name, new Class[0]);
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ClassCommand.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target) {
        return ClassCommand.invokeMethod(method, target, new Object[0]);
    }

    @Nullable
    public static Object invokeMethod(Method method, @Nullable Object target, Object ... args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ClassCommand.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    @Nullable
    public static Object invokeJdbcMethod(Method method, @Nullable Object target) throws SQLException {
        return ClassCommand.invokeJdbcMethod(method, target, new Object[0]);
    }

    @Nullable
    public static Object invokeJdbcMethod(Method method, @Nullable Object target, Object ... args) throws SQLException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalAccessException ex) {
            ClassCommand.handleReflectionException(ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException) {
                throw (SQLException)ex.getTargetException();
            }
            ClassCommand.handleInvocationTargetException(ex);
        }
        throw new IllegalStateException("Should never get here");
    }

    public static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ClassCommand.handleInvocationTargetException((InvocationTargetException)ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void handleInvocationTargetException(InvocationTargetException ex) {
        ClassCommand.rethrowRuntimeException(ex.getTargetException());
    }

    public static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static void rethrowException(Throwable ex) throws Exception {
        if (ex instanceof Exception) {
            throw (Exception)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static boolean declaresException(Method method, Class<?> exceptionType) {
        Class<?>[] declaredExceptions;
        AssertCommand.notNull(method, "Method must not be null");
        for (Class<?> declaredException : declaredExceptions = method.getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(exceptionType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicStaticFinal(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers);
    }

    public static boolean isObjectMethod(@Nullable Method method) {
        if (method == null) {
            return false;
        }
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isCglibRenamedMethod(Method renamedMethod) {
        String name = renamedMethod.getName();
        if (name.startsWith(CGLIB_RENAMED_METHOD_PREFIX)) {
            int i;
            for (i = name.length() - 1; i >= 0 && Character.isDigit(name.charAt(i)); --i) {
            }
            return i > CGLIB_RENAMED_METHOD_PREFIX.length() && i < name.length() - 1 && name.charAt(i) == '$';
        }
        return false;
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static void makeAccessible(Constructor<?> ctor) {
        if (!(Modifier.isPublic(ctor.getModifiers()) && Modifier.isPublic(ctor.getDeclaringClass().getModifiers()) || ctor.isAccessible())) {
            ctor.setAccessible(true);
        }
    }

    public static <T> Constructor<T> accessibleConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<T> ctor = clazz.getDeclaredConstructor(parameterTypes);
        ClassCommand.makeAccessible(ctor);
        return ctor;
    }

    public static void doWithLocalMethods(Class<?> clazz, MethodCallback mc) {
        Method[] methods;
        for (Method method : methods = ClassCommand.getDeclaredMethods(clazz)) {
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc) {
        ClassCommand.doWithMethods(clazz, mc, null);
    }

    public static void doWithMethods(Class<?> clazz, MethodCallback mc, @Nullable MethodFilter mf) {
        Method[] methods = ClassCommand.getDeclaredMethods(clazz);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            try {
                mc.doWith(method);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access method '" + method.getName() + "': " + ex);
            }
        }
        if (clazz.getSuperclass() != null) {
            ClassCommand.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ClassCommand.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Method[] getAllDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(32);
        ClassCommand.doWithMethods(leafClass, methods::add);
        return methods.toArray(new Method[0]);
    }

    public static Method[] getUniqueDeclaredMethods(Class<?> leafClass) {
        ArrayList methods = new ArrayList(32);
        ClassCommand.doWithMethods(leafClass, method -> {
            boolean knownSignature = false;
            Method methodBeingOverriddenWithCovariantReturnType = null;
            for (Method existingMethod : methods) {
                if (!method.getName().equals(existingMethod.getName()) || !Arrays.equals(method.getParameterTypes(), existingMethod.getParameterTypes())) continue;
                if (existingMethod.getReturnType() != method.getReturnType() && existingMethod.getReturnType().isAssignableFrom(method.getReturnType())) {
                    methodBeingOverriddenWithCovariantReturnType = existingMethod;
                    break;
                }
                knownSignature = true;
                break;
            }
            if (methodBeingOverriddenWithCovariantReturnType != null) {
                methods.remove(methodBeingOverriddenWithCovariantReturnType);
            }
            if (!knownSignature && !ClassCommand.isCglibRenamedMethod(method)) {
                methods.add(method);
            }
        });
        return methods.toArray(new Method[0]);
    }

    @Nullable
    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        LinkedList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new LinkedList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static void doWithLocalFields(Class<?> clazz, FieldCallback fc) {
        for (Field field : ClassCommand.getDeclaredFields(clazz)) {
            try {
                fc.doWith(field);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
            }
        }
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc) {
        ClassCommand.doWithFields(clazz, fc, null);
    }

    public static void doWithFields(Class<?> clazz, FieldCallback fc, @Nullable FieldFilter ff) {
        Class<?> targetClass = clazz;
        do {
            Field[] fields;
            for (Field field : fields = ClassCommand.getDeclaredFields(targetClass)) {
                if (ff != null && !ff.matches(field)) continue;
                try {
                    fc.doWith(field);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Not allowed to access field '" + field.getName() + "': " + ex);
                }
            }
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class);
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        AssertCommand.notNull(clazz, "Class must not be null");
        Field[] result = declaredFieldsCache.get(clazz);
        if (result == null) {
            try {
                result = clazz.getDeclaredFields();
                declaredFieldsCache.put(clazz, result.length == 0 ? NO_FIELDS : result);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return result;
    }

    public static void shallowCopyFieldState(Object src, Object dest) {
        AssertCommand.notNull(src, "Source for field copy cannot be null");
        AssertCommand.notNull(dest, "Destination for field copy cannot be null");
        if (!src.getClass().isAssignableFrom(dest.getClass())) {
            throw new IllegalArgumentException("Destination class [" + dest.getClass().getName() + "] must be same or subclass as source class [" + src.getClass().getName() + "]");
        }
        ClassCommand.doWithFields(src.getClass(), field -> {
            ClassCommand.makeAccessible(field);
            Object srcValue = field.get(src);
            field.set(dest, srcValue);
        }, COPYABLE_FIELDS);
    }

    public static void clearCache() {
        declaredMethodsCache.clear();
        declaredFieldsCache.clear();
    }

    public static boolean isUserLevelMethod(Method method) {
        AssertCommand.notNull(method, "Method must not be null");
        return method.isBridge() || !method.isSynthetic() && !ClassCommand.isGroovyObjectMethod(method);
    }

    private static boolean isGroovyObjectMethod(Method method) {
        return method.getDeclaringClass().getName().equals("groovy.lang.GroovyObject");
    }

    private static boolean isOverridable(Method method, @Nullable Class<?> targetClass) {
        if (Modifier.isPrivate(method.getModifiers())) {
            return false;
        }
        if (Modifier.isPublic(method.getModifiers()) || Modifier.isProtected(method.getModifiers())) {
            return true;
        }
        return targetClass == null || ClassCommand.getPackageName(method.getDeclaringClass()).equals(ClassCommand.getPackageName(targetClass));
    }

    @Nullable
    public static Method getStaticMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        AssertCommand.notNull(clazz, "Class must not be null");
        AssertCommand.notNull(methodName, "Method name must not be null");
        try {
            Method method = clazz.getMethod(methodName, args);
            return Modifier.isStatic(method.getModifiers()) ? method : null;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static StackTraceElement[] watchClass(Thread thread) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace;
    }

    public static StackTraceElement watchThread(Thread thread) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[2];
    }

    public static String watchThreadClass(Thread thread) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[2].getClassName();
    }

    public static String watchThreadClassMethod(Thread thread) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[2].getClassName() + "." + stackTrace[2].getMethodName();
    }

    public static String watchThreadClassMethodLine(Thread thread) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return stackTrace[2].getClassName() + "." + stackTrace[2].getMethodName() + ":" + stackTrace[2].getLineNumber();
    }

    public static Class getSuperClassGenricType(Class clazz) {
        return ClassCommand.getSuperClassGenricType(clazz, 0);
    }

    public static Class getSuperClassGenricType(Class clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperClassParameterType(Object instance, Class<?> classOfInterest) {
        return ClassCommand.getSuperClassParameterType(instance, classOfInterest, 0);
    }

    private static void extractTypeArguments(Map<Type, Type> typeMap, Class<?> clazz) {
        Type genericSuperclass = clazz.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericSuperclass;
        TypeVariable<Class<T>>[] typeParameter = ((Class)parameterizedType.getRawType()).getTypeParameters();
        Type[] actualTypeArgument = parameterizedType.getActualTypeArguments();
        for (int i = 0; i < typeParameter.length; ++i) {
            if (typeMap.containsKey(actualTypeArgument[i])) {
                actualTypeArgument[i] = typeMap.get(actualTypeArgument[i]);
            }
            typeMap.put(typeParameter[i], actualTypeArgument[i]);
        }
    }

    public static Class<?> getSuperClassParameterType(Object instance, Class<?> classOfInterest, int parameterIndex) {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        Class<?> instanceClass = instance.getClass();
        while (classOfInterest != instanceClass.getSuperclass()) {
            ClassCommand.extractTypeArguments(typeMap, instanceClass);
            if ((instanceClass = instanceClass.getSuperclass()) != null) continue;
            throw new IllegalArgumentException();
        }
        ParameterizedType parameterizedType = (ParameterizedType)instanceClass.getGenericSuperclass();
        Type actualType = parameterizedType.getActualTypeArguments()[parameterIndex];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        throw new IllegalArgumentException();
    }

    private static Class<?> takeNestedTypes(Object instance, TypeVariable<?> actualType) {
        Class<?> instanceClass = instance.getClass();
        LinkedList nestedOuterTypes = new LinkedList();
        for (Class<?> enclosingClass = instanceClass.getEnclosingClass(); enclosingClass != null; enclosingClass = enclosingClass.getEnclosingClass()) {
            try {
                Field this$0 = instanceClass.getDeclaredField("this$0");
                Object outerInstance = this$0.get(instance);
                Class<?> outerClass = outerInstance.getClass();
                nestedOuterTypes.add(outerClass);
                HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                ClassCommand.extractTypeArguments(outerTypeMap, outerClass);
                for (Map.Entry entry : outerTypeMap.entrySet()) {
                    TypeVariable foundType;
                    if (!(entry.getKey() instanceof TypeVariable) || !(foundType = (TypeVariable)entry.getKey()).getName().equals(actualType.getName()) || !ClassCommand.isInnerClass(foundType.getGenericDeclaration(), actualType.getGenericDeclaration())) continue;
                    if (entry.getValue() instanceof Class) {
                        return (Class)entry.getValue();
                    }
                    actualType = (TypeVariable)entry.getValue();
                }
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException();
    }

    private static boolean isInnerClass(GenericDeclaration outerDeclaration, GenericDeclaration innerDeclaration) {
        if (!(outerDeclaration instanceof Class) || !(innerDeclaration instanceof Class)) {
            throw new IllegalArgumentException();
        }
        Class outerClass = (Class)outerDeclaration;
        Class<?> innerClass = (Class<?>)innerDeclaration;
        while ((innerClass = innerClass.getEnclosingClass()) != null) {
            if (innerClass != outerClass) continue;
            return true;
        }
        return false;
    }

    static {
        NO_METHODS = new Method[0];
        NO_FIELDS = new Field[0];
        declaredMethodsCache = new ConcurrentReferenceHashMap(256);
        declaredFieldsCache = new ConcurrentReferenceHashMap(256);
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.forEach((key, value) -> {
            primitiveTypeToWrapperMap.put((Class<?>)value, (Class<?>)key);
            ClassCommand.registerCommonClasses(key);
        });
        HashSet primitiveTypes = new HashSet(32);
        primitiveTypes.addAll(primitiveWrapperTypeMap.values());
        Collections.addAll(primitiveTypes, boolean[].class, byte[].class, char[].class, double[].class, float[].class, int[].class, long[].class, short[].class);
        primitiveTypes.add(Void.TYPE);
        for (Class clazz : primitiveTypes) {
            primitiveTypeNameMap.put(clazz.getName(), clazz);
        }
        ClassCommand.registerCommonClasses(Boolean[].class, Byte[].class, Character[].class, Double[].class, Float[].class, Integer[].class, Long[].class, Short[].class);
        ClassCommand.registerCommonClasses(Number.class, Number[].class, String.class, String[].class, Class.class, Class[].class, Object.class, Object[].class);
        ClassCommand.registerCommonClasses(Throwable.class, Exception.class, RuntimeException.class, Error.class, StackTraceElement.class, StackTraceElement[].class);
        ClassCommand.registerCommonClasses(Enum.class, Iterable.class, Iterator.class, Enumeration.class, Collection.class, List.class, Set.class, Map.class, Map.Entry.class, Optional.class);
        Class[] javaLanguageInterfaceArray = new Class[]{Serializable.class, Externalizable.class, Closeable.class, AutoCloseable.class, Cloneable.class, Comparable.class};
        ClassCommand.registerCommonClasses(javaLanguageInterfaceArray);
        javaLanguageInterfaces = new HashSet<Class>(Arrays.asList(javaLanguageInterfaceArray));
    }

    @FunctionalInterface
    public static interface FieldFilter {
        public boolean matches(Field var1);
    }

    @FunctionalInterface
    public static interface FieldCallback {
        public void doWith(Field var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    public static interface MethodFilter {
        public boolean matches(Method var1);
    }

    @FunctionalInterface
    public static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }
}

