/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.getter.BasicTypeGetter;
import org.gjgr.pig.chivalrous.core.lang.BeanUtil;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;

public class Dict
extends HashMap<String, Object>
implements BasicTypeGetter<String> {
    private static final long serialVersionUID = 6135423866861206530L;

    public static Dict create() {
        return new Dict();
    }

    public static <T> Dict parse(T bean) {
        return Dict.create().parseBean(bean);
    }

    public <T> T toBean(T bean) {
        return this.toBean(bean, false);
    }

    public <T> T toBean(T bean, boolean isToCamelCase) {
        BeanUtil.fillBeanWithMap(this, bean, isToCamelCase);
        return bean;
    }

    public <T> T toBean(Class<T> clazz) {
        return BeanUtil.mapToBean(this, clazz, false);
    }

    public <T> T toBeanIgnoreCase(Class<T> clazz) {
        return BeanUtil.mapToBeanIgnoreCase(this, clazz, false);
    }

    public <T> Dict parseBean(T bean) {
        this.putAll(BeanUtil.beanToMap(bean));
        return this;
    }

    public <T extends Dict> void removeEqual(T dict, String ... withoutNames) {
        HashSet<String> withoutSet = CollectionCommand.newHashSet(withoutNames);
        for (Map.Entry entry : dict.entrySet()) {
            Object value;
            if (withoutSet.contains(entry.getKey()) || null == (value = this.get(entry.getKey())) || !value.equals(entry.getValue())) continue;
            this.remove(entry.getKey());
        }
    }

    public Dict set(String attr, Object value) {
        this.put(attr, value);
        return this;
    }

    public Dict setIgnoreNull(String attr, Object value) {
        if (null != attr && null != value) {
            this.set(attr, value);
        }
        return this;
    }

    @Override
    public Object getObj(String key) {
        return super.get(key);
    }

    @Override
    public String getStr(String attr) {
        return Convert.toStr(this.get(attr), null);
    }

    @Override
    public Integer getInt(String attr) {
        return Convert.toInt(this.get(attr), null);
    }

    @Override
    public Short getShort(String attr) {
        return Convert.toShort(this.get(attr), null);
    }

    @Override
    public Boolean getBool(String attr) {
        return Convert.toBool(this.get(attr), null);
    }

    @Override
    public Long getLong(String attr) {
        return Convert.toLong(this.get(attr), null);
    }

    @Override
    public Character getChar(String attr) {
        return Convert.toChar(this.get(attr), null);
    }

    @Override
    public Float getFloat(String attr) {
        return Convert.toFloat(this.get(attr), null);
    }

    @Override
    public Double getDouble(String attr) {
        return Convert.toDouble(this.get(attr), null);
    }

    @Override
    public Byte getByte(String attr) {
        return Convert.toByte(this.get(attr), null);
    }

    @Override
    public BigDecimal getBigDecimal(String attr) {
        return Convert.toBigDecimal(this.get(attr));
    }

    @Override
    public BigInteger getBigInteger(String attr) {
        return Convert.toBigInteger(this.get(attr));
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return Convert.toEnum(clazz, this.get(key));
    }

    public <T> T get(String attr, T defaultValue) {
        Object result = this.get(attr);
        return (T)(result != null ? result : defaultValue);
    }

    public byte[] getBytes(String attr) {
        return this.get(attr, null);
    }

    public Date getDate(String attr) {
        return this.get(attr, null);
    }

    public Time getTime(String attr) {
        return this.get(attr, null);
    }

    public Timestamp getTimestamp(String attr) {
        return this.get(attr, null);
    }

    public Number getNumber(String attr) {
        return this.get(attr, null);
    }

    @Override
    public Dict clone() {
        return (Dict)super.clone();
    }
}

