/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.io.File;
import java.util.LinkedList;
import org.gjgr.pig.chivalrous.core.io.resource.LocationCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;

public class FindCommand {
    public static File[] findFiles(File file, String filename) {
        LinkedList<File> files = new LinkedList<File>();
        for (File f : file.listFiles()) {
            File[] ff;
            if (f.isFile()) {
                if (!f.getName().equalsIgnoreCase(filename)) continue;
                files.add(f);
                continue;
            }
            if (!f.isDirectory() || (ff = FindCommand.findFiles(f, filename)).length == 0) continue;
            files.addAll(CollectionCommand.newArrayList(ff));
        }
        if (files.size() == 0) {
            return new File[0];
        }
        return files.toArray(new File[1]);
    }

    public static File[] findFiles(String path, String filename) {
        File dir = new File(path);
        if (!dir.exists()) {
            return null;
        }
        File[] matches = FindCommand.findFiles(dir, filename);
        return matches;
    }

    public static File findFile(String path, String filename) {
        File[] files = FindCommand.findFiles(path, filename);
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }

    public static File[] findFiles(String filename) {
        String path = LocationCommand.userDir();
        return FindCommand.findFiles(path, filename);
    }

    public static File findFile(String filename) {
        File[] files = FindCommand.findFiles(filename);
        if (files.length == 0) {
            return null;
        }
        return files[0];
    }
}

