/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;

public class JarClassLoader
extends URLClassLoader {
    public JarClassLoader() {
        this(new URL[0]);
    }

    public JarClassLoader(URL[] urls) {
        super(urls, ClassCommand.getClassLoader());
    }

    public static JarClassLoader loadJar(File jarFile) {
        JarClassLoader loader = new JarClassLoader();
        try {
            loader.addJar(jarFile);
        }
        finally {
            IoCommand.close(loader);
        }
        return loader;
    }

    public static void loadJar(URLClassLoader loader, File jarFile) {
        try {
            Method method = ClassCommand.getDeclaredMethod(URLClassLoader.class, "addURL", URL.class);
            if (null != method) {
                method.setAccessible(true);
                List<File> jars = JarClassLoader.loopJar(jarFile);
                for (File jar : jars) {
                    ClassCommand.invoke((Object)loader, method, new Object[]{jar.toURI().toURL()});
                }
            }
        }
        catch (IOException | ReflectiveOperationException e) {
            throw new UtilException(e);
        }
    }

    public static URLClassLoader loadJarToSystemClassLoader(File jarFile) {
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        JarClassLoader.loadJar(urlClassLoader, jarFile);
        return urlClassLoader;
    }

    private static List<File> loopJar(File file) {
        return FileCommand.loopFiles(file, new FileFilter(){

            @Override
            public boolean accept(File file) {
                String path = file.getPath();
                return path != null && path.toLowerCase().endsWith(".jar");
            }
        });
    }

    public JarClassLoader addJar(File jarFile) {
        List<File> jars = JarClassLoader.loopJar(jarFile);
        try {
            for (File jar : jars) {
                super.addURL(jar.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new UtilException(e);
        }
        return this;
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }
}

