/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReflectCommand.class);
    private static final Class<?>[] EMPTY_CLASSES = new Class[0];

    public static Object callMethod(Class<?> clazz, String methodName, Class<?>[] methodParams, Object ... args) throws Exception {
        return ReflectCommand.callMethod(clazz, null, methodName, methodParams, args);
    }

    public static Object callMethod(Class<?> clazz, Object instance, String methodName, Class<?>[] methodParams, Object ... args) throws Exception {
        Method method = clazz.getMethod(methodName, methodParams);
        return method.invoke(instance, args);
    }

    public <T> Constructor<T> getConstructorByArgsCount(Class<T> clazz, int argsCount) {
        Constructor<?>[] ctors;
        for (Constructor<?> ctor : ctors = clazz.getConstructors()) {
            if (ctor.getParameterTypes().length != argsCount) continue;
            return ctor;
        }
        return null;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            LOGGER.warn("getPropertyDescriptors of {} failed. Error: ", clazz, (Object)e);
            return new PropertyDescriptor[0];
        }
        PropertyDescriptor[] result = beanInfo.getPropertyDescriptors();
        return result == null ? new PropertyDescriptor[]{} : result;
    }

    public Object newInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new NoClassDefFoundError(className);
        }
    }

    public <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Create instance failed for class: " + clazz, e);
        }
    }

    public Class<?>[] getActualClasses(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            Class[] actualClasses = new Class[actualTypes.length];
            for (int i = 0; i < actualTypes.length; ++i) {
                Type actualType = actualTypes[i];
                if (actualType instanceof Class) {
                    actualClasses[i] = (Class)actualType;
                    continue;
                }
                if (!(actualType instanceof GenericArrayType)) continue;
                Type componentType = ((GenericArrayType)actualType).getGenericComponentType();
                actualClasses[i] = Array.newInstance((Class)componentType, 0).getClass();
            }
            return actualClasses;
        }
        return EMPTY_CLASSES;
    }
}

