/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.gjgr.pig.chivalrous.core.json.JsonCommand;
import org.gjgr.pig.chivalrous.core.lang.AntPathMatcher;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.ConstEnumStringValue;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.ObjectCommand;
import org.gjgr.pig.chivalrous.core.lang.StrFormatter;
import org.gjgr.pig.chivalrous.core.nio.CharsetCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringCommand {
    public static final char C_SPACE = ' ';
    public static final char C_TAB = '\b';
    public static final char C_DOT = '.';
    public static final char C_SLASH = '/';
    public static final char C_BACKSLASH = '\\';
    public static final char C_CR = '\r';
    public static final char C_LF = '\n';
    public static final char C_UNDERLINE = '_';
    public static final char C_COMMA = ',';
    public static final char C_DELIM_START = '{';
    public static final char C_DELIM_END = '}';
    public static final char C_COLON = ':';
    public static final String SPACE = " ";
    public static final String TAB = "\b";
    public static final String DOT = ".";
    public static final String DOUBLE_DOT = "..";
    public static final String SLASH = "/";
    public static final String BACKSLASH = "\\";
    public static final String EMPTY = "";
    public static final String CR = "\r";
    public static final String LF = "\n";
    public static final String CRLF = "\r\n";
    public static final String UNDERLINE = "_";
    public static final String COMMA = ",";
    public static final String DELIM_START = "{";
    public static final String DELIM_END = "}";
    public static final String COLON = ":";
    public static final String HTML_NBSP = "&nbsp;";
    public static final String HTML_AMP = "&amp";
    public static final String HTML_QUOTE = "&quot;";
    public static final String HTML_LT = "&lt;";
    public static final String HTML_GT = "&gt;";
    public static final String EMPTY_JSON = "{}";
    private static final Logger LOGGER = LoggerFactory.getLogger(StringCommand.class);

    private StringCommand() {
    }

    public static boolean isBlank(CharSequence str) {
        int length;
        if (str == null || (length = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String trimAllWhitespace(String str) {
        if (!StringCommand.hasLength(str)) {
            return str;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringCommand.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringCommand.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingCharacter) {
        if (!StringCommand.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(0) == leadingCharacter) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingCharacter) {
        if (!StringCommand.hasLength(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() > 0 && sb.charAt(sb.length() - 1) == trailingCharacter) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static boolean isNotBlank(CharSequence str) {
        return false == StringCommand.isBlank(str);
    }

    public static boolean hasBlank(CharSequence ... strs) {
        if (ArrayCommand.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringCommand.isBlank(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLength(@Nullable CharSequence str) {
        return str != null && str.length() > 0;
    }

    public static boolean hasLength(@Nullable String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(@Nullable CharSequence str) {
        return str != null && str.length() > 0 && StringCommand.containsText(str);
    }

    public static boolean hasText(@Nullable String str) {
        return str != null && !str.isEmpty() && StringCommand.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable CharSequence str) {
        if (!StringCommand.hasLength(str)) {
            return false;
        }
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(@Nullable String str) {
        return StringCommand.containsWhitespace((CharSequence)str);
    }

    public static String replace(String inString, String oldPattern, @Nullable String newPattern) {
        if (!StringCommand.hasLength(inString) || !StringCommand.hasLength(oldPattern) || newPattern == null) {
            return inString;
        }
        int index = inString.indexOf(oldPattern);
        if (index == -1) {
            return inString;
        }
        int capacity = inString.length();
        if (newPattern.length() > oldPattern.length()) {
            capacity += 16;
        }
        StringBuilder sb = new StringBuilder(capacity);
        int pos = 0;
        int patLen = oldPattern.length();
        while (index >= 0) {
            sb.append(inString.substring(pos, index));
            sb.append(newPattern);
            pos = index + patLen;
            index = inString.indexOf(oldPattern, pos);
        }
        sb.append(inString.substring(pos));
        return sb.toString();
    }

    public static String delete(String inString, String pattern) {
        return StringCommand.replace(inString, pattern, EMPTY);
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim, String prefix, String suffix) {
        if (CollectionUtils.isEmpty(coll)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(@Nullable Collection<?> coll, String delim) {
        return StringCommand.collectionToDelimitedString(coll, delim, EMPTY, EMPTY);
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringCommand.collectionToDelimitedString(coll, COMMA);
    }

    public static String arrayToDelimitedString(@Nullable Object[] arr, String delim) {
        if (ObjectCommand.isEmpty(arr)) {
            return EMPTY;
        }
        if (arr.length == 1) {
            return ObjectCommand.nullSafeToString(arr[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String[] addStringToArray(@Nullable String[] array, String str) {
        if (ObjectCommand.isEmpty(array)) {
            return new String[]{str};
        }
        String[] newArr = new String[array.length + 1];
        System.arraycopy(array, 0, newArr, 0, array.length);
        newArr[array.length] = str;
        return newArr;
    }

    @Nullable
    public static String[] concatenateStringArrays(@Nullable String[] array1, @Nullable String[] array2) {
        if (ObjectCommand.isEmpty(array1)) {
            return array2;
        }
        if (ObjectCommand.isEmpty(array2)) {
            return array1;
        }
        String[] newArr = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, newArr, 0, array1.length);
        System.arraycopy(array2, 0, newArr, array1.length, array2.length);
        return newArr;
    }

    @Deprecated
    @Nullable
    public static String[] mergeStringArrays(@Nullable String[] array1, @Nullable String[] array2) {
        if (ObjectCommand.isEmpty(array1)) {
            return array2;
        }
        if (ObjectCommand.isEmpty(array2)) {
            return array1;
        }
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(Arrays.asList(array1));
        for (String str : array2) {
            if (result.contains(str)) continue;
            result.add(str);
        }
        return StringCommand.toStringArray(result);
    }

    public static String[] sortStringArray(String[] array) {
        if (ObjectCommand.isEmpty(array)) {
            return new String[0];
        }
        Arrays.sort(array);
        return array;
    }

    public static String[] trimArrayElements(@Nullable String[] array) {
        if (ObjectCommand.isEmpty(array)) {
            return new String[0];
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            String element = array[i];
            result[i] = element != null ? element.trim() : null;
        }
        return result;
    }

    public static String[] removeDuplicateStrings(String[] array) {
        if (ObjectCommand.isEmpty(array)) {
            return array;
        }
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String element : array) {
            set.add(element);
        }
        return StringCommand.toStringArray(set);
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter) {
        return StringCommand.splitArrayElementsIntoProperties(array, delimiter, null);
    }

    @Nullable
    public static Properties splitArrayElementsIntoProperties(String[] array, String delimiter, @Nullable String charsToDelete) {
        if (ObjectCommand.isEmpty(array)) {
            return null;
        }
        Properties result = new Properties();
        for (String element : array) {
            String[] splittedElement;
            if (charsToDelete != null) {
                element = StringCommand.deleteAny(element, charsToDelete);
            }
            if ((splittedElement = StringCommand.split(element, delimiter)) == null) continue;
            result.setProperty(splittedElement[0].trim(), splittedElement[1].trim());
        }
        return result;
    }

    public static String[] tokenizeToStringArray(@Nullable String str, String delimiters) {
        return StringCommand.tokenizeToStringArray(str, delimiters, true, true);
    }

    public static String[] tokenizeToStringArray(@Nullable String str, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (str == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return StringCommand.toStringArray(tokens);
    }

    public static String[] commaDelimitedListToStringArray(@Nullable String str) {
        return StringCommand.delimitedListToStringArray(str, COMMA);
    }

    public static Set<String> commaDelimitedListToSet(@Nullable String str) {
        String[] tokens;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String token : tokens = StringCommand.commaDelimitedListToStringArray(str)) {
            set.add(token);
        }
        return set;
    }

    public static String arrayToCommaDelimitedString(@Nullable Object[] arr) {
        return StringCommand.arrayToDelimitedString(arr, COMMA);
    }

    public static String[] delimitedListToStringArray(@Nullable String str, @Nullable String delimiter, @Nullable String charsToDelete) {
        if (str == null) {
            return new String[0];
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (EMPTY.equals(delimiter)) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(StringCommand.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringCommand.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringCommand.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringCommand.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection.toArray(new String[0]);
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        return StringCommand.toStringArray(Collections.list(enumeration));
    }

    public static String[] delimitedListToStringArray(@Nullable String str, @Nullable String delimiter) {
        return StringCommand.delimitedListToStringArray(str, delimiter, null);
    }

    public static String deleteAny(String inString, @Nullable String charsToDelete) {
        if (!StringCommand.hasLength(inString) || !StringCommand.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isAllBlank(CharSequence ... strs) {
        if (ArrayCommand.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringCommand.isNotBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return false == StringCommand.isEmpty(str);
    }

    public static String nullToEmpty(String str) {
        return StringCommand.nullToDefault(str, EMPTY);
    }

    public static String nullToDefault(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static String emptyToNull(String str) {
        return StringCommand.isEmpty(str) ? null : str;
    }

    public static boolean hasEmpty(CharSequence ... strs) {
        if (ArrayCommand.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringCommand.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllEmpty(CharSequence ... strs) {
        if (ArrayCommand.isEmpty(strs)) {
            return true;
        }
        for (CharSequence str : strs) {
            if (!StringCommand.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        return null == str ? null : StringCommand.trim(str, 0);
    }

    public static void trim(String[] strs) {
        if (null == strs) {
            return;
        }
        for (int i = 0; i < strs.length; ++i) {
            String str = strs[i];
            if (null == str) continue;
            strs[i] = str.trim();
        }
    }

    public static String trimStart(String str) {
        return StringCommand.trim(str, -1);
    }

    public static String trimEnd(String str) {
        return StringCommand.trim(str, 1);
    }

    public static String trim(String str, int mode) {
        int start;
        if (str == null) {
            return null;
        }
        int length = str.length();
        int end = length;
        if (mode <= 0) {
            for (start = 0; start < end && Character.isWhitespace(str.charAt(start)); ++start) {
            }
        }
        if (mode >= 0) {
            while (start < end && Character.isWhitespace(str.charAt(end - 1))) {
                --end;
            }
        }
        if (start > 0 || end < length) {
            return str.substring(start, end);
        }
        return str;
    }

    public static boolean startWith(String str, String prefix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().startsWith(prefix.toLowerCase());
        }
        return str.startsWith(prefix);
    }

    public static boolean startWithIgnoreCase(String str, String prefix) {
        return StringCommand.startWith(str, prefix, true);
    }

    public static boolean endWith(String str, String suffix, boolean isIgnoreCase) {
        if (isIgnoreCase) {
            return str.toLowerCase().endsWith(suffix.toLowerCase());
        }
        return str.endsWith(suffix);
    }

    public static boolean endWithIgnoreCase(String str, String suffix) {
        return StringCommand.endWith(str, suffix, true);
    }

    public static String getGeneralField(String getOrSetMethodName) {
        if (getOrSetMethodName.startsWith("get") || getOrSetMethodName.startsWith("set")) {
            return StringCommand.removePreAndLowerFirst(getOrSetMethodName, 3);
        }
        return null;
    }

    public static String genSetter(String fieldName) {
        return StringCommand.upperFirstAndAddPre(fieldName, "set");
    }

    public static String genGetter(String fieldName) {
        return StringCommand.upperFirstAndAddPre(fieldName, "get");
    }

    public static String removeAll(String str, CharSequence strToRemove) {
        return str.replace(strToRemove, EMPTY);
    }

    public static String removePreAndLowerFirst(String str, int preLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > preLength) {
            char first = Character.toLowerCase(str.charAt(preLength));
            if (str.length() > preLength + 1) {
                return first + str.substring(preLength + 1);
            }
            return String.valueOf(first);
        }
        return str;
    }

    public static String removePreAndLowerFirst(String str, String prefix) {
        return StringCommand.lowerFirst(StringCommand.removePrefix(str, prefix));
    }

    public static String upperFirstAndAddPre(String str, String preString) {
        if (str == null || preString == null) {
            return null;
        }
        return preString + StringCommand.upperFirst(str);
    }

    public static String upperFirst(String str) {
        if (StringCommand.isBlank(str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + StringCommand.subSuf(str, 1);
    }

    public static String lowerFirst(String str) {
        if (StringCommand.isBlank(str)) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + StringCommand.subSuf(str, 1);
    }

    public static String removePrefix(String str, String prefix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(prefix)) {
            return str;
        }
        if (str.startsWith(prefix)) {
            return StringCommand.subSuf(str, prefix.length());
        }
        return str;
    }

    public static String removePrefixIgnoreCase(String str, String prefix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(prefix)) {
            return str;
        }
        if (str.toLowerCase().startsWith(prefix.toLowerCase())) {
            return StringCommand.subSuf(str, prefix.length());
        }
        return str;
    }

    public static String removeSuffix(String str, String suffix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(suffix)) {
            return str;
        }
        if (str.endsWith(suffix)) {
            return StringCommand.subPre(str, str.length() - suffix.length());
        }
        return str;
    }

    public static String removeSufAndLowerFirst(String str, String suffix) {
        return StringCommand.lowerFirst(StringCommand.removeSuffix(str, suffix));
    }

    public static String removeSuffixIgnoreCase(String str, String suffix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(suffix)) {
            return str;
        }
        if (str.toLowerCase().endsWith(suffix.toLowerCase())) {
            return StringCommand.subPre(str, str.length() - suffix.length());
        }
        return str;
    }

    public static String addPrefixIfNot(String str, String prefix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(prefix)) {
            return str;
        }
        if (!str.startsWith(prefix)) {
            str = prefix + str;
        }
        return str;
    }

    public static String addSuffixIfNot(String str, String suffix) {
        if (StringCommand.isEmpty(str) || StringCommand.isEmpty(suffix)) {
            return str;
        }
        if (!str.endsWith(suffix)) {
            str = str + suffix;
        }
        return str;
    }

    public static String cleanBlank(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String[] splitToArray(String str, char separator) {
        List<String> result = StringCommand.split(str, separator);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> split(String str, char separator) {
        return StringCommand.split(str, separator, 0);
    }

    public static String[] splitToArray(String str, char separator, int limit) {
        List<String> result = StringCommand.split(str, separator, limit);
        return result.toArray(new String[result.size()]);
    }

    public static List<String> split(String str, char separator, int limit) {
        if (str == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(limit == 0 ? 16 : limit);
        if (limit == 1) {
            list.add(str);
            return list;
        }
        boolean isNotEnd = true;
        int strLen = str.length();
        StringBuilder sb = new StringBuilder(strLen);
        for (int i = 0; i < strLen; ++i) {
            char c = str.charAt(i);
            if (isNotEnd && c == separator) {
                list.add(sb.toString());
                sb.delete(0, sb.length());
                if (limit == 0 || list.size() != limit - 1) continue;
                isNotEnd = false;
                continue;
            }
            sb.append(c);
        }
        list.add(sb.toString());
        return list;
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!StringCommand.hasLength(toSplit) || !StringCommand.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static String[] spliter(String str, String delimiter) {
        int i;
        if (str == null) {
            return null;
        }
        if (str.trim().length() == 0) {
            return new String[]{str};
        }
        int dellen = delimiter.length();
        int maxparts = str.length() / dellen + 2;
        int[] positions = new int[maxparts];
        int j = 0;
        int count = 0;
        positions[0] = -dellen;
        while ((i = str.indexOf(delimiter, j)) != -1) {
            positions[++count] = i;
            j = i + dellen;
        }
        positions[++count] = str.length();
        String[] result = new String[count];
        for (i = 0; i < count; ++i) {
            result[i] = str.substring(positions[i] + dellen, positions[i + 1]);
        }
        return result;
    }

    public static String[] split(String str, int len) {
        int partCount = str.length() / len;
        int lastPartCount = str.length() % len;
        int fixPart = 0;
        if (lastPartCount != 0) {
            fixPart = 1;
        }
        String[] strs = new String[partCount + fixPart];
        for (int i = 0; i < partCount + fixPart; ++i) {
            strs[i] = i == partCount + fixPart - 1 && lastPartCount != 0 ? str.substring(i * len, i * len + lastPartCount) : str.substring(i * len, i * len + len);
        }
        return strs;
    }

    public static String sub(String string, int fromIndex, int toIndex) {
        int len = string.length();
        if (fromIndex < 0) {
            if ((fromIndex = len + fromIndex) < 0) {
                fromIndex = 0;
            }
        } else if (fromIndex > len) {
            fromIndex = len;
        }
        if (toIndex < 0) {
            if ((toIndex = len + toIndex) < 0) {
                toIndex = len;
            }
        } else if (toIndex > len) {
            toIndex = len;
        }
        if (toIndex < fromIndex) {
            int tmp = fromIndex;
            fromIndex = toIndex;
            toIndex = tmp;
        }
        if (fromIndex == toIndex) {
            return EMPTY;
        }
        return string.substring(fromIndex, toIndex);
    }

    public static String subPre(String string, int toIndex) {
        return StringCommand.sub(string, 0, toIndex);
    }

    public static String subSuf(String string, int fromIndex) {
        if (StringCommand.isEmpty(string)) {
            return null;
        }
        return StringCommand.sub(string, fromIndex, string.length());
    }

    public static boolean isSurround(String str, String prefix, String suffix) {
        if (StringCommand.isBlank(str)) {
            return false;
        }
        if (str.length() < prefix.length() + suffix.length()) {
            return false;
        }
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isSurround(CharSequence str, char prefix, char suffix) {
        if (StringCommand.isBlank(str)) {
            return false;
        }
        if (str.length() < 2) {
            return false;
        }
        return str.charAt(0) == prefix && str.charAt(str.length() - 1) == suffix;
    }

    public static String repeat(char c, int count) {
        char[] result = new char[count];
        for (int i = 0; i < count; ++i) {
            result[i] = c;
        }
        return new String(result);
    }

    public static String repeat(String str, int count) {
        int n;
        int len = str.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        str.getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public static boolean equals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static String format(String template, Object ... params) {
        if (ArrayCommand.isEmpty(params) || StringCommand.isBlank(template)) {
            return template;
        }
        return StrFormatter.format(template, params);
    }

    public static String indexedFormat(String pattern, Object ... arguments) {
        return MessageFormat.format(pattern, arguments);
    }

    public static String format(String template, Map<?, ?> map) {
        if (null == map || map.isEmpty()) {
            return template;
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            template = template.replace(DELIM_START + entry.getKey() + DELIM_END, StringCommand.utf8Str(entry.getValue()));
        }
        return template;
    }

    public static byte[] utf8Bytes(String str) {
        return StringCommand.bytes(str, CharsetCommand.CHARSET_UTF_8);
    }

    public static byte[] bytes(String str) {
        return StringCommand.bytes(str, Charset.defaultCharset());
    }

    public static byte[] bytes(String str, String charset) {
        return StringCommand.bytes(str, StringCommand.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static byte[] bytes(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        if (null == charset) {
            return str.getBytes();
        }
        return str.getBytes(charset);
    }

    public static String utf8Str(Object obj) {
        return StringCommand.str(obj, CharsetCommand.CHARSET_UTF_8);
    }

    public static String str(Object obj, String charsetName) {
        return StringCommand.str(obj, Charset.forName(charsetName));
    }

    public static String str(Object obj, Charset charset) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof byte[]) {
            return StringCommand.str((byte[])obj, charset);
        }
        if (obj instanceof Byte[]) {
            return StringCommand.str((Byte[])obj, charset);
        }
        if (obj instanceof ByteBuffer) {
            return StringCommand.str((ByteBuffer)obj, charset);
        }
        if (ArrayCommand.isArray(obj)) {
            return ArrayCommand.toString(obj);
        }
        return obj.toString();
    }

    public static String str(byte[] bytes, String charset) {
        return StringCommand.str(bytes, StringCommand.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        if (null == charset) {
            return new String(data);
        }
        return new String(data, charset);
    }

    public static String str(Byte[] bytes, String charset) {
        return StringCommand.str(bytes, StringCommand.isBlank(charset) ? Charset.defaultCharset() : Charset.forName(charset));
    }

    public static String str(Byte[] data, Charset charset) {
        if (data == null) {
            return null;
        }
        byte[] bytes = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            Byte dataByte = data[i];
            bytes[i] = null == dataByte ? -1 : (int)dataByte.byteValue();
        }
        return StringCommand.str(bytes, charset);
    }

    public static String str(ByteBuffer data, String charset) {
        if (data == null) {
            return null;
        }
        return StringCommand.str(data, Charset.forName(charset));
    }

    public static String str(ByteBuffer data, Charset charset) {
        if (null == charset) {
            charset = Charset.defaultCharset();
        }
        return charset.decode(data).toString();
    }

    public static ByteBuffer byteBuffer(String str, String charset) {
        return ByteBuffer.wrap(StringCommand.bytes(str, charset));
    }

    public static String join(String conjunction, Object ... objs) {
        return ArrayCommand.join(objs, conjunction);
    }

    public static String toUnderlineCase(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        int length = camelCaseStr.length();
        StringBuilder sb = new StringBuilder();
        boolean isPreUpperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = camelCaseStr.charAt(i);
            boolean isNextUpperCase = true;
            if (i < length - 1) {
                isNextUpperCase = Character.isUpperCase(camelCaseStr.charAt(i + 1));
            }
            if (Character.isUpperCase(c)) {
                if (!(isPreUpperCase && isNextUpperCase || i <= 0)) {
                    sb.append(UNDERLINE);
                }
                isPreUpperCase = true;
            } else {
                isPreUpperCase = false;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String toCamelCase(String name) {
        if (name == null) {
            return null;
        }
        if (name.contains(UNDERLINE)) {
            name = name.toLowerCase();
            StringBuilder sb = new StringBuilder(name.length());
            boolean upperCase = false;
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (c == '_') {
                    upperCase = true;
                    continue;
                }
                if (upperCase) {
                    sb.append(Character.toUpperCase(c));
                    upperCase = false;
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return name;
    }

    public static String wrap(String str, String prefix, String suffix) {
        return StringCommand.format("{}{}{}", prefix, str, suffix);
    }

    public static boolean isWrap(String str, String prefix, String suffix) {
        return str.startsWith(prefix) && str.endsWith(suffix);
    }

    public static boolean isWrap(String str, String wrapper) {
        return StringCommand.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char wrapper) {
        return StringCommand.isWrap(str, wrapper, wrapper);
    }

    public static boolean isWrap(String str, char prefixChar, char suffixChar) {
        return str.charAt(0) == prefixChar && str.charAt(str.length() - 1) == suffixChar;
    }

    public static String padPre(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String padEnd(String str, int minLength, char padChar) {
        if (str.length() >= minLength) {
            return str;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(str);
        for (int i = str.length(); i < minLength; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static StringBuilder builder() {
        return new StringBuilder();
    }

    public static StringBuilder builder(int capacity) {
        return new StringBuilder(capacity);
    }

    public static StringBuilder builder(String ... strs) {
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            sb.append(str);
        }
        return sb;
    }

    public static StringReader getReader(String str) {
        return new StringReader(str);
    }

    public static StringWriter getWriter() {
        return new StringWriter();
    }

    public static int count(String content, String strForSearch) {
        if (StringCommand.hasEmpty(content, strForSearch) || strForSearch.length() > content.length()) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = content.indexOf(strForSearch, idx)) > -1) {
            ++count;
            idx += strForSearch.length();
        }
        return count;
    }

    public static int count(String content, char charForSearch) {
        int count = 0;
        if (StringCommand.isEmpty(content)) {
            return 0;
        }
        int contentLength = content.length();
        for (int i = 0; i < contentLength; ++i) {
            if (charForSearch != content.charAt(i)) continue;
            ++count;
        }
        return count;
    }

    public static String sanitize(String s) {
        return s.replace(':', '-').replace('_', '-').replace('.', '-').replace('/', '-').replace('\\', '-');
    }

    public static int countChar(String s, char ch) {
        if (ObjectCommand.isEmpty(s)) {
            return 0;
        }
        int matches = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (ch != c) continue;
            ++matches;
        }
        return matches;
    }

    @Deprecated
    public static String limitLenght(String s, int maxLength) {
        return StringCommand.limitLength(s, maxLength);
    }

    public static String limitLength(String s, int maxLength) {
        if (ObjectCommand.isEmpty(s)) {
            return s;
        }
        return s.length() <= maxLength ? s : s.substring(0, maxLength);
    }

    public static String removeQuotes(String s) {
        if (ObjectCommand.isEmpty(s)) {
            return s;
        }
        s = StringCommand.replaceAll(s, "'", EMPTY);
        s = StringCommand.replaceAll(s, "\"", EMPTY);
        return s;
    }

    public static String removeLeadingAndEndingQuotes(String s) {
        if (ObjectCommand.isEmpty(s)) {
            return s;
        }
        String copy = s.trim();
        if (copy.startsWith("'") && copy.endsWith("'")) {
            return copy.substring(1, copy.length() - 1);
        }
        if (copy.startsWith("\"") && copy.endsWith("\"")) {
            return copy.substring(1, copy.length() - 1);
        }
        return s;
    }

    public static boolean isQuoted(String s) {
        if (ObjectCommand.isEmpty(s)) {
            return false;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("\"") && s.endsWith("\"");
    }

    public static String xmlEncode(String text) {
        if (text == null) {
            return EMPTY;
        }
        text = StringCommand.replaceAll(text, "&", "&amp;");
        text = StringCommand.replaceAll(text, "\"", HTML_QUOTE);
        text = StringCommand.replaceAll(text, "<", HTML_LT);
        text = StringCommand.replaceAll(text, ">", HTML_GT);
        return text;
    }

    public static boolean hasUpperCase(String text) {
        if (text == null) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!Character.isUpperCase(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassName(String text) {
        String lastToken;
        String[] split;
        boolean result = false;
        if (text != null && (split = text.split("\\.")).length > 0 && (lastToken = split[split.length - 1]).length() > 0) {
            result = Character.isUpperCase(lastToken.charAt(0));
        }
        return result;
    }

    public static boolean hasStartToken(String expression, String language) {
        if (expression == null) {
            return false;
        }
        if ("simple".equalsIgnoreCase(language) && expression.contains("${")) {
            return true;
        }
        return language != null && expression.contains("$" + language + DELIM_START);
    }

    public static String replaceAll(String input, String from, String to) {
        if (ObjectCommand.isEmpty(input)) {
            return input;
        }
        if (from == null) {
            throw new IllegalArgumentException("from cannot be null");
        }
        if (to == null) {
            throw new IllegalArgumentException("to cannot be null");
        }
        if (!input.contains(from)) {
            return input;
        }
        int len = from.length();
        int max = input.length();
        StringBuilder sb = new StringBuilder(max);
        int i = 0;
        while (i < max) {
            String token;
            if (i + len <= max && from.equals(token = input.substring(i, i + len))) {
                sb.append(to);
                i += len;
                continue;
            }
            sb.append(input.charAt(i));
            ++i;
        }
        return sb.toString();
    }

    public static String toJson(String name, String value, boolean isMap) {
        if (isMap) {
            return "{ " + StringCommand.doubleQuote(name) + ": " + StringCommand.doubleQuote(value) + " }";
        }
        return StringCommand.doubleQuote(name) + ": " + StringCommand.doubleQuote(value);
    }

    public static String doubleQuote(String text) {
        return StringCommand.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return StringCommand.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String[] splitSafeQuote(String input, char separator) {
        return StringCommand.splitSafeQuote(input, separator, true);
    }

    public static String[] splitSafeQuote(String input, char separator, boolean trim) {
        if (input == null) {
            return null;
        }
        if (input.indexOf(separator) == -1) {
            return new String[]{trim ? input.trim() : input};
        }
        ArrayList<String> answer = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        boolean skipLeadingWhitespace = true;
        for (int i = 0; i < input.length(); ++i) {
            String text;
            boolean isQuoting;
            char ch = input.charAt(i);
            char prev = i > 0 ? input.charAt(i - 1) : (char)'\u0000';
            boolean bl = isQuoting = singleQuoted || doubleQuoted;
            if (!doubleQuoted && ch == '\'') {
                if (singleQuoted && prev == ch && sb.length() == 0) {
                    answer.add(EMPTY);
                }
                if (i == input.length() - 1 && singleQuoted && sb.length() > 0) {
                    text = sb.toString();
                    answer.add(text);
                    sb.setLength(0);
                }
                singleQuoted = !singleQuoted;
                continue;
            }
            if (!singleQuoted && ch == '\"') {
                if (doubleQuoted && prev == ch && sb.length() == 0) {
                    answer.add(EMPTY);
                }
                if (i == input.length() - 1 && doubleQuoted && sb.length() > 0) {
                    text = sb.toString();
                    answer.add(text);
                    sb.setLength(0);
                }
                doubleQuoted = !doubleQuoted;
                continue;
            }
            if (!isQuoting && ch == ' ') {
                if (skipLeadingWhitespace) {
                    continue;
                }
            } else if (!isQuoting && ch == separator) {
                if (sb.length() <= 0) continue;
                text = sb.toString();
                if (trim) {
                    text = text.trim();
                }
                answer.add(text);
                sb.setLength(0);
                continue;
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            String text = sb.toString();
            if (trim) {
                text = text.trim();
            }
            answer.add(text);
        }
        return answer.toArray(new String[answer.size()]);
    }

    public static String notEmpty(String value, String name) {
        if (ObjectCommand.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty");
        }
        return value;
    }

    public static String notEmpty(String value, String name, Object on) {
        if (on == null) {
            ObjectCommand.notNull(value, name);
        } else if (ObjectCommand.isEmpty(value)) {
            throw new IllegalArgumentException(name + " must be specified and not empty on: " + on);
        }
        return value;
    }

    public static String[] splitOnCharacter(String value, String needle, int count) {
        String[] rc = new String[count];
        rc[0] = value;
        for (int i = 1; i < count; ++i) {
            String v = rc[i - 1];
            int p = v.indexOf(needle);
            if (p < 0) {
                return rc;
            }
            rc[i - 1] = v.substring(0, p);
            rc[i] = v.substring(p + 1);
        }
        return rc;
    }

    public static String removeStartingCharacters(String text, char ch) {
        int idx = 0;
        while (text.charAt(idx) == ch) {
            ++idx;
        }
        if (idx > 0) {
            return text.substring(idx);
        }
        return text;
    }

    public static String capitalize(String text) {
        return StringCommand.capitalize(text, false);
    }

    public static String capitalize(String text, boolean dashToCamelCase) {
        if (dashToCamelCase) {
            text = StringCommand.dashToCamelCase(text);
        }
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        String answer = text.substring(0, 1).toUpperCase(Locale.ENGLISH);
        if (length > 1) {
            answer = answer + text.substring(1, length);
        }
        return answer;
    }

    public static String dashToCamelCase(String text) {
        if (text == null) {
            return null;
        }
        int length = text.length();
        if (length == 0) {
            return text;
        }
        if (text.indexOf(45) == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '-') {
                sb.append(Character.toUpperCase(text.charAt(++i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String after(String text, String after) {
        if (!text.contains(after)) {
            return null;
        }
        return text.substring(text.indexOf(after) + after.length());
    }

    public static <T> Optional<T> after(String text, String after, Function<String, T> mapper) {
        String result = StringCommand.after(text, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String before(String text, String before) {
        if (!text.contains(before)) {
            return null;
        }
        return text.substring(0, text.indexOf(before));
    }

    public static <T> Optional<T> before(String text, String before, Function<String, T> mapper) {
        String result = StringCommand.before(text, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String between(String text, String after, String before) {
        if ((text = StringCommand.after(text, after)) == null) {
            return null;
        }
        return StringCommand.before(text, before);
    }

    public static <T> Optional<T> between(String text, String after, String before, Function<String, T> mapper) {
        String result = StringCommand.between(text, after, before);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static String betweenOuterPair(String text, char before, char after) {
        if (text == null) {
            return null;
        }
        int pos = -1;
        int pos2 = -1;
        int count = 0;
        int count2 = 0;
        boolean singleQuoted = false;
        boolean doubleQuoted = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (!doubleQuoted && ch == '\'') {
                singleQuoted = !singleQuoted;
            } else if (!singleQuoted && ch == '\"') {
                boolean bl = doubleQuoted = !doubleQuoted;
            }
            if (singleQuoted || doubleQuoted) continue;
            if (ch == before) {
                ++count;
            } else if (ch == after) {
                ++count2;
            }
            if (ch == before && pos == -1) {
                pos = i;
                continue;
            }
            if (ch != after) continue;
            pos2 = i;
        }
        if (pos == -1 || pos2 == -1) {
            return null;
        }
        if (count != count2) {
            return null;
        }
        return text.substring(pos + 1, pos2);
    }

    public static <T> Optional<T> betweenOuterPair(String text, char before, char after, Function<String, T> mapper) {
        String result = StringCommand.betweenOuterPair(text, before, after);
        if (result == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(result));
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int size = name.length();
        if (size < 1) {
            return false;
        }
        if (Character.isJavaIdentifierStart(name.charAt(0))) {
            for (int i = 1; i < size; ++i) {
                if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String normalizeClassName(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        for (char ch : name.toCharArray()) {
            if (ch != '.' && ch != '[' && ch != ']' && ch != '-' && !Character.isJavaIdentifierPart(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static List<Integer> changedLines(String oldText, String newText) {
        if (oldText == null || oldText.equals(newText)) {
            return Collections.emptyList();
        }
        ArrayList<Integer> changed = new ArrayList<Integer>();
        String[] oldLines = oldText.split(LF);
        String[] newLines = newText.split(LF);
        for (int i = 0; i < newLines.length; ++i) {
            String oldLine;
            String newLine = newLines[i];
            String string = oldLine = i < oldLines.length ? oldLines[i] : null;
            if (oldLine == null) {
                changed.add(i);
                continue;
            }
            if (newLine.equals(oldLine)) continue;
            changed.add(i);
        }
        return changed;
    }

    public static String trimToNull(String given) {
        if (given == null) {
            return null;
        }
        String trimmed = given.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        return trimmed;
    }

    public static boolean containsIgnoreCase(String src, String what) {
        if (src == null || what == null) {
            return false;
        }
        int length = what.length();
        if (length == 0) {
            return true;
        }
        char firstLo = Character.toLowerCase(what.charAt(0));
        char firstUp = Character.toUpperCase(what.charAt(0));
        for (int i = src.length() - length; i >= 0; --i) {
            char ch = src.charAt(i);
            if (ch != firstLo && ch != firstUp || !src.regionMatches(true, i, what, 0, length)) continue;
            return true;
        }
        return false;
    }

    public static String humanReadableBytes(Locale locale, long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = "KMGTPE".charAt(exp - 1) + EMPTY;
        return String.format(locale, "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableBytes(long bytes) {
        return StringCommand.humanReadableBytes(Locale.getDefault(), bytes);
    }

    public static boolean matches(String patter, String target) {
        if (Objects.equals(patter, target)) {
            return true;
        }
        if (Objects.isNull(patter)) {
            return true;
        }
        if (Objects.equals("*", patter)) {
            return true;
        }
        if (AntPathMatcher.INSTANCE.match(patter, target)) {
            return true;
        }
        Pattern p = Pattern.compile(patter);
        Matcher m = p.matcher(target);
        return m.matches();
    }

    public static <T> T parse(Class<T> clazz, String value, T defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (clazz == String.class) {
            return clazz.cast(value);
        }
        try {
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return (T)Integer.valueOf(Integer.parseInt(value));
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return (T)Long.valueOf(Long.parseLong(value));
            }
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        throw new IllegalArgumentException(String.format("Invalid Class: %s", clazz));
    }

    public static int safeParseInt(String input, int defaultValue) {
        return StringCommand.parse(Integer.TYPE, input, defaultValue);
    }

    public static long safeParseLong(String input, long defaultValue) {
        return StringCommand.parse(Long.TYPE, input, defaultValue);
    }

    public static String substringByUTF8Length(String src, int start, int length) {
        return StringCommand.substringByUTF8Length(src, start, length, false);
    }

    public static String substringByUTF8Length(String src, int start, int byteLen, boolean replaceLastWithDots) {
        Validate.notNull((Object)src, (String)"src", (Object[])new Object[0]);
        Validate.isTrue((start >= 0 && start < src.length() ? 1 : 0) != 0, (String)"start should be >= 0 and < src.length()", (Object[])new Object[0]);
        Validate.isTrue((byteLen >= 0 ? 1 : 0) != 0, (String)"length should be >= 0", (Object[])new Object[0]);
        if (byteLen == 0) {
            return EMPTY;
        }
        int count = 0;
        for (int i = start; i < src.length(); ++i) {
            if ((count += StringCommand.getUTF8Bytes(src.charAt(i))) == byteLen) {
                return start == 0 && i == src.length() - 1 ? src : StringCommand.replaceLastWithDots(src, start, i + 1, replaceLastWithDots);
            }
            if (count <= byteLen) continue;
            return StringCommand.replaceLastWithDots(src, start, i, replaceLastWithDots);
        }
        return start == 0 ? src : StringCommand.replaceLastWithDots(src, start, src.length(), replaceLastWithDots);
    }

    public static int getUTF8Bytes(char c) {
        if ('\u0000' <= c && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        if (c <= '\ud7ff') {
            return 3;
        }
        if ('\udc00' <= c && c <= '\uffff') {
            return 3;
        }
        return 4;
    }

    private static String replaceLastWithDots(String input, int start, int end, boolean replaceLastWithDots) {
        if (!replaceLastWithDots) {
            return input.substring(start, end);
        }
        int newEnd = end;
        int count = 0;
        for (int i = end - 1; i >= start; --i) {
            --newEnd;
            if ((count += StringCommand.getUTF8Bytes(input.charAt(i))) >= 3) break;
        }
        return input.substring(start, newEnd) + "...";
    }

    public static long getDbStringHash(String str) {
        long hash = 5381L;
        int len = str.length();
        for (int idx = 0; idx < len; ++idx) {
            char c = str.charAt(idx);
            hash = (hash << 5) + hash + (long)c;
        }
        if (hash < 0L) {
            hash = -hash;
        }
        return hash;
    }

    public static String stripAndEscapeXml(String input) {
        String stripedString = StringCommand.stripNonValidXMLChars(input);
        return StringEscapeUtils.escapeXml((String)stripedString);
    }

    public static String stripNonValidXMLChars(String input) {
        int len = input.length();
        char[] chars = new char[len];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            char current = input.charAt(i);
            if (!(current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current == '\n' || current == '\r' || current == '\t') && (current < '\u10000' || current > '\u10ffff')) continue;
            chars[j] = current;
            ++j;
        }
        return new String(chars, 0, j);
    }

    public static String join(boolean appendStart, boolean appendEnd, String seperator, String ... array) {
        if (array == null) {
            return null;
        }
        StringBuilder joinedPath = new StringBuilder(appendStart ? seperator : EMPTY);
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                joinedPath.append(seperator);
            }
            joinedPath.append(StringUtils.removeStart((String)StringUtils.removeEnd((String)array[i], (String)seperator), (String)seperator));
        }
        if (appendEnd) {
            joinedPath.append(seperator);
        }
        return joinedPath.toString();
    }

    @Deprecated
    public static String randomString(int length) {
        return RandomStringUtils.random((int)length, (boolean)true, (boolean)true);
    }

    public static final Map<String, String> convertToMap(String val, char kvSeparator, char entrySeparator) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)val)) {
            String[] entries;
            for (String entry : entries = StringUtils.split((String)val, (char)entrySeparator)) {
                String[] kv;
                if (StringUtils.isBlank((CharSequence)entry) || (kv = StringUtils.split((String)entry, (String)String.valueOf(kvSeparator), (int)2)).length != 2) continue;
                result.put(kv[0].trim(), kv[1].trim());
            }
        }
        return result;
    }

    public static List<String> splitStringAndTrim(String data, Character seperator) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)data)) {
            return result;
        }
        if (seperator == null) {
            result.add(data);
            return result;
        }
        for (String cell : StringUtils.split((String)data.trim(), (char)seperator.charValue())) {
            result.add(cell.trim());
        }
        return result;
    }

    public static String[] array(String string) {
        String[] strings = null;
        if (string != null && string.startsWith(ConstEnumStringValue.LeftBracket.getValue()) && string.endsWith(ConstEnumStringValue.RightBracket.getValue())) {
            try {
                strings = JsonCommand.fromJson(string, String[].class);
            }
            catch (Exception e) {
                strings = new String[1];
                string = string.replace(ConstEnumStringValue.LeftBracket.getValue(), EMPTY);
                strings[0] = string = string.replace(ConstEnumStringValue.RightBracket.getValue(), EMPTY);
            }
        } else {
            strings = new String[]{string};
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String string(InputStream is) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sb.toString();
    }

    public static String join(List object, String joiner) {
        return Joiner.on((String)joiner).join((Iterable)object);
    }

    public static List<String> splict(String object, String splitter) {
        return Splitter.on((String)splitter).splitToList((CharSequence)object);
    }

    public static String join(List object) {
        return Joiner.on((String)"\t").join((Iterable)object);
    }

    public static List<String> splict(String object) {
        return Splitter.on((String)"\t").splitToList((CharSequence)object);
    }

    public static String joinByHT(List object) {
        return Joiner.on((char)'\t').join((Iterable)object);
    }

    public static List<String> splictByHT(String object) {
        return Splitter.on((char)'\t').splitToList((CharSequence)object);
    }

    public static String joinByVT(List object) {
        return Joiner.on((char)'\u000b').join((Iterable)object);
    }

    public static List<String> splictByVT(String object) {
        return Splitter.on((char)'\u000b').splitToList((CharSequence)object);
    }
}

