/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class TypeCommand {
    public Object tryConvertNumber(Object value, Class<?> returnType) {
        Validate.notNull((Object)value, (String)"value is null", (Object[])new Object[0]);
        if (!(value instanceof Number) || value.getClass().equals(returnType)) {
            return value;
        }
        Number number = (Number)value;
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            return number.intValue();
        }
        if (returnType == Long.TYPE || returnType == Long.class) {
            return number.longValue();
        }
        if (returnType == Short.TYPE || returnType == Short.class) {
            return number.shortValue();
        }
        if (returnType == Double.TYPE || returnType == Double.class) {
            return number.doubleValue();
        }
        if (returnType == Float.TYPE || returnType == Float.class) {
            return Float.valueOf(number.floatValue());
        }
        return value;
    }

    public Object getDefaultReturn(Class<?> returnType) {
        if (List.class.isAssignableFrom(returnType)) {
            return Collections.EMPTY_LIST;
        }
        if (Set.class.isAssignableFrom(returnType)) {
            return Collections.EMPTY_SET;
        }
        if (Map.class.isAssignableFrom(returnType)) {
            return Collections.EMPTY_MAP;
        }
        if (returnType == Integer.TYPE) {
            return 0;
        }
        if (returnType == Long.TYPE) {
            return 0L;
        }
        if (returnType == Short.TYPE) {
            return (short)0;
        }
        if (returnType == Double.TYPE) {
            return 0.0;
        }
        if (returnType == Float.class) {
            return Float.valueOf(0.0f);
        }
        return null;
    }
}

