/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.lang.replacer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

class StringTokenReplacer {
    private Pattern pattern;
    private Map<String, String> replacement;

    public StringTokenReplacer(Pattern pattern) {
        Validate.notNull((Object)pattern);
        this.pattern = pattern;
    }

    public StringTokenReplacer(Collection<String> tokens) {
        Validate.notNull(tokens, (String)"token", (Object[])new Object[0]);
        this.pattern = StringTokenReplacer.buildConverterPattern(tokens);
    }

    public StringTokenReplacer(Map<String, String> replacement) {
        Validate.notNull(replacement, (String)"replacement", (Object[])new Object[0]);
        this.pattern = StringTokenReplacer.buildConverterPattern(replacement.keySet());
        this.replacement = replacement;
    }

    private static Pattern buildConverterPattern(Collection<String> keys) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = keys.iterator();
        while (iter.hasNext()) {
            sb.append(Pattern.quote(iter.next()));
            if (!iter.hasNext()) break;
            sb.append("|");
        }
        return Pattern.compile(sb.toString(), 8);
    }

    public String replace(String input) {
        if (this.replacement == null) {
            throw new IllegalStateException("Replacement map was not initialized.");
        }
        return this.replace(input, this.replacement);
    }

    public String replace(String input, Map<String, String> replacement) {
        Validate.notNull((Object)input, (String)"input", (Object[])new Object[0]);
        Validate.notNull(replacement, (String)"replacement", (Object[])new Object[0]);
        StringBuilder sb = new StringBuilder(input.length());
        Matcher matcher = this.pattern.matcher(input);
        int index = 0;
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            sb.append(input.substring(index, start));
            String group = matcher.group();
            String text = replacement.get(group);
            sb.append(text == null ? group : text);
            index = end;
        }
        sb.append(input.substring(index));
        return sb.toString();
    }
}

