/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.linux;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import org.gjgr.pig.chivalrous.core.linux.LinuxShellCommand;
import org.gjgr.pig.chivalrous.core.linux.WgetCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LinuxCommand
implements Serializable {
    protected static final Logger logger = LoggerFactory.getLogger(LinuxCommand.class);
    protected String command;
    protected StringBuffer more = new StringBuffer();
    private String help;

    public static WgetCommand wget() {
        return new WgetCommand();
    }

    public static LinuxShellCommand base(String command) {
        return new LinuxShellCommand(command);
    }

    public String getHelp() {
        return this.help;
    }

    public void setHelp(String help) {
        this.help = help;
    }

    public LinuxCommand append(String param) {
        this.more.append(param);
        return this;
    }

    public boolean command() {
        this.command = this.toString();
        if (this.command == null) {
            logger.warn("could not init command");
            return false;
        }
        try {
            String s;
            Process p = Runtime.getRuntime().exec(this.command);
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((s = br.readLine()) != null) {
                System.out.println(s);
            }
            p.waitFor();
            logger.debug("run command:" + this.command + ". exitValue:" + p.exitValue() + "");
            p.destroy();
        }
        catch (Exception e) {
            logger.error("Exception: " + e.getMessage());
        }
        return true;
    }

    public String toString() {
        return null;
    }
}

