/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gjgr.pig.chivalrous.core.linux.ShellConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ShellCommand
extends Thread
implements Serializable {
    public static final String RWXR_XR_X = "rwxr-xr-x";
    public static final String PID = "pid";
    private static final Logger log = LoggerFactory.getLogger(ShellCommand.class);
    private static ThreadLocal<ShellConfig> shellConfigThreadLocal = new ThreadLocal();

    public ShellCommand(String script, String output, String workPath, String taskId, String shellContent) {
        ShellConfig shellConfig = new ShellConfig();
        shellConfig.setScript(script);
        shellConfig.setOutput(output);
        shellConfig.setWorkPath(workPath);
        shellConfig.setTaskId(taskId);
        shellConfig.setShellContent(shellContent);
    }

    public static List<String> runShortShell(String shell, long timeOutSeconds) {
        Process process = null;
        ArrayList<String> processList = new ArrayList<String>();
        try {
            process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", shell});
            long startRunTime = System.currentTimeMillis() / 1000L;
            boolean isStop = false;
            while (System.currentTimeMillis() / 1000L - startRunTime < timeOutSeconds && !isStop) {
                try {
                    isStop = true;
                }
                catch (IllegalThreadStateException e) {
                    isStop = false;
                }
                try {
                    Thread.sleep(shellConfigThreadLocal.get().getSleepInterval());
                }
                catch (InterruptedException e) {}
            }
            if (!isStop) {
                ShellCommand.hardKill(process, shell);
                process.destroyForcibly();
            } else {
                BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = "";
                while ((line = input.readLine()) != null) {
                    processList.add(line);
                }
                BufferedReader errorInput = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                while ((line = errorInput.readLine()) != null) {
                    processList.add(line);
                }
                log.info("the input shell is {}, result is {}, lines is {}", new Object[]{shell, String.join((CharSequence)"\n", processList), processList.size()});
                input.close();
                errorInput.close();
            }
        }
        catch (Exception e) {
            log.error("runShortShell error is {}", (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        return processList;
    }

    private static int getProcessId(Process process) {
        int processId = 0;
        try {
            Field f = process.getClass().getDeclaredField(PID);
            f.setAccessible(true);
            processId = f.getInt(process);
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        return processId;
    }

    private static void hardKill(Process process, String taskId) {
        int processId = ShellCommand.getProcessId(process);
        if (processId != 0 && process.isAlive()) {
            try {
                String cmd = String.format("kill -15 %d", -processId);
                log.info("hard kill task:{}, process id:{}, cmd:{}", new Object[]{taskId, processId, cmd});
                Runtime.getRuntime().exec(cmd);
            }
            catch (IOException e) {
                log.error("kill attempt failed ", (Throwable)e);
            }
        }
    }

    public abstract void logParser(String var1);

    public boolean isFinish() {
        return shellConfigThreadLocal.get().isFinish();
    }

    public void setFinish(boolean finish) {
        shellConfigThreadLocal.get().setFinish(finish);
    }

    private String buildShellCommand() {
        Path path = new File(shellConfigThreadLocal.get().getScript()).toPath();
        if (Files.exists(path, new LinkOption[0])) {
            log.info("taskId: {} script have exits, path is: {} ", (Object)shellConfigThreadLocal.get().getTaskId(), (Object)shellConfigThreadLocal.get().getScript());
            return shellConfigThreadLocal.get().getScript();
        }
        Set<PosixFilePermission> perms = PosixFilePermissions.fromString(RWXR_XR_X);
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(perms);
        try {
            Path parent = path.getParent();
            Files.createDirectories(parent, new FileAttribute[0]);
            Files.createFile(path, attr);
            Files.write(path, shellConfigThreadLocal.get().getShellContent().getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            log.error("taskId : {} script file write file, error: {}", (Object)shellConfigThreadLocal.get().getTaskId(), (Object)ExceptionUtils.getFullStackTrace((Throwable)e));
            shellConfigThreadLocal.get().setExitCode(-1);
            shellConfigThreadLocal.get().setFinish(true);
            return "";
        }
        return shellConfigThreadLocal.get().getScript();
    }

    public void forceKillShell() {
        shellConfigThreadLocal.get().setForceKill(true);
    }

    @Override
    public void run() {
        if (this.checkWorkPath()) {
            shellConfigThreadLocal.get().setFinish(true);
            shellConfigThreadLocal.get().setExitCode(-1);
            return;
        }
        String runningShellFile = this.buildShellCommand();
        if ("".equals(runningShellFile)) {
            return;
        }
        shellConfigThreadLocal.get().setStartRunTimeSeconds(System.currentTimeMillis() / 1000L);
        ProcessBuilder pb = new ProcessBuilder(runningShellFile).redirectErrorStream(true).directory(new File(shellConfigThreadLocal.get().getWorkPath()));
        try {
            Process process = pb.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            boolean runningStatus = false;
            while (!runningStatus) {
                String singleLine;
                try {
                    Thread.sleep(this.getSleepInterval());
                }
                catch (InterruptedException e) {
                    log.error("taskId: {} , errorMessage: {}", new Object[]{shellConfigThreadLocal.get().getTaskId(), e.getMessage(), e});
                }
                log.info("check shell running state for taskId: {} ", (Object)shellConfigThreadLocal.get().getTaskId());
                while ((singleLine = bufferedReader.readLine()) != null && !shellConfigThreadLocal.get().isForceKill()) {
                    this.logParser(singleLine);
                }
                if (shellConfigThreadLocal.get().isForceKill()) {
                    ShellCommand.hardKill(process, ShellCommand.shellConfigThreadLocal.get().taskId);
                    break;
                }
                if (System.currentTimeMillis() / 1000L - shellConfigThreadLocal.get().getStartRunTimeSeconds() > shellConfigThreadLocal.get().getTimeOutSeconds()) {
                    ShellCommand.hardKill(process, ShellCommand.shellConfigThreadLocal.get().taskId);
                    break;
                }
                try {
                    shellConfigThreadLocal.get().setExitCode(process.exitValue());
                    runningStatus = true;
                }
                catch (IllegalThreadStateException e) {
                    runningStatus = false;
                }
            }
            bufferedReader.close();
        }
        catch (IOException e) {
            log.error("taskId: {} , errorMessage: {} ", new Object[]{shellConfigThreadLocal.get().getTaskId(), e.getMessage(), e});
            shellConfigThreadLocal.get().setExitCode(-1);
            String checkFuserCommand = String.format("ps aux|grep `fuser %s |awk -F ':' '{print $1}' `", runningShellFile);
            List<String> fuserLogs = ShellCommand.runShortShell(checkFuserCommand, 60L);
            log.info("who use the script file, taskId: {} , fileName: {}, fuserLog: {}", new Object[]{shellConfigThreadLocal.get().getTaskId(), runningShellFile, String.join((CharSequence)"\n", fuserLogs)});
        }
        shellConfigThreadLocal.get().setFinish(true);
        shellConfigThreadLocal.get().setEndTimeSeconds(System.currentTimeMillis() / 1000L);
    }

    private boolean checkWorkPath() {
        if (StringUtils.isNotBlank((CharSequence)shellConfigThreadLocal.get().getWorkPath())) {
            try {
                FileUtils.forceMkdir((File)new File(shellConfigThreadLocal.get().getWorkPath()));
            }
            catch (IOException e) {
                log.error("[SHELL] create shell work path error.", (Throwable)e);
            }
        }
        return false;
    }

    public int exitCode() {
        return shellConfigThreadLocal.get().getExitCode();
    }

    public int getSleepInterval() {
        return shellConfigThreadLocal.get().getSleepInterval();
    }

    public final boolean isFinishWithPlatformError() {
        int platformErrorTimeThreshold = 120;
        return shellConfigThreadLocal.get().isFinish() && shellConfigThreadLocal.get().getExitCode() != 0 && shellConfigThreadLocal.get().getEndTimeSeconds() - shellConfigThreadLocal.get().getStartRunTimeSeconds() < (long)platformErrorTimeThreshold;
    }
}

