/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log;

import java.io.Serializable;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.level.Level;

public abstract class AbstractLog
implements Log,
Serializable {
    private static final long serialVersionUID = -3211115409504005616L;

    @Override
    public boolean isEnabled(Level level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error(StringCommand.format("Can not identify level: {}", new Object[]{level}));
    }

    @Override
    public void trace(Throwable t) {
        this.trace(t, t.getMessage(), new Object[0]);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(t, t.getMessage(), new Object[0]);
    }

    @Override
    public void info(Throwable t) {
        this.info(t, t.getMessage(), new Object[0]);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(t, t.getMessage(), new Object[0]);
    }

    @Override
    public void error(Throwable t) {
        this.error(t, t.getMessage(), new Object[0]);
    }
}

