/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log;

import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.dialect.commons.SimpleLogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.console.ConsoleLogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.jdk.JdkLogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.log4j.Log4jLogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.log4j2.Log4j2LogFactory;
import org.gjgr.pig.chivalrous.core.log.dialect.slf4j.Slf4jLogFactory;

public abstract class LogFactory {
    private static final Object lock = new Object();
    private static volatile LogFactory currentLogFactory;
    private String logFramworkName;

    public LogFactory(String logFramworkName) {
        this.logFramworkName = logFramworkName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogFactory getCurrentLogFactory() {
        if (null == currentLogFactory) {
            Object object = lock;
            synchronized (object) {
                if (null == currentLogFactory) {
                    currentLogFactory = LogFactory.detectLogFactory();
                }
            }
        }
        return currentLogFactory;
    }

    public static LogFactory setCurrentLogFactory(Class<? extends LogFactory> logFactoryClass) {
        try {
            return LogFactory.setCurrentLogFactory(logFactoryClass.newInstance());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can not instance LogFactory class!", e);
        }
    }

    public static LogFactory setCurrentLogFactory(LogFactory logFactory) {
        logFactory.getLog(LogFactory.class).debug("Custom Use [{}] Logger.", logFactory.logFramworkName);
        currentLogFactory = logFactory;
        return currentLogFactory;
    }

    public static Log get(String name) {
        return LogFactory.getCurrentLogFactory().getLog(name);
    }

    public static Log get(Class<?> clazz) {
        return LogFactory.getCurrentLogFactory().getLog(clazz);
    }

    public static Log get() {
        return LogFactory.get(new Exception().getStackTrace()[1].getClassName());
    }

    protected static Log indirectGet() {
        return LogFactory.get(new Exception().getStackTrace()[2].getClassName());
    }

    private static LogFactory detectLogFactory() {
        LogFactory logFactory;
        try {
            logFactory = new Slf4jLogFactory(true);
            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
        }
        catch (Throwable e) {
            try {
                logFactory = new Log4jLogFactory();
                logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
            }
            catch (Throwable e2) {
                try {
                    logFactory = new Log4j2LogFactory();
                    logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                }
                catch (Throwable e3) {
                    try {
                        logFactory = new SimpleLogFactory();
                        logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                    }
                    catch (Throwable e4) {
                        try {
                            logFactory = new JdkLogFactory();
                            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                        }
                        catch (Throwable e6) {
                            logFactory = new ConsoleLogFactory();
                            logFactory.getLog(LogFactory.class).debug("Use [{}] Logger As Default.", logFactory.logFramworkName);
                        }
                    }
                }
            }
        }
        return logFactory;
    }

    public abstract Log getLog(String var1);

    public abstract Log getLog(Class<?> var1);

    protected void checkLogExist(Object logClassName) {
    }
}

