/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.log.dialect.commons;

import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.AbstractLocationAwareLog;
import org.gjgr.pig.chivalrous.core.log.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLog4jLog
extends AbstractLocationAwareLog {
    private static final long serialVersionUID = -6843151523380063975L;
    private static final String FQCN = SimpleLog4jLog.class.getName();
    private final transient Logger logger;
    private final String name;

    public SimpleLog4jLog(Logger logger, String name) {
        this.logger = logger;
        this.name = name;
    }

    public SimpleLog4jLog(Class<?> clazz) {
        this(LoggerFactory.getLogger(clazz), clazz.getName());
    }

    public SimpleLog4jLog(String name) {
        this(LoggerFactory.getLogger((String)name), name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void log(Level level, String format, Object ... arguments) {
        this.log(level, null, format, arguments);
    }

    @Override
    public void log(Level level, Throwable t, String format, Object ... arguments) {
        this.log(FQCN, level, t, format, arguments);
    }

    @Override
    public void log(String fqcn, Level level, Throwable t, String format, Object ... arguments) {
        switch (level) {
            case TRACE: {
                Level log4jLevel = Level.TRACE;
                this.logger.trace(FQCN, new Object[]{log4jLevel, StringCommand.format(format, arguments), t});
                break;
            }
            case DEBUG: {
                Level log4jLevel = Level.DEBUG;
                this.logger.debug(FQCN, new Object[]{log4jLevel, StringCommand.format(format, arguments), t});
                break;
            }
            case INFO: {
                Level log4jLevel = Level.INFO;
                this.logger.info(FQCN, new Object[]{log4jLevel, StringCommand.format(format, arguments), t});
                break;
            }
            case WARN: {
                Level log4jLevel = Level.WARN;
                this.logger.warn(FQCN, new Object[]{log4jLevel, StringCommand.format(format, arguments), t});
                break;
            }
            case ERROR: {
                Level log4jLevel = Level.ERROR;
                this.logger.error(FQCN, new Object[]{log4jLevel, StringCommand.format(format, arguments), t});
                break;
            }
            default: {
                throw new Error(StringCommand.format("Can not identify level: {}", new Object[]{level}));
            }
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void debug(String format, Object ... arguments) {
        this.debug(null, format, arguments);
    }

    @Override
    public void debug(Throwable t, String format, Object ... arguments) {
        this.logger.debug(FQCN, new Object[]{Level.DEBUG, StringCommand.format(format, arguments), t});
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public void error(String format, Object ... arguments) {
        this.error(null, format, arguments);
    }

    @Override
    public void error(Throwable t, String format, Object ... arguments) {
        this.logger.error(FQCN, new Object[]{Level.ERROR, StringCommand.format(format, arguments), t});
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void info(String format, Object ... arguments) {
        this.info(null, format, arguments);
    }

    @Override
    public void info(Throwable t, String format, Object ... arguments) {
        this.logger.info(FQCN, new Object[]{Level.INFO, StringCommand.format(format, arguments), t});
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    @Override
    public void trace(String format, Object ... arguments) {
        this.trace(null, format, arguments);
    }

    @Override
    public void trace(Throwable t, String format, Object ... arguments) {
        this.logger.trace(FQCN, new Object[]{Level.TRACE, StringCommand.format(format, arguments), t});
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String format, Object ... arguments) {
        this.warn(null, format, arguments);
    }

    @Override
    public void warn(Throwable t, String format, Object ... arguments) {
        this.logger.warn(FQCN, new Object[]{Level.WARN, StringCommand.format(format, arguments), t});
    }
}

