/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.mutable;

import org.gjgr.pig.chivalrous.core.math.NumberCommand;
import org.gjgr.pig.chivalrous.core.mutable.Mutable;

public class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable<Number> {
    private static final long serialVersionUID = -7381592836008495052L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this(value.doubleValue());
    }

    public MutableDouble(String value) throws NumberFormatException {
        this.value = Double.parseDouble(value);
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public void set(Number value) {
        this.value = value.doubleValue();
    }

    @Override
    public void set(double value) {
        this.value = value;
    }

    public MutableDouble increment() {
        this.value += 1.0;
        return this;
    }

    public MutableDouble decrement() {
        this.value -= 1.0;
        return this;
    }

    public MutableDouble add(double operand) {
        this.value += operand;
        return this;
    }

    public MutableDouble add(Number operand) {
        this.value += operand.doubleValue();
        return this;
    }

    public MutableDouble subtract(double operand) {
        this.value -= operand;
        return this;
    }

    public MutableDouble subtract(Number operand) {
        this.value -= operand.doubleValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.value);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableDouble) {
            return this.value == ((MutableDouble)obj).doubleValue();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(MutableDouble other) {
        return NumberCommand.compare(this.value, other.value);
    }
}

