/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.mutable;

import org.gjgr.pig.chivalrous.core.math.NumberCommand;
import org.gjgr.pig.chivalrous.core.mutable.Mutable;

public class MutableLong
extends Number
implements Comparable<MutableLong>,
Mutable<Number> {
    private static final long serialVersionUID = -7982037656814990915L;
    private long value;

    public MutableLong() {
    }

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong(Number value) {
        this(value.longValue());
    }

    public MutableLong(String value) throws NumberFormatException {
        this.value = Long.parseLong(value);
    }

    @Override
    public Long get() {
        return this.value;
    }

    @Override
    public void set(Number value) {
        this.value = value.longValue();
    }

    @Override
    public void set(long value) {
        this.value = value;
    }

    public MutableLong increment() {
        ++this.value;
        return this;
    }

    public MutableLong decrement() {
        --this.value;
        return this;
    }

    public MutableLong add(long operand) {
        this.value += operand;
        return this;
    }

    public MutableLong add(Number operand) {
        this.value += operand.longValue();
        return this;
    }

    public MutableLong subtract(long operand) {
        this.value -= operand;
        return this;
    }

    public MutableLong subtract(Number operand) {
        this.value -= operand.longValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableLong) {
            return this.value == ((MutableLong)obj).longValue();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(MutableLong other) {
        return NumberCommand.compare(this.value, other.value);
    }
}

