/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.mutable;

import org.gjgr.pig.chivalrous.core.math.NumberCommand;
import org.gjgr.pig.chivalrous.core.mutable.Mutable;

public class MutableShort
extends Number
implements Comparable<MutableShort>,
Mutable<Number> {
    private static final long serialVersionUID = -7982037656814990915L;
    private short value;

    public MutableShort() {
    }

    public MutableShort(short value) {
        this.value = value;
    }

    public MutableShort(Number value) {
        this(value.shortValue());
    }

    public MutableShort(String value) throws NumberFormatException {
        this.value = Short.parseShort(value);
    }

    @Override
    public Short get() {
        return this.value;
    }

    @Override
    public void set(Number value) {
        this.value = value.shortValue();
    }

    @Override
    public void set(short value) {
        this.value = value;
    }

    public MutableShort increment() {
        this.value = (short)(this.value + 1);
        return this;
    }

    public MutableShort decrement() {
        this.value = (short)(this.value - 1);
        return this;
    }

    public MutableShort add(short operand) {
        this.value = (short)(this.value + operand);
        return this;
    }

    public MutableShort add(Number operand) {
        this.value = (short)(this.value + operand.shortValue());
        return this;
    }

    public MutableShort subtract(short operand) {
        this.value = (short)(this.value - operand);
        return this;
    }

    public MutableShort subtract(Number operand) {
        this.value = (short)(this.value - operand.shortValue());
        return this;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableShort) {
            return this.value == ((MutableShort)obj).shortValue();
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int compareTo(MutableShort other) {
        return NumberCommand.compare(this.value, other.value);
    }
}

