/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.net;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.lang.Validator;
import org.gjgr.pig.chivalrous.core.system.HostInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetworkCommand {
    public static final String LOCAL_IP = "127.0.0.1";
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkCommand.class);
    private static final String DockerIP = "172.17.42.1";

    private NetworkCommand() {
    }

    public static String getLocalHostIp() {
        try {
            for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
                for (InetAddress addr : Collections.list(iface.getInetAddresses())) {
                    LOGGER.debug("Checking ip address {}", (Object)addr);
                    String hostAddress = addr.getHostAddress();
                    if (!addr.isSiteLocalAddress() || addr.isLoopbackAddress() || addr instanceof Inet6Address || hostAddress.equals(DockerIP)) continue;
                    LOGGER.debug("Ok, the ip {} will be used.", (Object)addr);
                    return hostAddress;
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("Couldn't find the local machine ip.", (Throwable)e);
        }
        throw new IllegalStateException("Couldn't find the local machine ip.");
    }

    public static HostInfo localHostInfo() {
        return new HostInfo();
    }

    public static String localHostInfomation() {
        return new HostInfo().toString();
    }

    public static String longToIpv4(long longIP) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(longIP >>> 24));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFFFL) >>> 16));
        sb.append(".");
        sb.append(String.valueOf((longIP & 0xFFFFL) >>> 8));
        sb.append(".");
        sb.append(String.valueOf(longIP & 0xFFL));
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        if (Validator.isIpv4(strIP)) {
            long[] ip = new long[4];
            int position1 = strIP.indexOf(".");
            int position2 = strIP.indexOf(".", position1 + 1);
            int position3 = strIP.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIP.substring(0, position1));
            ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIP.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return 0L;
    }

    public static boolean isUsableLocalPort(int port) {
        if (!NetworkCommand.isValidPort(port)) {
            return false;
        }
        try {
            new Socket(LOCAL_IP, port).close();
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static boolean isInnerIP(String ipAddress) {
        boolean isInnerIp = false;
        long ipNum = NetworkCommand.ipv4ToLong(ipAddress);
        long aBegin = NetworkCommand.ipv4ToLong("10.0.0.0");
        long aEnd = NetworkCommand.ipv4ToLong("10.255.255.255");
        long bBegin = NetworkCommand.ipv4ToLong("172.16.0.0");
        long bEnd = NetworkCommand.ipv4ToLong("172.31.255.255");
        long cBegin = NetworkCommand.ipv4ToLong("192.168.0.0");
        long cEnd = NetworkCommand.ipv4ToLong("192.168.255.255");
        isInnerIp = NetworkCommand.isInner(ipNum, aBegin, aEnd) || NetworkCommand.isInner(ipNum, bBegin, bEnd) || NetworkCommand.isInner(ipNum, cBegin, cEnd) || ipAddress.equals(LOCAL_IP);
        return isInnerIp;
    }

    public static LinkedHashSet<String> localIpv4s() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new UtilException(e.getMessage(), e);
        }
        if (networkInterfaces == null) {
            throw new UtilException("Get network interface error!");
        }
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || !(inetAddress instanceof Inet4Address)) continue;
                ipSet.add(inetAddress.getHostAddress());
            }
        }
        return ipSet;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new UtilException(StringCommand.format("To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath), e);
        }
    }

    public static String hideIpPart(String ip) {
        return new StringBuffer(ip.length()).append(ip.substring(0, ip.lastIndexOf(".") + 1)).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetworkCommand.hideIpPart(NetworkCommand.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        if (StringCommand.isBlank(host)) {
            host = LOCAL_IP;
        }
        String destHost = null;
        int port = 0;
        int index = host.indexOf(":");
        if (index != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollectionCommand.addAll(new ArrayList(), networkInterfaces);
    }

    public static InetAddress getLocalhost() {
        InetAddress candidateAddress = null;
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                Enumeration<InetAddress> inetAddrs = iface.getInetAddresses();
                while (inetAddrs.hasMoreElements()) {
                    InetAddress inetAddr = inetAddrs.nextElement();
                    if (inetAddr.isLoopbackAddress()) continue;
                    if (inetAddr.isSiteLocalAddress()) {
                        return inetAddr;
                    }
                    if (null != candidateAddress) continue;
                    candidateAddress = inetAddr;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (null == candidateAddress) {
            try {
                candidateAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return candidateAddress;
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

