/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.net;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.Consts;
import org.apache.http.NameValuePair;
import org.apache.http.conn.util.InetAddressUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.TextUtils;
import org.gjgr.pig.chivalrous.core.crypto.CryptoCommand;
import org.gjgr.pig.chivalrous.core.net.URLEncodedUtils;
import org.gjgr.pig.chivalrous.core.net.UriCommand;
import org.gjgr.pig.chivalrous.core.net.UriScheme;

public class UriBuilder
implements Serializable {
    protected static final long serialVersionUID = 1024L;
    private String scheme;
    private String encodedSchemeSpecificPart;
    private String encodedAuthority;
    private String userInfo;
    private String encodedUserInfo;
    private String host;
    private int port;
    private String path;
    private String encodedPath;
    private String encodedQuery;
    private List<NameValuePair> queryParams;
    private String query;
    private Charset charset;
    private String fragment;
    private String encodedFragment;

    public UriBuilder() {
        this.port = -1;
    }

    public UriBuilder(String string) throws URISyntaxException {
        try {
            this.digestURI(new URI(string));
        }
        catch (Exception e) {
            try {
                String url = UriCommand.fixIllegalCharacterInUrl(string);
                this.digestURI(new URI(url));
            }
            catch (Exception e1) {
                try {
                    this.digestURI(new URI(URLEncoder.encode(string, Consts.UTF_8.name())));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public UriBuilder(URI uri) {
        this.digestURI(uri);
    }

    private static String normalizePath(String path, boolean relative) {
        int n;
        String s = path;
        if (TextUtils.isBlank((CharSequence)s)) {
            return "";
        }
        for (n = 0; n < s.length() && s.charAt(n) == '/'; ++n) {
        }
        if (n > 1) {
            s = s.substring(n - 1);
        }
        if (!relative && !s.startsWith("/")) {
            s = "/" + s;
        }
        return s;
    }

    public UriBuilder paramOrdered() {
        List<NameValuePair> params = this.getQueryParams();
        if (params != null) {
            params.sort(new Comparator<NameValuePair>(){

                @Override
                public int compare(NameValuePair o1, NameValuePair o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
        }
        this.setParameters(params);
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public UriBuilder setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }

    private List<NameValuePair> parseQuery(String query, Charset charset) {
        if (query != null && !query.isEmpty()) {
            return URLEncodedUtils.parse(query, charset);
        }
        return null;
    }

    private List<NameValuePair> parseQuery(String query) {
        if (query != null && !query.isEmpty()) {
            return URLEncodedUtils.parse(query, this.charset);
        }
        return null;
    }

    public String addQuery(String key, String value) {
        String str;
        BasicNameValuePair nameValuePair = new BasicNameValuePair(key, value);
        if (this.query != null) {
            str = URLEncodedUtils.format((NameValuePair)nameValuePair, false, false);
            this.query = this.query + "&" + str;
        } else if (this.encodedQuery != null) {
            str = URLEncodedUtils.format((NameValuePair)nameValuePair, true, true);
        } else {
            str = URLEncodedUtils.format((NameValuePair)nameValuePair, false, false);
            this.query = "?" + str;
        }
        return str;
    }

    public URI build() throws URISyntaxException {
        return new URI(this.buildString(false));
    }

    public URL buildURL() {
        try {
            return this.build().toURL();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String param() {
        return this.param(false, false);
    }

    public String param(boolean blankAsPlus, boolean hexAsPlus) {
        StringBuilder sb = new StringBuilder();
        if (this.encodedQuery != null) {
            sb.append("?").append(this.encodedQuery);
        } else if (this.queryParams != null && !this.queryParams.isEmpty()) {
            sb.append("?").append(this.encodeUrlForm(this.queryParams, blankAsPlus, hexAsPlus));
        } else if (this.query != null) {
            sb.append("?").append(this.encodeUric(this.query));
        }
        return sb.toString();
    }

    public String url() {
        return this.buildString(false, false);
    }

    public String uri() {
        return this.toString();
    }

    public String buildString() {
        return this.buildString(false);
    }

    public String buildString(boolean blankAsPlus, boolean hexAsPlus) {
        StringBuilder sb = new StringBuilder();
        if (this.scheme != null) {
            sb.append(this.scheme).append(':');
        }
        if (this.encodedSchemeSpecificPart != null) {
            sb.append(this.encodedSchemeSpecificPart);
        } else {
            if (this.encodedAuthority != null) {
                sb.append("//").append(this.encodedAuthority);
            } else if (this.host != null) {
                sb.append("//");
                if (this.encodedUserInfo != null) {
                    sb.append(this.encodedUserInfo).append("@");
                } else if (this.userInfo != null) {
                    sb.append(this.encodeUserInfo(this.userInfo)).append("@");
                }
                if (InetAddressUtils.isIPv6Address((String)this.host)) {
                    sb.append("[").append(this.host).append("]");
                } else {
                    sb.append(this.host);
                }
                if (this.port >= 0) {
                    sb.append(":").append(this.port);
                }
            }
            if (this.encodedPath != null) {
                sb.append(UriBuilder.normalizePath(this.encodedPath, sb.length() == 0));
            } else if (this.path != null) {
                sb.append(this.encodePath(UriBuilder.normalizePath(this.path, sb.length() == 0)));
            }
            sb.append(this.param(blankAsPlus, hexAsPlus));
        }
        if (this.encodedFragment != null) {
            sb.append("#").append(this.encodedFragment);
        } else if (this.fragment != null) {
            sb.append("#").append(this.encodeUric(this.fragment));
        }
        return sb.toString();
    }

    private String buildString(boolean blankAsPlus) {
        return this.buildString(blankAsPlus, false);
    }

    private void digestURI(URI uri) {
        this.scheme = uri.getScheme();
        this.encodedSchemeSpecificPart = uri.getRawSchemeSpecificPart();
        this.encodedAuthority = uri.getRawAuthority();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.encodedUserInfo = uri.getRawUserInfo();
        this.userInfo = uri.getUserInfo();
        this.encodedPath = uri.getRawPath();
        this.path = uri.getPath();
        this.encodedQuery = uri.getRawQuery();
        this.queryParams = this.parseQuery(uri.getRawQuery(), this.charset != null ? this.charset : Consts.UTF_8);
        this.encodedFragment = uri.getRawFragment();
        this.fragment = uri.getFragment();
    }

    private String encodeUserInfo(String userInfo) {
        return URLEncodedUtils.encUserInfo(userInfo, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodePath(String path) {
        return URLEncodedUtils.encPath(path, this.charset != null ? this.charset : Consts.UTF_8);
    }

    private String encodeUrlForm(List<NameValuePair> params, boolean blankAsPlus, boolean hexAsPlus) {
        return URLEncodedUtils.format(params, this.charset != null ? this.charset : Consts.UTF_8, blankAsPlus, hexAsPlus);
    }

    private String encodeUrlForm(List<NameValuePair> params, boolean blankAsPlus) {
        return this.encodeUrlForm(params, blankAsPlus, true);
    }

    private String encodeUric(String fragment) {
        return URLEncodedUtils.encUric(fragment, this.charset != null ? this.charset : Consts.UTF_8);
    }

    public UriBuilder setUserInfo(String username, String password) {
        return this.setUserInfo(username + ':' + password);
    }

    public UriBuilder removeQuery() {
        this.queryParams = null;
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    @Deprecated
    public UriBuilder setQuery(String query) {
        this.queryParams = this.parseQuery(query, this.charset != null ? this.charset : Consts.UTF_8);
        this.query = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public String getFileName() {
        String name = FilenameUtils.getName((String)this.getPath());
        return name;
    }

    public String fileName() {
        String name = this.getFileName();
        if (name == null) {
            name = CryptoCommand.md5(this.getPath());
        }
        return name;
    }

    public UriBuilder setParameters(List<NameValuePair> nvps) {
        this.queryParams = new ArrayList<NameValuePair>();
        this.queryParams.addAll(nvps);
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public UriBuilder addParameters(List<NameValuePair> nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (this.encodedQuery != null) {
            nvps.addAll(this.parseQuery(this.encodedQuery));
            this.encodedQuery = null;
        } else if (this.query != null) {
            nvps.addAll(this.parseQuery(this.query));
            this.query = null;
        }
        this.queryParams.addAll(nvps);
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public boolean removeParameter(String key) {
        boolean status = false;
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (this.encodedQuery != null) {
            this.queryParams.addAll(this.parseQuery(this.encodedQuery));
            this.encodedQuery = null;
        } else if (this.query != null) {
            this.queryParams.addAll(this.parseQuery(this.query));
            this.query = null;
        }
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (NameValuePair nameValuePair : this.queryParams) {
            if (!nameValuePair.getName().equalsIgnoreCase(key)) continue;
            nameValuePairs.add(nameValuePair);
            status = true;
        }
        for (NameValuePair nameValuePair : nameValuePairs) {
            this.queryParams.remove(nameValuePair);
        }
        return status;
    }

    public UriBuilder setParameters(NameValuePair ... nvps) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        } else {
            this.queryParams.clear();
        }
        for (NameValuePair nvp : nvps) {
            this.queryParams.add(nvp);
        }
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public UriBuilder addParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (this.encodedQuery != null) {
            this.queryParams.addAll(this.parseQuery(this.encodedQuery));
            this.encodedQuery = null;
        } else if (this.query != null) {
            this.queryParams.addAll(this.parseQuery(this.query));
            this.query = null;
        }
        this.queryParams.add((NameValuePair)new BasicNameValuePair(param, value));
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public UriBuilder addParam(String param, String value) {
        HashMap<String, NameValuePair> cache = new HashMap<String, NameValuePair>();
        this.addParameter(param, value);
        if (this.queryParams.size() != 0) {
            this.queryParams.forEach(nameValuePair -> cache.put(nameValuePair.getName(), (NameValuePair)nameValuePair));
        }
        if (this.queryParams.size() != cache.size()) {
            this.queryParams.clear();
            cache.forEach((k, v) -> this.queryParams.add((NameValuePair)v));
        }
        cache.clear();
        return this;
    }

    public UriBuilder setParameter(String param, String value) {
        if (this.queryParams == null) {
            this.queryParams = new ArrayList<NameValuePair>();
        }
        if (!this.queryParams.isEmpty()) {
            Iterator<NameValuePair> it = this.queryParams.iterator();
            while (it.hasNext()) {
                NameValuePair nvp = it.next();
                if (!nvp.getName().equals(param)) continue;
                it.remove();
            }
        }
        this.queryParams.add((NameValuePair)new BasicNameValuePair(param, value));
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.query = null;
        return this;
    }

    public UriBuilder clearParameters() {
        this.queryParams = null;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        return this;
    }

    public UriBuilder setCustomQuery(String query) {
        this.query = query;
        this.encodedQuery = null;
        this.encodedSchemeSpecificPart = null;
        this.queryParams = null;
        return this;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.path == null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public UriBuilder setScheme(UriScheme uriScheme) {
        this.scheme = uriScheme.getScheme();
        return this;
    }

    public UriBuilder setScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public UriBuilder setUserInfo(String userInfo) {
        this.userInfo = userInfo;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        this.encodedUserInfo = null;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public UriBuilder setHost(String host) {
        this.host = host;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public UriBuilder setPort(int port) {
        this.port = port < 0 ? -1 : port;
        this.encodedSchemeSpecificPart = null;
        this.encodedAuthority = null;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public UriBuilder setPath(String path) {
        this.path = path;
        this.encodedSchemeSpecificPart = null;
        this.encodedPath = null;
        return this;
    }

    public List<NameValuePair> getQueryParams() {
        if (this.queryParams != null) {
            return new ArrayList<NameValuePair>(this.queryParams);
        }
        if (this.query != null) {
            this.queryParams = this.parseQuery(this.query);
            return this.queryParams;
        }
        return new ArrayList<NameValuePair>();
    }

    public Map<String, String> getParams() {
        List<NameValuePair> nameValuePairs = this.getQueryParams();
        HashMap<String, String> data = new HashMap<String, String>();
        for (NameValuePair nameValuePair : nameValuePairs) {
            data.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return data;
    }

    public String getFragment() {
        return this.fragment;
    }

    public UriBuilder setFragment(String fragment) {
        this.fragment = fragment;
        this.encodedFragment = null;
        return this;
    }

    public String toString() {
        return this.buildString(false, false);
    }
}

