/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.setting;

import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.getter.OptNullBasicTypeFromObjectGetter;
import org.gjgr.pig.chivalrous.core.lang.BeanUtil;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.StaticLog;

public abstract class AbsSetting
extends OptNullBasicTypeFromObjectGetter<String> {
    public static final String DEFAULT_DELIMITER = ",";
    private static final Log log = StaticLog.get();

    private static String keyWithGroup(String key, String group) {
        String keyWithGroup = key;
        if (!StringCommand.isBlank(group)) {
            keyWithGroup = group.concat(".").concat(key);
        }
        return keyWithGroup;
    }

    @Override
    public abstract Object getObj(String var1, Object var2);

    public String getStr(String key, String group, String defaultValue) {
        String value = this.getByGroup(key, group);
        if (StringCommand.isBlank(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getByGroup(String key, String group) {
        return this.getStr(AbsSetting.keyWithGroup(key, group));
    }

    public String getWithLog(String key) {
        String value = this.getStr(key);
        if (value == null) {
            log.debug("No key define for [{}]!", key);
        }
        return value;
    }

    public String getByGroupWithLog(String key, String group) {
        String value = this.getByGroup(key, group);
        if (value == null) {
            log.debug("No key define for [{}] of group [{}] !", key, group);
        }
        return value;
    }

    public String[] getStrings(String key) {
        return this.getStrings(key, null);
    }

    public String[] getStringsWithDefault(String key, String[] defaultValue) {
        String[] value = this.getStrings(key, null);
        if (null == value) {
            value = defaultValue;
        }
        return value;
    }

    public String[] getStrings(String key, String group) {
        return this.getStrings(key, group, DEFAULT_DELIMITER);
    }

    public String[] getStrings(String key, String group, String delimiter) {
        String value = this.getByGroup(key, group);
        if (StringCommand.isBlank(value)) {
            return null;
        }
        return StringCommand.split(value, delimiter);
    }

    public Integer getInt(String key, String group) {
        return this.getInt(key, group, null);
    }

    public Integer getInt(String key, String group, Integer defaultValue) {
        return Convert.toInt(this.getByGroup(key, group), defaultValue);
    }

    public Boolean getBool(String key, String group) {
        return this.getBool(key, group, null);
    }

    public Boolean getBool(String key, String group, Boolean defaultValue) {
        return Convert.toBool(this.getByGroup(key, group), defaultValue);
    }

    public Long getLong(String key, String group) {
        return this.getLong(key, group, null);
    }

    public Long getLong(String key, String group, Long defaultValue) {
        return Convert.toLong(this.getByGroup(key, group), defaultValue);
    }

    public Character getChar(String key, String group) {
        String value = this.getByGroup(key, group);
        if (StringCommand.isBlank(value)) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public Double getDouble(String key, String group) {
        return this.getDouble(key, group, null);
    }

    public Double getDouble(String key, String group, Double defaultValue) {
        return Convert.toDouble(this.getByGroup(key, group), defaultValue);
    }

    public Object toBean(final String group, Object bean) {
        return BeanUtil.fillBean(bean, new BeanUtil.ValueProvider<String>(){

            @Override
            public Object value(String key, Class<?> valueType) {
                String value = AbsSetting.this.getByGroup(key, group);
                if (null != value) {
                    log.debug("Parse setting to object field [{}={}]", key, value);
                }
                return value;
            }

            @Override
            public boolean containsKey(String key) {
                return null != AbsSetting.this.getByGroup(key, group);
            }
        }, BeanUtil.CopyOptions.create());
    }

    public Object toBean(Object bean) {
        return this.toBean(null, bean);
    }
}

