/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.setting.dialect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.util.Map;
import java.util.Properties;
import org.gjgr.pig.chivalrous.core.convert.Convert;
import org.gjgr.pig.chivalrous.core.getter.BasicTypeGetter;
import org.gjgr.pig.chivalrous.core.getter.OptBasicTypeGetter;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.io.resource.ClassPathResource;
import org.gjgr.pig.chivalrous.core.io.resource.LocationCommand;
import org.gjgr.pig.chivalrous.core.io.resource.UrlResource;
import org.gjgr.pig.chivalrous.core.io.watch.SimpleWatcher;
import org.gjgr.pig.chivalrous.core.io.watch.WatchMonitor;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.core.setting.SettingRuntimeException;

public final class Props
extends Properties
implements BasicTypeGetter<String>,
OptBasicTypeGetter<String> {
    private static final long serialVersionUID = 1935981579709590740L;
    private static final Log log = StaticLog.get();
    private URL propertiesFileUrl;
    private WatchMonitor watchMonitor;

    public Props() {
    }

    public Props(String pathBaseClassLoader) {
        AssertCommand.notBlank(pathBaseClassLoader, "Blank properties file path !");
        this.load(new ClassPathResource(pathBaseClassLoader));
    }

    public Props(File propertiesFile) {
        AssertCommand.notNull(propertiesFile, "Null properties file!");
        this.load(new UrlResource(propertiesFile));
    }

    public Props(String path, Class<?> clazz) {
        AssertCommand.notBlank(path, "Blank properties file path !");
        this.load(new ClassPathResource(path, clazz));
    }

    public Props(URL propertiesUrl) {
        AssertCommand.notNull(propertiesUrl, "Null properties URL !");
        this.load(new UrlResource(propertiesUrl));
    }

    public Props(Properties properties) {
        if (CollectionCommand.isNotEmpty(properties)) {
            this.putAll((Map<?, ?>)properties);
        }
    }

    public static Properties getProp(String resource) {
        return new Props(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(UrlResource urlResource) {
        this.propertiesFileUrl = urlResource.getUrl();
        if (null == this.propertiesFileUrl) {
            throw new SettingRuntimeException("Can not find properties file: [{}]", urlResource);
        }
        log.debug("Load properties [{}]", this.propertiesFileUrl.getPath());
        InputStream in = null;
        try {
            in = urlResource.getStream();
            super.load(in);
        }
        catch (Exception e) {
            log.error(e, "Load properties error!", new Object[0]);
        }
        finally {
            IoCommand.close(in);
        }
    }

    public void load() {
        this.load(new UrlResource(this.propertiesFileUrl));
    }

    public void autoLoad(boolean autoReload) {
        if (autoReload) {
            if (null != this.watchMonitor) {
                this.watchMonitor.close();
                try {
                    this.watchMonitor = WatchMonitor.create(Paths.get(this.propertiesFileUrl.toURI()), new WatchEvent.Kind[0]);
                    this.watchMonitor.setWatcher(new SimpleWatcher(){

                        @Override
                        public void onModify(WatchEvent<?> event) {
                            Props.this.load();
                        }
                    }).start();
                }
                catch (Exception e) {
                    throw new SettingRuntimeException(e, "Setting auto load not support url: [{}]", this.propertiesFileUrl);
                }
            }
        } else {
            IoCommand.close(this.watchMonitor);
            this.watchMonitor = null;
        }
    }

    @Override
    public Object getObj(String key, Object defaultValue) {
        return this.getStr(key, null == defaultValue ? null : defaultValue.toString());
    }

    @Override
    public String getStr(String key, String defaultValue) {
        return super.getProperty(key, defaultValue);
    }

    @Override
    public Integer getInt(String key, Integer defaultValue) {
        return Convert.toInt(this.getStr(key), defaultValue);
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        return Convert.toShort(this.getStr(key), defaultValue);
    }

    @Override
    public Boolean getBool(String key, Boolean defaultValue) {
        return Convert.toBool(this.getStr(key), defaultValue);
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        return Convert.toLong(this.getStr(key), defaultValue);
    }

    @Override
    public Character getChar(String key, Character defaultValue) {
        String value = this.getStr(key);
        if (StringCommand.isBlank(value)) {
            return defaultValue;
        }
        return Character.valueOf(value.charAt(0));
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        return Convert.toFloat(this.getStr(key), defaultValue);
    }

    @Override
    public Double getDouble(String key, Double defaultValue) throws NumberFormatException {
        return Convert.toDouble(this.getStr(key), defaultValue);
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        return Convert.toByte(this.getStr(key), defaultValue);
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        String valueStr = this.getStr(key);
        if (StringCommand.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigDecimal(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public BigInteger getBigInteger(String key, BigInteger defaultValue) {
        String valueStr = this.getStr(key);
        if (StringCommand.isBlank(valueStr)) {
            return defaultValue;
        }
        try {
            return new BigInteger(valueStr);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key, E defaultValue) {
        return Convert.toEnum(clazz, this.getStr(key), defaultValue);
    }

    @Override
    public Object getObj(String key) {
        return this.getObj(key, (Object)null);
    }

    @Override
    public String getStr(String key) {
        return super.getProperty(key);
    }

    @Override
    public Integer getInt(String key) {
        return this.getInt(key, (Integer)null);
    }

    @Override
    public Short getShort(String key) {
        return this.getShort(key, (Short)null);
    }

    @Override
    public Boolean getBool(String key) {
        return this.getBool(key, (Boolean)null);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, (Long)null);
    }

    @Override
    public Character getChar(String key) {
        return this.getChar(key, (Character)null);
    }

    @Override
    public Float getFloat(String key) {
        return this.getFloat(key, (Float)null);
    }

    @Override
    public Double getDouble(String key) throws NumberFormatException {
        return this.getDouble(key, (Double)null);
    }

    @Override
    public Byte getByte(String key) {
        return this.getByte(key, (Byte)null);
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, (BigDecimal)null);
    }

    @Override
    public BigInteger getBigInteger(String key) {
        return this.getBigInteger(key, (BigInteger)null);
    }

    @Override
    public <E extends Enum<E>> E getEnum(Class<E> clazz, String key) {
        return this.getEnum(clazz, key, (E)null);
    }

    public void setProperty(String key, Object value) {
        super.setProperty(key, value.toString());
    }

    public void store(String absolutePath) {
        try {
            FileCommand.touch(absolutePath);
            super.store(IoCommand.bufferedOutputStream(absolutePath), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            log.error(e, "Store properties to [{}] error!", absolutePath);
        }
    }

    public void store(String path, Class<?> clazz) {
        this.store(LocationCommand.getAbsolutePath(path, clazz));
    }
}

