/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.system;

import java.io.Serializable;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.system.JavaSystemCommand;

public class JavaRuntimeInfo
implements Serializable {
    private final String JAVA_RUNTIME_NAME = JavaSystemCommand.get("java.runtime.name", false);
    private final String JAVA_RUNTIME_VERSION = JavaSystemCommand.get("java.runtime.version", false);
    private final String JAVA_HOME = JavaSystemCommand.get("java.home", false);
    private final String JAVA_EXT_DIRS = JavaSystemCommand.get("java.ext.dirs", false);
    private final String JAVA_ENDORSED_DIRS = JavaSystemCommand.get("java.endorsed.dirs", false);
    private final String JAVA_CLASS_PATH = JavaSystemCommand.get("java.class.path", false);
    private final String JAVA_CLASS_VERSION = JavaSystemCommand.get("java.class.version", false);
    private final String JAVA_LIBRARY_PATH = JavaSystemCommand.get("java.library.path", false);
    private final String SUN_BOOT_CLASS_PATH = JavaSystemCommand.get("sun.boot.class.path", false);
    private final String SUN_ARCH_DATA_MODEL = JavaSystemCommand.get("sun.arch.data.model", false);

    public final String getSunBoothClassPath() {
        return this.SUN_BOOT_CLASS_PATH;
    }

    public final String getSunArchDataModel() {
        return this.SUN_ARCH_DATA_MODEL;
    }

    public final String getName() {
        return this.JAVA_RUNTIME_NAME;
    }

    public final String getVersion() {
        return this.JAVA_RUNTIME_VERSION;
    }

    public final String getHomeDir() {
        return this.JAVA_HOME;
    }

    public final String getExtDirs() {
        return this.JAVA_EXT_DIRS;
    }

    public final String getEndorsedDirs() {
        return this.JAVA_ENDORSED_DIRS;
    }

    public final String getClassPath() {
        return this.JAVA_CLASS_PATH;
    }

    public final String[] getClassPathArray() {
        return StringCommand.split(this.getClassPath(), JavaSystemCommand.get("path.separator", false));
    }

    public final String getClassVersion() {
        return this.JAVA_CLASS_VERSION;
    }

    public final String getLibraryPath() {
        return this.JAVA_LIBRARY_PATH;
    }

    public final String[] getLibraryPathArray() {
        return StringCommand.split(this.getLibraryPath(), JavaSystemCommand.get("path.separator", false));
    }

    public final String getProtocolPackages() {
        return JavaSystemCommand.get("java.protocol.handler.pkgs", true);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        JavaSystemCommand.append(builder, "Java Runtime Name:      ", this.getName());
        JavaSystemCommand.append(builder, "Java Runtime Version:   ", this.getVersion());
        JavaSystemCommand.append(builder, "Java Home Dir:          ", this.getHomeDir());
        JavaSystemCommand.append(builder, "Java Extension Dirs:    ", this.getExtDirs());
        JavaSystemCommand.append(builder, "Java Endorsed Dirs:     ", this.getEndorsedDirs());
        JavaSystemCommand.append(builder, "Java Class Path:        ", this.getClassPath());
        JavaSystemCommand.append(builder, "Java Class Version:     ", this.getClassVersion());
        JavaSystemCommand.append(builder, "Java Library Path:      ", this.getLibraryPath());
        JavaSystemCommand.append(builder, "Java Protocol Packages: ", this.getProtocolPackages());
        return builder.toString();
    }
}

