/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.CsvTranslators;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.JavaUnicodeEscaper;
import org.apache.commons.text.translate.LookupTranslator;
import org.apache.commons.text.translate.NumericEntityEscaper;
import org.apache.commons.text.translate.NumericEntityUnescaper;
import org.apache.commons.text.translate.OctalUnescaper;
import org.apache.commons.text.translate.UnicodeUnescaper;
import org.apache.commons.text.translate.UnicodeUnpairedSurrogateRemover;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public final class CodeCommand {
    public static final CharSequenceTranslator ESCAPE_JAVA;
    public static final CharSequenceTranslator ESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator ESCAPE_JSON;
    public static final CharSequenceTranslator ESCAPE_XML10;
    public static final CharSequenceTranslator ESCAPE_XML11;
    public static final CharSequenceTranslator ESCAPE_HTML3;
    public static final CharSequenceTranslator ESCAPE_HTML4;
    public static final CharSequenceTranslator ESCAPE_CSV;
    public static final Map<CharSequence, CharSequence> escapeXsiMap;
    public static final CharSequenceTranslator ESCAPE_XSI;
    public static final Map<CharSequence, CharSequence> unescapeJavaMap;
    public static final CharSequenceTranslator UNESCAPE_JAVA;
    public static final CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator UNESCAPE_JSON;
    public static final CharSequenceTranslator UNESCAPE_HTML3;
    public static final CharSequenceTranslator UNESCAPE_HTML4;
    public static final CharSequenceTranslator UNESCAPE_XML;
    public static final CharSequenceTranslator UNESCAPE_CSV;
    public static final CharSequenceTranslator UNESCAPE_XSI;

    private CodeCommand() {
    }

    public static String escape(String content) {
        if (StringCommand.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder();
        tmp.ensureCapacity(content.length() * 6);
        for (int i = 0; i < content.length(); ++i) {
            char j = content.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static Builder builder(CharSequenceTranslator translator) {
        return new Builder(translator);
    }

    public static final String escapeJava(String input) {
        return ESCAPE_JAVA.translate((CharSequence)input);
    }

    public static final String escapeEcmaScript(String input) {
        return ESCAPE_ECMASCRIPT.translate((CharSequence)input);
    }

    public static final String escapeJson(String input) {
        return ESCAPE_JSON.translate((CharSequence)input);
    }

    public static final String unescapeJava(String input) {
        return UNESCAPE_JAVA.translate((CharSequence)input);
    }

    public static final String unescapeEcmaScript(String input) {
        return UNESCAPE_ECMASCRIPT.translate((CharSequence)input);
    }

    public static final String unescapeJson(String input) {
        return UNESCAPE_JSON.translate((CharSequence)input);
    }

    public static final String escapeHtml4(String input) {
        return ESCAPE_HTML4.translate((CharSequence)input);
    }

    public static final String escapeHtml3(String input) {
        return ESCAPE_HTML3.translate((CharSequence)input);
    }

    public static final String unescapeHtml4(String input) {
        return UNESCAPE_HTML4.translate((CharSequence)input);
    }

    public static final String unescapeHtml3(String input) {
        return UNESCAPE_HTML3.translate((CharSequence)input);
    }

    public static String escapeXml10(String input) {
        return ESCAPE_XML10.translate((CharSequence)input);
    }

    public static String escapeXml11(String input) {
        return ESCAPE_XML11.translate((CharSequence)input);
    }

    public static final String unescapeXml(String input) {
        return UNESCAPE_XML.translate((CharSequence)input);
    }

    public static final String escapeCsv(String input) {
        return ESCAPE_CSV.translate((CharSequence)input);
    }

    public static final String unescapeCsv(String input) {
        return UNESCAPE_CSV.translate((CharSequence)input);
    }

    public static final String escapeXSI(String input) {
        return ESCAPE_XSI.translate((CharSequence)input);
    }

    public static final String unescapeXSI(String input) {
        return UNESCAPE_XSI.translate((CharSequence)input);
    }

    public static String unescape(String content) {
        if (StringCommand.isBlank(content)) {
            return content;
        }
        StringBuilder tmp = new StringBuilder(content.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < content.length()) {
            pos = content.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (content.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(content.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(content.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(content.substring(lastPos));
                lastPos = content.length();
                continue;
            }
            tmp.append(content.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }

    public static String safeUnescape(String content) {
        try {
            return CodeCommand.unescape(content);
        }
        catch (Exception exception) {
            return content;
        }
    }

    static {
        ESCAPE_HTML3 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE)});
        ESCAPE_HTML4 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE)});
        ESCAPE_CSV = new CsvTranslators.CsvEscaper();
        escapeXsiMap = new HashMap<CharSequence, CharSequence>();
        ESCAPE_XSI = new LookupTranslator(Collections.unmodifiableMap(escapeXsiMap));
        unescapeJavaMap = new HashMap<CharSequence, CharSequence>();
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA = new AggregateTranslator(new CharSequenceTranslator[]{new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE), new LookupTranslator(Collections.unmodifiableMap(unescapeJavaMap))});
        UNESCAPE_JSON = UNESCAPE_JAVA;
        UNESCAPE_HTML3 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])});
        UNESCAPE_HTML4 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])});
        UNESCAPE_XML = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_UNESCAPE), new LookupTranslator(EntityArrays.APOS_UNESCAPE), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0])});
        UNESCAPE_CSV = new CsvTranslators.CsvUnescaper();
        UNESCAPE_XSI = new XsiUnescaper();
        HashMap<String, String> escapeJavaMap = new HashMap<String, String>();
        escapeJavaMap.put("\"", "\\\"");
        escapeJavaMap.put("\\", "\\\\");
        ESCAPE_JAVA = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJavaMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
        HashMap<String, String> escapeEcmaScriptMap = new HashMap<String, String>();
        escapeEcmaScriptMap.put("'", "\\'");
        escapeEcmaScriptMap.put("\"", "\\\"");
        escapeEcmaScriptMap.put("\\", "\\\\");
        escapeEcmaScriptMap.put("/", "\\/");
        ESCAPE_ECMASCRIPT = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeEcmaScriptMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf((int)32, (int)127)});
        HashMap<String, String> escapeJsonMap = new HashMap<String, String>();
        escapeJsonMap.put("\"", "\\\"");
        escapeJsonMap.put("\\", "\\\\");
        escapeJsonMap.put("/", "\\/");
        ESCAPE_JSON = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(Collections.unmodifiableMap(escapeJsonMap)), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE), JavaUnicodeEscaper.outsideOf((int)32, (int)126)});
        HashMap<String, String> escapeXml10Map = new HashMap<String, String>();
        escapeXml10Map.put("\u0000", "");
        escapeXml10Map.put("\u0001", "");
        escapeXml10Map.put("\u0002", "");
        escapeXml10Map.put("\u0003", "");
        escapeXml10Map.put("\u0004", "");
        escapeXml10Map.put("\u0005", "");
        escapeXml10Map.put("\u0006", "");
        escapeXml10Map.put("\u0007", "");
        escapeXml10Map.put("\b", "");
        escapeXml10Map.put("\u000b", "");
        escapeXml10Map.put("\f", "");
        escapeXml10Map.put("\u000e", "");
        escapeXml10Map.put("\u000f", "");
        escapeXml10Map.put("\u0010", "");
        escapeXml10Map.put("\u0011", "");
        escapeXml10Map.put("\u0012", "");
        escapeXml10Map.put("\u0013", "");
        escapeXml10Map.put("\u0014", "");
        escapeXml10Map.put("\u0015", "");
        escapeXml10Map.put("\u0016", "");
        escapeXml10Map.put("\u0017", "");
        escapeXml10Map.put("\u0018", "");
        escapeXml10Map.put("\u0019", "");
        escapeXml10Map.put("\u001a", "");
        escapeXml10Map.put("\u001b", "");
        escapeXml10Map.put("\u001c", "");
        escapeXml10Map.put("\u001d", "");
        escapeXml10Map.put("\u001e", "");
        escapeXml10Map.put("\u001f", "");
        escapeXml10Map.put("\ufffe", "");
        escapeXml10Map.put("\uffff", "");
        ESCAPE_XML10 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(escapeXml10Map)), NumericEntityEscaper.between((int)127, (int)132), NumericEntityEscaper.between((int)134, (int)159), new UnicodeUnpairedSurrogateRemover()});
        HashMap<String, String> escapeXml11Map = new HashMap<String, String>();
        escapeXml11Map.put("\u0000", "");
        escapeXml11Map.put("\u000b", "&#11;");
        escapeXml11Map.put("\f", "&#12;");
        escapeXml11Map.put("\ufffe", "");
        escapeXml11Map.put("\uffff", "");
        ESCAPE_XML11 = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(EntityArrays.APOS_ESCAPE), new LookupTranslator(Collections.unmodifiableMap(escapeXml11Map)), NumericEntityEscaper.between((int)1, (int)8), NumericEntityEscaper.between((int)14, (int)31), NumericEntityEscaper.between((int)127, (int)132), NumericEntityEscaper.between((int)134, (int)159), new UnicodeUnpairedSurrogateRemover()});
        escapeXsiMap.put("|", "\\|");
        escapeXsiMap.put("&", "\\&");
        escapeXsiMap.put(";", "\\;");
        escapeXsiMap.put("<", "\\<");
        escapeXsiMap.put(">", "\\>");
        escapeXsiMap.put("(", "\\(");
        escapeXsiMap.put(")", "\\)");
        escapeXsiMap.put("$", "\\$");
        escapeXsiMap.put("`", "\\`");
        escapeXsiMap.put("\\", "\\\\");
        escapeXsiMap.put("\"", "\\\"");
        escapeXsiMap.put("'", "\\'");
        escapeXsiMap.put(" ", "\\ ");
        escapeXsiMap.put("\t", "\\\t");
        escapeXsiMap.put("\r\n", "");
        escapeXsiMap.put("\n", "");
        escapeXsiMap.put("*", "\\*");
        escapeXsiMap.put("?", "\\?");
        escapeXsiMap.put("[", "\\[");
        escapeXsiMap.put("#", "\\#");
        escapeXsiMap.put("~", "\\~");
        escapeXsiMap.put("=", "\\=");
        escapeXsiMap.put("%", "\\%");
        unescapeJavaMap.put("\\\\", "\\");
        unescapeJavaMap.put("\\\"", "\"");
        unescapeJavaMap.put("\\'", "'");
        unescapeJavaMap.put("\\", "");
    }

    public static final class Builder {
        private final StringBuilder sb = new StringBuilder();
        private final CharSequenceTranslator translator;

        private Builder(CharSequenceTranslator translator) {
            this.translator = translator;
        }

        public static String spaceEscape(String string) {
            string = string.replaceAll("[ ]{2,}", "");
            return string;
        }

        public static String lineEscape(String string) {
            string = string.replaceAll("\n|\r", "");
            return string;
        }

        public Builder escape(String input) {
            this.sb.append(this.translator.translate((CharSequence)input));
            return this;
        }

        public Builder append(String input) {
            this.sb.append(input);
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }

    static class XsiUnescaper
    extends CharSequenceTranslator {
        private static final char BACKSLASH = '\\';

        XsiUnescaper() {
        }

        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("XsiUnescaper should never reach the [1] index");
            }
            String s = input.toString();
            int segmentStart = 0;
            int searchOffset = 0;
            while (true) {
                int pos;
                if ((pos = s.indexOf(92, searchOffset)) == -1) {
                    if (segmentStart >= s.length()) break;
                    out.write(s.substring(segmentStart));
                    break;
                }
                if (pos > segmentStart) {
                    out.write(s.substring(segmentStart, pos));
                }
                segmentStart = pos + 1;
                searchOffset = pos + 2;
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }
}

