/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.util;

import java.util.Locale;
import org.gjgr.pig.chivalrous.core.lang.Nullable;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;

public class LocaleCommand {
    @Nullable
    public static Locale parseLocale(String localeValue) {
        String[] tokens = LocaleCommand.tokenizeLocaleSource(localeValue);
        if (tokens.length == 1) {
            return Locale.forLanguageTag(localeValue);
        }
        return LocaleCommand.parseLocaleTokens(localeValue, tokens);
    }

    @Nullable
    public static Locale parseLocaleString(String localeString) {
        return LocaleCommand.parseLocaleTokens(localeString, LocaleCommand.tokenizeLocaleSource(localeString));
    }

    private static String[] tokenizeLocaleSource(String localeSource) {
        return StringCommand.tokenizeToStringArray(localeSource, "_ ", false, false);
    }

    @Nullable
    private static Locale parseLocaleTokens(String localeString, String[] tokens) {
        int endIndexOfCountryCode;
        String language = tokens.length > 0 ? tokens[0] : "";
        String country = tokens.length > 1 ? tokens[1] : "";
        LocaleCommand.validateLocalePart(language);
        LocaleCommand.validateLocalePart(country);
        String variant = "";
        if (tokens.length > 2 && (variant = StringCommand.trimLeadingWhitespace(localeString.substring(endIndexOfCountryCode = localeString.indexOf(country, language.length()) + country.length()))).startsWith("_")) {
            variant = StringCommand.trimLeadingCharacter(variant, '_');
        }
        return language.length() > 0 ? new Locale(language, country, variant) : null;
    }

    private static void validateLocalePart(String localePart) {
        for (int i = 0; i < localePart.length(); ++i) {
            char ch = localePart.charAt(i);
            if (ch == ' ' || ch == '_' || ch == '#' || Character.isLetterOrDigit(ch)) continue;
            throw new IllegalArgumentException("Locale part \"" + localePart + "\" contains invalid characters");
        }
    }
}

