/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.core.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.core.util.QuickWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.gjgr.pig.chivalrous.core.exceptions.UtilException;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.io.file.FileCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlCommand {
    public static final String INVALID_REGEX = "[\\x00-\\x08\\x0b-\\x0c\\x0e-\\x1f]";
    private static final Logger logger = LoggerFactory.getLogger(XmlCommand.class);

    public static org.w3c.dom.Document readXML(File file) {
        if (file == null) {
            throw new NullPointerException("Xml file is null !");
        }
        if (!file.exists()) {
            throw new UtilException("File [{}] not a isExist!", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("[{}] not a file!", file.getAbsolutePath());
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(file);
        }
        catch (Exception e) {
            throw new UtilException("Parse xml file [" + file.getAbsolutePath() + "] error!", e);
        }
    }

    public static org.w3c.dom.Document readXML(String absoluteFilePath) {
        return XmlCommand.readXML(new File(absoluteFilePath));
    }

    public static org.w3c.dom.Document parseXml(String xmlStr) {
        if (StringCommand.isBlank(xmlStr)) {
            throw new UtilException("Xml content string is empty !");
        }
        xmlStr = XmlCommand.cleanInvalid(xmlStr);
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            return builder.parse(new InputSource(StringCommand.getReader(xmlStr)));
        }
        catch (Exception e) {
            throw new UtilException("Parse xml file [" + xmlStr + "] error!", e);
        }
    }

    public static String toStr(org.w3c.dom.Document doc) {
        return XmlCommand.toStr(doc, "UTF-8");
    }

    public static String toStr(org.w3c.dom.Document doc, String charset) {
        try {
            StringWriter writer = StringCommand.getWriter();
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", charset);
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(new DOMSource(doc), new StreamResult(writer));
            return writer.toString();
        }
        catch (Exception e) {
            throw new UtilException("Trans xml document to string error!", e);
        }
    }

    public static void toFile(org.w3c.dom.Document doc, String absolutePath) {
        XmlCommand.toFile(doc, absolutePath, null);
    }

    public static void toFile(org.w3c.dom.Document doc, String absolutePath, String charset) {
        if (StringCommand.isBlank(charset)) {
            charset = doc.getXmlEncoding();
        }
        if (StringCommand.isBlank(charset)) {
            charset = "UTF-8";
        }
        BufferedWriter writer = null;
        try {
            writer = FileCommand.bufferedWriter(absolutePath, charset, false);
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("encoding", charset);
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, new StreamResult(writer));
        }
        catch (Exception e) {
            try {
                throw new UtilException("Trans xml document to string error!", e);
            }
            catch (Throwable throwable) {
                IoCommand.close(writer);
                throw throwable;
            }
        }
        IoCommand.close(writer);
    }

    public static org.w3c.dom.Document createXml(String rootElementName) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new UtilException("Create xml document error!", e);
        }
        org.w3c.dom.Document doc = builder.newDocument();
        doc.appendChild(doc.createElement(rootElementName));
        return doc;
    }

    public static String cleanInvalid(String xmlContent) {
        if (xmlContent == null) {
            return null;
        }
        return xmlContent.replaceAll(INVALID_REGEX, "");
    }

    public static List<Element> getElements(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        return XmlCommand.transElements(element, nodeList);
    }

    public static Element getElement(Element element, String tagName) {
        NodeList nodeList = element.getElementsByTagName(tagName);
        if (nodeList == null || nodeList.getLength() < 1) {
            return null;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element childEle = (Element)nodeList.item(i);
            if (childEle != null && childEle.getParentNode() != element) continue;
            return childEle;
        }
        return null;
    }

    public static String elementText(Element element, String tagName) {
        Element child = XmlCommand.getElement(element, tagName);
        return child == null ? null : child.getTextContent();
    }

    public static String elementText(Element element, String tagName, String defaultValue) {
        Element child = XmlCommand.getElement(element, tagName);
        return child == null ? defaultValue : child.getTextContent();
    }

    public static List<Element> transElements(NodeList nodeList) {
        return XmlCommand.transElements(null, nodeList);
    }

    public static List<Element> transElements(Element parentEle, NodeList nodeList) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)nodeList.item(i);
            if (parentEle != null && element.getParentNode() != parentEle) continue;
            elements.add(element);
        }
        return elements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void writeObjectAsXml(File dest, T t) throws IOException {
        FileOutputStream fos = null;
        XMLEncoder xmlenc = null;
        try {
            fos = new FileOutputStream(dest);
            xmlenc = new XMLEncoder(new BufferedOutputStream(fos));
            xmlenc.writeObject(t);
        }
        catch (Throwable throwable) {
            IoCommand.close(fos);
            if (xmlenc != null) {
                xmlenc.close();
            }
            throw throwable;
        }
        IoCommand.close(fos);
        if (xmlenc != null) {
            xmlenc.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readObjectFromXml(File source) throws IOException {
        Object result = null;
        FileInputStream fis = null;
        XMLDecoder xmldec = null;
        try {
            fis = new FileInputStream(source);
            xmldec = new XMLDecoder(new BufferedInputStream(fis));
            result = xmldec.readObject();
        }
        catch (Throwable throwable) {
            IoCommand.close(fis);
            if (xmldec != null) {
                xmldec.close();
            }
            throw throwable;
        }
        IoCommand.close(fis);
        if (xmldec != null) {
            xmldec.close();
        }
        return (T)result;
    }

    public static String convertToXml(Object obj) {
        StringWriter sw = new StringWriter();
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(obj, (Writer)sw);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        return sw.toString();
    }

    public static void convertToXml(Object obj, String path) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)false);
            OutputStreamWriter isr = null;
            try {
                isr = new OutputStreamWriter((OutputStream)new FileOutputStream(path), "UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            logger.debug("covert Object:{} to xml:{} success. ", obj.getClass(), (Object)path);
            marshaller.marshal(obj, (Writer)isr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public static <T> T convertXmlStrToObject(Class clazz, String xmlStr) {
        Object xmlObject = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader sr = new StringReader(xmlStr);
            xmlObject = unmarshaller.unmarshal((Reader)sr);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            logger.error("JAXBException did not covert success. {}", (Object)clazz);
            return null;
        }
        logger.debug("covert xml str  to object success.{}", (Object)clazz);
        return (T)xmlObject;
    }

    public static <T> T convertStreamFileToObject(Class clazz, InputStream inputStream) {
        Object xmlObject = null;
        if (inputStream == null) {
            return null;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object fr = null;
            InputStreamReader isr = null;
            try {
                isr = new InputStreamReader(inputStream, "UTF-8");
                xmlObject = unmarshaller.unmarshal((Reader)isr);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("the Encode does not isExist!" + e.getMessage());
                return null;
            }
            catch (Exception e) {
                logger.error("convert fail!" + e.getMessage());
                return null;
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
            logger.error("covert xml to object fail.");
            return null;
        }
        if (xmlObject == null) {
            logger.info("Xml did not newJson succss.{},{}", (Object)inputStream, (Object)clazz);
        } else {
            logger.debug("Xml:{} to object:{} success.", (Object)inputStream, (Object)clazz);
        }
        return (T)xmlObject;
    }

    public static <T> T convertXmlFileToObject(Class clazz, String xmlPath) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(xmlPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        return XmlCommand.convertStreamFileToObject(clazz, fileInputStream);
    }

    public static XStream getXStream() {
        DomDriver domDriver = new DomDriver(){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new PrettyPrintWriter(out){

                    protected void writeText(QuickWriter writer, String text) {
                        if (text.startsWith("<![CDATA[") && text.endsWith("]]>")) {
                            writer.write(text);
                        } else {
                            super.writeText(writer, "<![CDATA[" + text + "]]>");
                        }
                    }
                };
            }
        };
        XStream xStream = new XStream((HierarchicalStreamDriver)domDriver){

            protected MapperWrapper wrapMapper(MapperWrapper next) {
                return new MapperWrapper((Mapper)next){

                    public boolean shouldSerializeMember(Class definedIn, String fieldName) {
                        if (definedIn == Object.class) {
                            try {
                                return this.realClass(fieldName) != null;
                            }
                            catch (Exception e) {
                                return false;
                            }
                        }
                        return super.shouldSerializeMember(definedIn, fieldName);
                    }
                };
            }
        };
        return xStream;
    }

    public static String getStairText(String xml, String elementName) {
        elementName = elementName.toLowerCase();
        String result = null;
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            org.dom4j.Element root = doc.getRootElement();
            Iterator iterTemp = root.elementIterator();
            while (iterTemp.hasNext()) {
                org.dom4j.Element element = (org.dom4j.Element)iterTemp.next();
                if (!element.getName().toLowerCase().equals(elementName)) continue;
                result = element.getText();
            }
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Object xmlToBean(String xml, Map<String, Class<?>> map) {
        XStream xStream = XmlCommand.getXStream();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            xStream.alias(key, map.get(key));
        }
        return xStream.fromXML(xml);
    }

    public static String beanToXml(Object bean, Class<?> rootClass) {
        XStream xStream = XmlCommand.getXStream();
        xStream.alias("xml", rootClass);
        String content = xStream.toXML(bean);
        content = content.replaceAll("&lt;", "<");
        content = content.replaceAll("&gt;", ">");
        return content;
    }
}

