/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.Entity;
import org.gjgr.pig.chivalrous.db.Page;
import org.gjgr.pig.chivalrous.db.PageResult;
import org.gjgr.pig.chivalrous.db.SqlRunner;
import org.gjgr.pig.chivalrous.db.ds.pooled.PooledDataSource;
import org.gjgr.pig.chivalrous.db.handler.EntityHandler;
import org.gjgr.pig.chivalrous.db.handler.EntityListHandler;

public class DaoTemplate {
    protected String tableName;
    protected String primaryKeyField = "id";
    protected SqlRunner runner;

    public DaoTemplate(String tableName) {
        this(tableName, (String)null);
    }

    public DaoTemplate(String tableName, String primaryKeyField) {
        this(tableName, primaryKeyField, PooledDataSource.getDataSource());
    }

    public DaoTemplate(String tableName, DataSource ds) {
        this(tableName, null, ds);
    }

    public DaoTemplate(String tableName, String primaryKeyField, DataSource ds) {
        this(tableName, primaryKeyField, DbUtil.newSqlRunner(ds));
    }

    public DaoTemplate(String tableName, String primaryKeyField, SqlRunner runner) {
        this.tableName = tableName;
        if (StringCommand.isNotBlank((CharSequence)primaryKeyField)) {
            this.primaryKeyField = primaryKeyField;
        }
        this.runner = runner;
    }

    public int add(Entity entity) throws SQLException {
        return this.runner.insert(this.fixEntity(entity));
    }

    public List<Object> addForGeneratedKeys(Entity entity) throws SQLException {
        return this.runner.insertForGeneratedKeys(this.fixEntity(entity));
    }

    public Long addForGeneratedKey(Entity entity) throws SQLException {
        return this.runner.insertForGeneratedKey(this.fixEntity(entity));
    }

    public <T> int del(T pk) throws SQLException {
        if (pk == null) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(this.primaryKeyField, pk));
    }

    public <T> int del(String field, T value) throws SQLException {
        if (StringCommand.isBlank((CharSequence)field)) {
            return 0;
        }
        return this.del(Entity.create(this.tableName).set(field, value));
    }

    public <T> int del(Entity where) throws SQLException {
        if (CollectionCommand.isEmpty((Map)((Object)where))) {
            return 0;
        }
        return this.runner.del(this.fixEntity(where));
    }

    public int update(Entity record, Entity where) throws SQLException {
        if (CollectionCommand.isEmpty((Map)((Object)record))) {
            return 0;
        }
        return this.runner.update(this.fixEntity(record), where);
    }

    public int update(Entity entity) throws SQLException {
        if (CollectionCommand.isEmpty((Map)((Object)entity))) {
            return 0;
        }
        Object pk = (entity = this.fixEntity(entity)).get(this.primaryKeyField);
        if (null == pk) {
            throw new SQLException(StringCommand.format((String)"Please determine `{}` for update", (Object[])new Object[]{this.primaryKeyField}));
        }
        Entity where = Entity.create(this.tableName).set(this.primaryKeyField, pk);
        Entity record = entity.clone();
        record.remove(this.primaryKeyField);
        return this.runner.update(record, where);
    }

    public int addOrUpdate(Entity entity) throws SQLException {
        return null == entity.get(this.primaryKeyField) ? this.add(entity) : this.update(entity);
    }

    public <T> Entity get(T pk) throws SQLException {
        return this.get(this.primaryKeyField, pk);
    }

    public <T> Entity get(String field, T value) throws SQLException {
        return this.get(Entity.create(this.tableName).set(field, value));
    }

    public Entity get(Entity where) throws SQLException {
        return this.runner.find(null, this.fixEntity(where), new EntityHandler());
    }

    public <T> List<Entity> find(String field, T value) throws SQLException {
        return this.find(Entity.create(this.tableName).set(field, value));
    }

    public List<Entity> findAll() throws SQLException {
        return this.find(Entity.create(this.tableName));
    }

    public List<Entity> find(Entity where) throws SQLException {
        return this.runner.find(null, this.fixEntity(where), new EntityListHandler());
    }

    public List<Entity> findBySql(String sql, Object ... params) throws SQLException {
        String selectKeyword = StringCommand.subPre((String)sql.trim(), (int)6).toLowerCase();
        if (!"select".equals(selectKeyword)) {
            sql = "SELECT * FROM " + this.tableName + " " + sql;
        }
        return this.runner.query(sql, new EntityListHandler(), params);
    }

    public PageResult<Entity> page(Entity where, Page page, String ... selectFields) throws SQLException {
        return this.runner.page(Arrays.asList(selectFields), this.fixEntity(where), page);
    }

    public PageResult<Entity> page(Entity where, Page page) throws SQLException {
        return this.runner.page(this.fixEntity(where), page);
    }

    public int count(Entity where) throws SQLException {
        return this.runner.count(this.fixEntity(where));
    }

    public boolean exist(Entity where) throws SQLException {
        return this.count(where) > 0;
    }

    private Entity fixEntity(Entity entity) {
        if (null == entity) {
            entity = Entity.create(this.tableName);
        } else if (StringCommand.isBlank((CharSequence)entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return entity;
    }
}

