/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gjgr.pig.chivalrous.core.io.IoCommand;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.lang.ClassCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.Dict;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private String tableName;
    private Set<String> fieldNames;

    public Entity() {
    }

    public Entity(String tableName) {
        this.tableName = tableName;
    }

    public static Entity create() {
        return new Entity();
    }

    public static Entity create(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity parse(T bean) {
        return Entity.create(null).parseBean((Object)bean);
    }

    public String getTableName() {
        return this.tableName;
    }

    public Entity setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public Set<String> getFieldNames() {
        return this.fieldNames;
    }

    public Entity setFieldNames(String ... fieldNames) {
        if (ArrayCommand.isNotEmpty((Object[])fieldNames)) {
            this.fieldNames = CollectionCommand.newHashSet((Object[])fieldNames);
        }
        return this;
    }

    public Entity setFieldNames(List<String> fieldNames) {
        if (CollectionCommand.isNotEmpty(fieldNames)) {
            this.fieldNames = new HashSet<String>(fieldNames);
        }
        return this;
    }

    public Entity addFieldNames(String ... fieldNames) {
        if (ArrayCommand.isNotEmpty((Object[])fieldNames)) {
            if (null == this.fieldNames) {
                return this.setFieldNames(fieldNames);
            }
            for (String fieldName : fieldNames) {
                this.fieldNames.add(fieldName);
            }
        }
        return this;
    }

    public <T> Entity parseBean(T bean) {
        String tableName = bean.getClass().getSimpleName();
        tableName = StringCommand.lowerFirst((String)tableName);
        this.setTableName(tableName);
        return (Entity)super.parseBean(bean);
    }

    public Entity set(String field, Object value) {
        return (Entity)super.set(field, value);
    }

    public Entity setIgnoreNull(String field, Object value) {
        return (Entity)super.setIgnoreNull(field, value);
    }

    public String getStr(String field) {
        Object obj = this.get(field);
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            Reader reader = null;
            try {
                reader = clob.getCharacterStream();
                String string = IoCommand.read((Reader)reader);
                return string;
            }
            catch (IOException | SQLException e) {
                throw new DbRuntimeException(e);
            }
            finally {
                IoCommand.close((Closeable)reader);
            }
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StringCommand.str((byte[])rowId.getBytes(), (String)"UTF-8");
        }
        return super.getStr(field);
    }

    public Date getDate(String field) {
        Object obj = this.get(field);
        Date result = null;
        if (null != obj) {
            try {
                result = (Date)obj;
            }
            catch (Exception e) {
                result = (Date)ClassCommand.invoke((Object)obj, (String)"dateValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Time getTime(String field) {
        Object obj = this.get(field);
        Time result = null;
        if (null != obj) {
            try {
                result = (Time)obj;
            }
            catch (Exception e) {
                result = (Time)ClassCommand.invoke((Object)obj, (String)"timeValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Timestamp getTimestamp(String field) {
        Object obj = this.get(field);
        Timestamp result = null;
        if (null != obj) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception e) {
                result = (Timestamp)ClassCommand.invoke((Object)obj, (String)"timestampValue", (Object[])new Object[0]);
            }
        }
        return result;
    }

    public Entity clone() {
        return (Entity)super.clone();
    }

    public Object put(String key, Object value) {
        if (CollectionCommand.isEmpty(this.fieldNames) || this.fieldNames.contains(key)) {
            super.put((Object)key, value);
        }
        return null;
    }

    public Clob getClob(String field) {
        return (Clob)this.get(field, null);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String field) {
        Object obj = this.get(field);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbRuntimeException("Value of field [{}] is not a rowid!", field);
    }

    public String toString() {
        return "Entity {tableName=" + this.tableName + ", fieldNames=" + this.fieldNames + ", fields=" + super.toString() + "}";
    }
}

