/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.util.Arrays;
import org.gjgr.pig.chivalrous.core.lang.ArrayCommand;
import org.gjgr.pig.chivalrous.core.util.PageUtil;
import org.gjgr.pig.chivalrous.db.sql.Order;

public class Page {
    private int pageNumber;
    private int numPerPage;
    private Order[] orders;

    public Page(int pageNumber, int numPerPage) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
        this.numPerPage = numPerPage <= 0 ? 20 : numPerPage;
    }

    public Page(int pageNumber, int numPerPage, Order order) {
        this(pageNumber, numPerPage);
        this.orders = new Order[]{order};
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber < 0 ? 0 : pageNumber;
    }

    public int getNumPerPage() {
        return this.numPerPage;
    }

    public void setNumPerPage(int numPerPage) {
        this.numPerPage = numPerPage <= 0 ? 20 : numPerPage;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrder(Order ... orders) {
        this.orders = orders;
    }

    public void addOrder(Order ... orders) {
        if (null != this.orders) {
            ArrayCommand.append((Object[])this.orders, (Object[])orders);
        }
        this.orders = orders;
    }

    public int getStartPosition() {
        return this.getStartEnd()[0];
    }

    public int getEndPosition() {
        return this.getStartEnd()[0];
    }

    public int[] getStartEnd() {
        return PageUtil.transToStartEnd((int)this.pageNumber, (int)this.numPerPage);
    }

    public String toString() {
        return "Page [page=" + this.pageNumber + ", numPerPage=" + this.numPerPage + ", order=" + Arrays.toString(this.orders) + "]";
    }
}

