/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.util.ArrayList;
import org.gjgr.pig.chivalrous.core.util.PageUtil;

public class PageResult<T>
extends ArrayList<T> {
    public static final int DEFAULT_NUMBER_PER_PAGE = 20;
    private static final long serialVersionUID = 9056411043515781783L;
    private int page;
    private int numPerPage;
    private int totalPage;
    private int total;

    public PageResult(int page, int numPerPage) {
        super(numPerPage <= 0 ? 20 : numPerPage);
        this.page = page <= 0 ? 0 : page;
        this.numPerPage = numPerPage <= 0 ? 20 : numPerPage;
    }

    public PageResult(int page, int numPerPage, int total) {
        this(page, numPerPage);
        this.total = total;
        this.totalPage = PageUtil.totalPage((int)total, (int)numPerPage);
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public int getNumPerPage() {
        return this.numPerPage;
    }

    public void setNumPerPage(int numPerPage) {
        this.numPerPage = numPerPage;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public boolean isFirst() {
        return this.page == 0;
    }

    public boolean isLast() {
        return this.page >= this.totalPage;
    }
}

