/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.Log;
import org.gjgr.pig.chivalrous.core.log.LogFactory;
import org.gjgr.pig.chivalrous.db.AbstractSqlRunner;
import org.gjgr.pig.chivalrous.db.DbRuntimeException;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.SqlConnRunner;
import org.gjgr.pig.chivalrous.db.dialect.DialectFactory;

public class Session
extends AbstractSqlRunner
implements Closeable {
    private static final Log log = LogFactory.get();
    private Connection conn = null;
    private Boolean isSupportTransaction = null;

    public Session(DataSource ds) {
        try {
            this.conn = ds.getConnection();
        }
        catch (SQLException e) {
            throw new DbRuntimeException("Get connection error!", e);
        }
        this.runner = new SqlConnRunner(DialectFactory.newDialect(this.conn));
    }

    public Session(Connection conn) {
        this.conn = conn;
        this.runner = new SqlConnRunner(DialectFactory.newDialect(conn));
    }

    public static Session create(DataSource ds) {
        return new Session(ds);
    }

    public static Session create(Connection conn) {
        return new Session(conn);
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void beginTransaction() throws SQLException {
        if (null == this.isSupportTransaction) {
            this.isSupportTransaction = this.conn.getMetaData().supportsTransactions();
        } else if (!this.isSupportTransaction.booleanValue()) {
            throw new SQLException("Transaction not supported for current database!");
        }
        this.conn.setAutoCommit(false);
    }

    public void commit() throws SQLException {
        try {
            this.conn.commit();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    public void rollback() throws SQLException {
        try {
            this.conn.rollback();
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    public void quietRollback() {
        try {
            this.conn.rollback();
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error((Throwable)e);
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            this.conn.setAutoCommit(true);
        }
    }

    public void quietRollback(Savepoint savepoint) throws SQLException {
        try {
            this.conn.rollback(savepoint);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            try {
                this.conn.setAutoCommit(true);
            }
            catch (SQLException e) {
                log.error((Throwable)e);
            }
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (!this.conn.getMetaData().supportsTransactionIsolationLevel(level)) {
            throw new SQLException(StringCommand.format((String)"Transaction isolation [{}] not support!", (Object[])new Object[]{level}));
        }
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.conn;
    }

    @Override
    public void closeConnection(Connection conn) {
    }

    @Override
    public SqlConnRunner getRunner() {
        return this.runner;
    }

    @Override
    public void setRunner(SqlConnRunner runner) {
        this.runner = runner;
    }

    @Override
    public void close() {
        DbUtil.close(this.conn);
    }
}

