/*
 * Decompiled with CFR 0.152.
 */
package org.gjgr.pig.chivalrous.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.gjgr.pig.chivalrous.core.lang.AssertCommand;
import org.gjgr.pig.chivalrous.core.lang.CollectionCommand;
import org.gjgr.pig.chivalrous.core.lang.StringCommand;
import org.gjgr.pig.chivalrous.core.log.StaticLog;
import org.gjgr.pig.chivalrous.db.DbUtil;
import org.gjgr.pig.chivalrous.db.Entity;
import org.gjgr.pig.chivalrous.db.Page;
import org.gjgr.pig.chivalrous.db.PageResult;
import org.gjgr.pig.chivalrous.db.dialect.Dialect;
import org.gjgr.pig.chivalrous.db.dialect.DialectFactory;
import org.gjgr.pig.chivalrous.db.handler.EntityListHandler;
import org.gjgr.pig.chivalrous.db.handler.NumberHandler;
import org.gjgr.pig.chivalrous.db.handler.PageResultHandler;
import org.gjgr.pig.chivalrous.db.handler.RsHandler;
import org.gjgr.pig.chivalrous.db.sql.Condition;
import org.gjgr.pig.chivalrous.db.sql.Query;
import org.gjgr.pig.chivalrous.db.sql.SqlExecutor;

public class SqlConnRunner {
    private Dialect dialect;

    public SqlConnRunner(Dialect dialect) {
        StaticLog.info((String)"Use Dialect: [{}].", (Object[])new Object[]{dialect.getClass().getSimpleName()});
        this.dialect = dialect;
    }

    public SqlConnRunner(String driverClassName) {
        this(DialectFactory.newDialect(driverClassName));
    }

    public static SqlConnRunner create(Dialect dialect) {
        return new SqlConnRunner(dialect);
    }

    public static SqlConnRunner create(DataSource ds) {
        return new SqlConnRunner(DialectFactory.newDialect(ds));
    }

    public static SqlConnRunner create(String driverClassName) {
        return new SqlConnRunner(driverClassName);
    }

    public int insert(Connection conn, Entity record) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty((Map)((Object)record))) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int[] insert(Connection conn, Collection<Entity> records) throws SQLException {
        Object object;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty(records)) {
            return new int[]{0};
        }
        Entity template = records.iterator().next();
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, template);
            ps.clearBatch();
            for (Entity entity : records) {
                DbUtil.fillParams(ps, entity.values().toArray(new Object[entity.size()]));
                ps.addBatch();
            }
            object = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return object;
    }

    public List<Object> insertForGeneratedKeys(Connection conn, Entity record) throws SQLException {
        List<Object> list;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty((Map)((Object)record))) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            list = DbUtil.getGeneratedKeys(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return list;
    }

    public Long insertForGeneratedKey(Connection conn, Entity record) throws SQLException {
        Long l;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty((Map)((Object)record))) {
            throw new SQLException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForInsert(conn, record);
            ps.executeUpdate();
            l = DbUtil.getGeneratedKeyOfLong(ps);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return l;
    }

    public int del(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty((Map)((Object)where))) {
            throw new SQLException("Empty entity provided!");
        }
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public int update(Connection conn, Entity record, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        if (CollectionCommand.isEmpty((Map)((Object)record))) {
            throw new SQLException("Empty entity provided!");
        }
        if (CollectionCommand.isEmpty((Map)((Object)where))) {
            throw new SQLException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StringCommand.isBlank((CharSequence)tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(DbUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws SQLException {
        T t;
        this.checkConn(conn);
        AssertCommand.notNull((Object)query, (String)"[query] is null !");
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForFind(conn, query);
            t = SqlExecutor.query(ps, rsh, new Object[0]);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return t;
    }

    public <T> T find(Connection conn, Collection<String> fields, Entity where, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        return this.find(conn, query, rsh);
    }

    public <T> T find(Connection conn, Entity where, RsHandler<T> rsh) throws SQLException {
        return this.find(conn, null, where, rsh);
    }

    public List<Entity> findAll(Connection conn, Entity where) throws SQLException {
        return this.find(conn, where, EntityListHandler.create());
    }

    public List<Entity> findAll(Connection conn, String tableName) throws SQLException {
        return this.findAll(conn, Entity.create(tableName));
    }

    public List<Entity> findBy(Connection conn, String tableName, String field, Object value) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, value));
    }

    public List<Entity> findLike(Connection conn, String tableName, String field, String value, Condition.LikeType likeType) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, DbUtil.buildLikeValue(value, likeType)));
    }

    public List<Entity> findIn(Connection conn, String tableName, String field, Object ... values) throws SQLException {
        return this.findAll(conn, Entity.create(tableName).set(field, values));
    }

    public int count(Connection conn, Entity where) throws SQLException {
        int n;
        this.checkConn(conn);
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForCount(conn, query);
            n = SqlExecutor.query(ps, new NumberHandler(), new Object[0]).intValue();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                DbUtil.close(ps);
                throw throwable;
            }
        }
        DbUtil.close(ps);
        return n;
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, int pageNumber, int numPerPage, RsHandler<T> rsh) throws SQLException {
        return this.page(conn, fields, where, new Page(pageNumber, numPerPage), rsh);
    }

    public <T> T page(Connection conn, Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            return this.find(conn, fields, where, rsh);
        }
        Query query = new Query(DbUtil.buildConditions(where), where.getTableName());
        query.setFields(fields);
        query.setPage(page);
        return SqlExecutor.queryAndClosePs(this.dialect.psForPage(conn, query), rsh, new Object[0]);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, int page, int numPerPage) throws SQLException {
        this.checkConn(conn);
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page, numPerPage, count));
        return this.page(conn, fields, where, page, numPerPage, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Collection<String> fields, Entity where, Page page) throws SQLException {
        this.checkConn(conn);
        if (null == page) {
            List<Entity> entityList = this.find(conn, fields, where, new EntityListHandler());
            PageResult<Entity> pageResult = new PageResult<Entity>(0, entityList.size(), entityList.size());
            pageResult.addAll(entityList);
            return pageResult;
        }
        int count = this.count(conn, where);
        PageResultHandler pageResultHandler = PageResultHandler.create(new PageResult<Entity>(page.getPageNumber(), page.getNumPerPage(), count));
        return this.page(conn, fields, where, page, pageResultHandler);
    }

    public PageResult<Entity> page(Connection conn, Entity where, Page page) throws SQLException {
        return this.page(conn, null, where, page);
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    private void checkConn(Connection conn) {
        if (null == conn) {
            throw new NullPointerException("Connection object is null!");
        }
    }
}

